/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import user.service.DatabaseConnection;
import user.service.EmailService;

public class UserService {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean registerUser(String string, String string2, String string3, String string4, String string5, Date date, String string6) {
        String string7 = "INSERT INTO users (username, password, full_name, email, address, dob, gender, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'active')";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                System.err.println("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i database");
                boolean bl = false;
                return bl;
            }
            if (this.isUsernameExists(string)) {
                System.err.println("\u274c Username \u0111\u00e3 t\u1ed3n t\u1ea1i: " + string);
                boolean bl = false;
                return bl;
            }
            if (this.isEmailExistsInDB(string4)) {
                System.err.println("\u274c Email \u0111\u00e3 \u0111\u01b0\u1ee3c \u0111\u0103ng k\u00fd: " + string4);
                boolean bl = false;
                this.closeResources(connection, preparedStatement, null);
                return bl;
            }
            String string8 = this.hashPassword(string2);
            preparedStatement = connection.prepareStatement(string7);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string8);
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, string4);
            preparedStatement.setString(5, string5);
            preparedStatement.setDate(6, date);
            preparedStatement.setString(7, string6);
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 \u0110\u0103ng k\u00fd th\u00e0nh c\u00f4ng: " + string);
                boolean bl = true;
                this.closeResources(connection, preparedStatement, null);
                return bl;
            }
            this.closeResources(connection, preparedStatement, null);
            return false;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi \u0111\u0103ng k\u00fd user: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
        finally {
            this.closeResources(connection, preparedStatement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> login(String string, String string2) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        HashMap<String, Object> hashMap;
        block9: {
            block11: {
                String string3;
                String string4;
                String string5;
                int n;
                String string6;
                block10: {
                    String string7;
                    block8: {
                        hashMap = new HashMap<String, Object>();
                        hashMap.put("success", false);
                        string7 = "SELECT user_id, username, password, full_name, email, status FROM users WHERE username = ? OR email = ?";
                        connection = null;
                        preparedStatement = null;
                        resultSet = null;
                        connection = this.dbConnection.getConnection();
                        if (connection != null) break block8;
                        hashMap.put("message", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn database!");
                        HashMap<String, Object> hashMap2 = hashMap;
                        this.closeResources(connection, preparedStatement, resultSet);
                        return hashMap2;
                    }
                    preparedStatement = connection.prepareStatement(string7);
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block9;
                    string6 = resultSet.getString("password");
                    String string8 = resultSet.getString("status");
                    n = resultSet.getInt("user_id");
                    string5 = resultSet.getString("username");
                    string4 = resultSet.getString("full_name");
                    string3 = resultSet.getString("email");
                    if (!"locked".equals(string8)) break block10;
                    System.err.println("\u274c T\u00e0i kho\u1ea3n \u0111\u00e3 b\u1ecb kh\u00f3a: " + string);
                    hashMap.put("message", "T\u00e0i kho\u1ea3n c\u1ee7a b\u1ea1n \u0111\u00e3 b\u1ecb kh\u00f3a. Vui l\u00f2ng li\u00ean h\u1ec7 admin!");
                    HashMap<String, Object> hashMap3 = hashMap;
                    this.closeResources(connection, preparedStatement, resultSet);
                    return hashMap3;
                }
                if (!this.checkPasswordHash(string2, string6)) break block11;
                System.out.println("\u2705 \u0110\u0103ng nh\u1eadp th\u00e0nh c\u00f4ng: " + string5);
                this.updateLastLogin(n);
                this.logLoginHistory(n);
                hashMap.put("success", true);
                hashMap.put("message", "\u0110\u0103ng nh\u1eadp th\u00e0nh c\u00f4ng!");
                hashMap.put("user_id", n);
                hashMap.put("username", string5);
                hashMap.put("full_name", string4);
                hashMap.put("email", string3);
                HashMap<String, Object> hashMap4 = hashMap;
                this.closeResources(connection, preparedStatement, resultSet);
                return hashMap4;
            }
            System.err.println("\u274c Sai m\u1eadt kh\u1ea9u");
            hashMap.put("message", "Sai m\u1eadt kh\u1ea9u! Vui l\u00f2ng th\u1eed l\u1ea1i.");
            HashMap<String, Object> hashMap5 = hashMap;
            this.closeResources(connection, preparedStatement, resultSet);
            return hashMap5;
        }
        try {
            System.err.println("\u274c Kh\u00f4ng t\u00ecm th\u1ea5y t\u00e0i kho\u1ea3n: " + string);
            hashMap.put("message", "T\u00e0i kho\u1ea3n kh\u00f4ng t\u1ed3n t\u1ea1i! Vui l\u00f2ng ki\u1ec3m tra l\u1ea1i.");
            HashMap<String, Object> hashMap6 = hashMap;
            this.closeResources(connection, preparedStatement, resultSet);
            return hashMap6;
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u274c L\u1ed7i khi \u0111\u0103ng nh\u1eadp: " + sQLException.getMessage());
                sQLException.printStackTrace();
                hashMap.put("message", "L\u1ed7i database: " + sQLException.getMessage());
                this.closeResources(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateProfile(String string, String string2, String string3, String string4, Date date, String string5) {
        String string6 = "UPDATE users SET full_name = ?, email = ?, address = ?, dob = ?, gender = ? WHERE username = ?";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            if (this.isEmailExistsForOtherUser(string3, string)) {
                System.err.println("\u274c Email \u0111\u00e3 \u0111\u01b0\u1ee3c s\u1eed d\u1ee5ng b\u1edfi t\u00e0i kho\u1ea3n kh\u00e1c");
                boolean bl = false;
                this.closeResources(connection, preparedStatement, null);
                return bl;
            }
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, string3);
            preparedStatement.setString(3, string4);
            preparedStatement.setDate(4, date);
            preparedStatement.setString(5, string5);
            preparedStatement.setString(6, string);
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 C\u1eadp nh\u1eadt th\u00f4ng tin th\u00e0nh c\u00f4ng: " + string);
                boolean bl = true;
                this.closeResources(connection, preparedStatement, null);
                return bl;
            }
            this.closeResources(connection, preparedStatement, null);
            return false;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt profile: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
        finally {
            this.closeResources(connection, preparedStatement, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePassword(String string, String string2, String string3) {
        PreparedStatement preparedStatement;
        Connection connection;
        String string4;
        block7: {
            Map<String, Object> map = this.login(string, string2);
            if (!((Boolean)map.get("success")).booleanValue()) {
                System.err.println("\u274c M\u1eadt kh\u1ea9u c\u0169 kh\u00f4ng \u0111\u00fang");
                return false;
            }
            string4 = "UPDATE users SET password = ? WHERE username = ?";
            connection = null;
            preparedStatement = null;
            connection = this.dbConnection.getConnection();
            if (connection != null) break block7;
            boolean bl = false;
            this.closeResources(connection, preparedStatement, null);
            return bl;
        }
        try {
            String string5 = this.hashPassword(string3);
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string);
            int n = preparedStatement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 \u0110\u1ed5i m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng: " + string);
                boolean bl = true;
                this.closeResources(connection, preparedStatement, null);
                return bl;
            }
            this.closeResources(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u274c L\u1ed7i khi \u0111\u1ed5i m\u1eadt kh\u1ea9u: " + sQLException.getMessage());
                sQLException.printStackTrace();
                this.closeResources(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, null);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendResetPasswordEmail(String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        HashMap<String, Object> hashMap;
        block9: {
            block8: {
                String string2;
                block7: {
                    hashMap = new HashMap<String, Object>();
                    hashMap.put("success", false);
                    string2 = "SELECT user_id, username, full_name FROM users WHERE email = ?";
                    connection = null;
                    preparedStatement = null;
                    resultSet = null;
                    connection = this.dbConnection.getConnection();
                    if (connection != null) break block7;
                    hashMap.put("message", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn database!");
                    HashMap<String, Object> hashMap2 = hashMap;
                    this.closeResources(connection, preparedStatement, resultSet);
                    return hashMap2;
                }
                preparedStatement = connection.prepareStatement(string2);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) break block8;
                System.err.println("\u274c Kh\u00f4ng t\u00ecm th\u1ea5y email: " + string);
                hashMap.put("message", "Email kh\u00f4ng t\u1ed3n t\u1ea1i trong h\u1ec7 th\u1ed1ng!");
                HashMap<String, Object> hashMap3 = hashMap;
                this.closeResources(connection, preparedStatement, resultSet);
                return hashMap3;
            }
            int n = resultSet.getInt("user_id");
            String string3 = resultSet.getString("username");
            String string4 = resultSet.getString("full_name");
            String string5 = this.generateRandomPassword();
            EmailService emailService = new EmailService();
            boolean bl = emailService.sendResetPasswordEmail(string, string4, string5);
            if (!bl) break block9;
            System.out.println("\u2705 \u0110\u00e3 g\u1eedi m\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi qua email: " + string);
            hashMap.put("success", true);
            hashMap.put("message", "M\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi \u0111\u00e3 \u0111\u01b0\u1ee3c g\u1eedi \u0111\u1ebfn email c\u1ee7a b\u1ea1n!");
            hashMap.put("temporary_password", string5);
            hashMap.put("username", string3);
            hashMap.put("user_id", n);
            HashMap<String, Object> hashMap4 = hashMap;
            this.closeResources(connection, preparedStatement, resultSet);
            return hashMap4;
        }
        try {
            hashMap.put("message", "Kh\u00f4ng th\u1ec3 g\u1eedi email. Vui l\u00f2ng th\u1eed l\u1ea1i!");
            HashMap<String, Object> hashMap5 = hashMap;
            this.closeResources(connection, preparedStatement, resultSet);
            return hashMap5;
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u274c L\u1ed7i khi reset password: " + sQLException.getMessage());
                sQLException.printStackTrace();
                hashMap.put("message", "L\u1ed7i database: " + sQLException.getMessage());
                this.closeResources(connection, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> resetPasswordWithTemporary(String string, String string2, String string3) {
        PreparedStatement preparedStatement;
        Connection connection;
        HashMap<String, Object> hashMap;
        block7: {
            String string4;
            block6: {
                hashMap = new HashMap<String, Object>();
                hashMap.put("success", false);
                string4 = "UPDATE users SET password = ? WHERE email = ?";
                connection = null;
                preparedStatement = null;
                connection = this.dbConnection.getConnection();
                if (connection != null) break block6;
                hashMap.put("message", "Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn database!");
                HashMap<String, Object> hashMap2 = hashMap;
                this.closeResources(connection, preparedStatement, null);
                return hashMap2;
            }
            String string5 = this.hashPassword(string3);
            preparedStatement = connection.prepareStatement(string4);
            preparedStatement.setString(1, string5);
            preparedStatement.setString(2, string);
            int n = preparedStatement.executeUpdate();
            if (n <= 0) break block7;
            System.out.println("\u2705 C\u1eadp nh\u1eadt m\u1eadt kh\u1ea9u m\u1edbi th\u00e0nh c\u00f4ng cho email: " + string);
            hashMap.put("success", true);
            hashMap.put("message", "\u0110\u1ed5i m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng!");
            HashMap<String, Object> hashMap3 = hashMap;
            this.closeResources(connection, preparedStatement, null);
            return hashMap3;
        }
        try {
            hashMap.put("message", "Kh\u00f4ng t\u00ecm th\u1ea5y email trong h\u1ec7 th\u1ed1ng!");
            HashMap<String, Object> hashMap4 = hashMap;
            this.closeResources(connection, preparedStatement, null);
            return hashMap4;
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt m\u1eadt kh\u1ea9u: " + sQLException.getMessage());
                sQLException.printStackTrace();
                hashMap.put("message", "L\u1ed7i database: " + sQLException.getMessage());
                this.closeResources(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, null);
                throw throwable;
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUsernameExists(String string) {
        String string2 = "SELECT COUNT(*) FROM users WHERE username = ?";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            this.closeResources(connection, preparedStatement, resultSet);
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
        finally {
            this.closeResources(connection, preparedStatement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEmailExistsInDB(String string) {
        String string2 = "SELECT COUNT(*) FROM users WHERE email = ?";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            this.closeResources(connection, preparedStatement, resultSet);
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
        finally {
            this.closeResources(connection, preparedStatement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEmailExistsForOtherUser(String string, String string2) {
        String string3 = "SELECT COUNT(*) FROM users WHERE email = ? AND username != ?";
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                this.closeResources(connection, preparedStatement, resultSet);
                return bl;
            }
            this.closeResources(connection, preparedStatement, resultSet);
            return false;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
        finally {
            this.closeResources(connection, preparedStatement, resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastLogin(int n) {
        PreparedStatement preparedStatement;
        Connection connection;
        String string;
        block5: {
            string = "UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE user_id = ?";
            connection = null;
            preparedStatement = null;
            connection = this.dbConnection.getConnection();
            if (connection != null) break block5;
            this.closeResources(connection, preparedStatement, null);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            this.closeResources(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u26a0\ufe0f  Kh\u00f4ng c\u1eadp nh\u1eadt \u0111\u01b0\u1ee3c last_login: " + sQLException.getMessage());
                this.closeResources(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logLoginHistory(int n) {
        PreparedStatement preparedStatement;
        Connection connection;
        String string;
        block5: {
            string = "INSERT INTO login_history (user_id, ip_address) VALUES (?, ?)";
            connection = null;
            preparedStatement = null;
            connection = this.dbConnection.getConnection();
            if (connection != null) break block5;
            this.closeResources(connection, preparedStatement, null);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, "127.0.0.1");
            preparedStatement.executeUpdate();
            this.closeResources(connection, preparedStatement, null);
        }
        catch (SQLException sQLException) {
            try {
                System.err.println("\u26a0\ufe0f  Kh\u00f4ng ghi \u0111\u01b0\u1ee3c login history: " + sQLException.getMessage());
                this.closeResources(connection, preparedStatement, null);
            }
            catch (Throwable throwable) {
                this.closeResources(connection, preparedStatement, null);
                throw throwable;
            }
        }
    }

    private String hashPassword(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest(string.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("\u274c L\u1ed7i hash password: " + noSuchAlgorithmException.getMessage());
            return string;
        }
    }

    private boolean checkPasswordHash(String string, String string2) {
        String string3 = this.hashPassword(string);
        return string3.equals(string2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean verifyPassword(String string, String string2) {
        String string3 = "SELECT password FROM users WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block18: {
                PreparedStatement preparedStatement;
                block16: {
                    boolean bl2;
                    block17: {
                        preparedStatement = connection.prepareStatement(string3);
                        try {
                            preparedStatement.setString(1, string);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block16;
                            String string4 = resultSet.getString("password");
                            System.out.println("DEBUG verifyPassword - username: " + string);
                            System.out.println("DEBUG verifyPassword - inputHash: " + this.hashPassword(string2));
                            System.out.println("DEBUG verifyPassword - storedHash: " + string4);
                            boolean bl3 = this.checkPasswordHash(string2, string4);
                            System.out.println("DEBUG verifyPassword - match: " + bl3);
                            bl2 = bl3;
                            if (preparedStatement == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return bl2;
                }
                System.out.println("DEBUG verifyPassword - user not found: " + string);
                bl = false;
                if (preparedStatement == null) break block18;
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.out.println("DEBUG verifyPassword - SQL error: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean changePassword(String string, String string2) {
        String string3 = "UPDATE users SET password = ? WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block18: {
                PreparedStatement preparedStatement;
                block16: {
                    boolean bl2;
                    block17: {
                        preparedStatement = connection.prepareStatement(string3);
                        try {
                            String string4 = this.hashPassword(string2);
                            preparedStatement.setString(1, string4);
                            preparedStatement.setString(2, string);
                            int n = preparedStatement.executeUpdate();
                            if (n <= 0) break block16;
                            System.out.println("Doi mat khau thanh cong cho user: " + string);
                            bl2 = true;
                            if (preparedStatement == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        preparedStatement.close();
                    }
                    return bl2;
                }
                bl = false;
                if (preparedStatement == null) break block18;
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    private String generateRandomPassword() {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@#$%&*";
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 12; ++i) {
            int n = secureRandom.nextInt(string.length());
            stringBuilder.append(string.charAt(n));
        }
        return stringBuilder.toString();
    }

    private void closeResources(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            DatabaseConnection.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> searchUsers(String string, String string2) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string3 = "SELECT u.user_id, u.username, u.full_name, u.email FROM users u WHERE (LOWER(u.username) LIKE LOWER(?) OR LOWER(u.email) LIKE LOWER(?) OR LOWER(u.full_name) LIKE LOWER(?)) AND u.username != ? AND u.status = 'active' AND NOT EXISTS (SELECT 1 FROM blocked_users b WHERE b.blocker_id = u.user_id AND b.blocked_id = (SELECT user_id FROM users WHERE username = ?)) ORDER BY u.username LIMIT 20";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                System.err.println("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i database");
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            System.out.println("\ud83d\udd0d T\u00ecm ki\u1ebfm users v\u1edbi query: '" + string + "', exclude: '" + string2 + "'");
            statement = connection.prepareStatement(string3);
            String string4 = "%" + string + "%";
            statement.setString(1, string4);
            statement.setString(2, string4);
            statement.setString(3, string4);
            statement.setString(4, string2);
            statement.setString(5, string2);
            System.out.println("\ud83d\udcdd SQL: " + string3);
            System.out.println("\ud83d\udcdd Pattern: " + string4);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("user_id", resultSet.getInt("user_id"));
                hashMap.put("username", resultSet.getString("username"));
                hashMap.put("full_name", resultSet.getString("full_name"));
                hashMap.put("email", resultSet.getString("email"));
                arrayList.add(hashMap);
                System.out.println("  \u2705 Found: " + resultSet.getString("username") + " - " + resultSet.getString("full_name"));
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y t\u1ed5ng c\u1ed9ng: " + arrayList.size() + " users");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u00ecm ki\u1ebfm users: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getReceivedFriendRequests(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT f.friendship_id, f.user_id, f.friend_id, f.created_at, u.username as sender_username, u.full_name as sender_name FROM friends f JOIN users u ON f.user_id = u.user_id WHERE f.friend_id = (SELECT user_id FROM users WHERE username = ?) AND f.status = 'pending' ORDER BY f.created_at DESC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("friendship_id", resultSet.getInt("friendship_id"));
                hashMap.put("sender_id", resultSet.getInt("user_id"));
                hashMap.put("sender_username", resultSet.getString("sender_username"));
                hashMap.put("sender_name", resultSet.getString("sender_name"));
                hashMap.put("created_at", resultSet.getTimestamp("created_at"));
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + arrayList.size() + " l\u1eddi m\u1eddi \u0111\u00e3 nh\u1eadn");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y received friend requests: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getSentFriendRequests(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT f.friendship_id, f.user_id, f.friend_id, f.created_at, u.username as receiver_username, u.full_name as receiver_name FROM friends f JOIN users u ON f.friend_id = u.user_id WHERE f.user_id = (SELECT user_id FROM users WHERE username = ?) AND f.status = 'pending' ORDER BY f.created_at DESC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("friendship_id", resultSet.getInt("friendship_id"));
                hashMap.put("receiver_id", resultSet.getInt("friend_id"));
                hashMap.put("receiver_username", resultSet.getString("receiver_username"));
                hashMap.put("receiver_name", resultSet.getString("receiver_name"));
                hashMap.put("created_at", resultSet.getTimestamp("created_at"));
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + arrayList.size() + " l\u1eddi m\u1eddi \u0111\u00e3 g\u1eedi");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y sent friend requests: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFriendRequest(String string, String string2) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            String string3 = "SELECT COUNT(*) FROM blocked_users WHERE (blocker_id = (SELECT user_id FROM users WHERE username = ?)        AND blocked_id = (SELECT user_id FROM users WHERE username = ?))    OR (blocker_id = (SELECT user_id FROM users WHERE username = ?)        AND blocked_id = (SELECT user_id FROM users WHERE username = ?))";
            try (Object object = connection.prepareStatement(string3);){
                object.setString(1, string);
                object.setString(2, string2);
                object.setString(3, string2);
                object.setString(4, string);
                try (ResultSet resultSet = object.executeQuery();){
                    if (resultSet.next() && resultSet.getInt(1) > 0) {
                        System.out.println("\ud83d\udeab Kh\u00f4ng th\u1ec3 g\u1eedi l\u1eddi m\u1eddi: C\u00f3 ng\u01b0\u1eddi \u0111\u00e3 b\u1ecb ch\u1eb7n");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            object = "INSERT INTO friends (user_id, friend_id, status, created_at) VALUES ((SELECT user_id FROM users WHERE username = ?),         (SELECT user_id FROM users WHERE username = ?),         'pending', CURRENT_TIMESTAMP)";
            statement = connection.prepareStatement((String)object);
            statement.setString(1, string);
            statement.setString(2, string2);
            int n = statement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 \u0110\u00e3 g\u1eedi l\u1eddi m\u1eddi k\u1ebft b\u1ea1n t\u1eeb " + string + " \u2192 " + string2);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi g\u1eedi friend request: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acceptFriendRequest(int n) {
        String string = "UPDATE friends SET status = 'accepted', updated_at = CURRENT_TIMESTAMP WHERE friendship_id = ? AND status = 'pending'";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 ch\u1ea5p nh\u1eadn l\u1eddi m\u1eddi k\u1ebft b\u1ea1n #" + n);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi accept friend request: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rejectFriendRequest(int n) {
        String string = "DELETE FROM friends WHERE friendship_id = ? AND status = 'pending'";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 t\u1eeb ch\u1ed1i l\u1eddi m\u1eddi k\u1ebft b\u1ea1n #" + n);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi reject friend request: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recallFriendRequest(int n) {
        String string = "DELETE FROM friends WHERE friendship_id = ? AND status = 'pending'";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 thu h\u1ed3i l\u1eddi m\u1eddi k\u1ebft b\u1ea1n #" + n);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi recall friend request: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countReceivedFriendRequests(String string) {
        String string2 = "SELECT COUNT(*) FROM friends f WHERE f.friend_id = (SELECT user_id FROM users WHERE username = ?) AND f.status = 'pending'";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                int n = 0;
                return n;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                System.out.println("\ud83d\udd14 C\u00f3 " + n + " l\u1eddi m\u1eddi k\u1ebft b\u1ea1n m\u1edbi");
                int n2 = n;
                return n2;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi \u0111\u1ebfm friend requests: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getFriendsList(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT DISTINCT CASE   WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.user_id   ELSE u1.user_id END as user_id, CASE   WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.username   ELSE u1.username END as username, CASE   WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.full_name   ELSE u1.full_name END as full_name FROM friends f JOIN users u1 ON f.user_id = u1.user_id JOIN users u2 ON f.friend_id = u2.user_id WHERE f.status = 'accepted' AND (u1.username = ? OR u2.username = ?) ORDER BY full_name ASC, username ASC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            statement.setString(2, string);
            statement.setString(3, string);
            statement.setString(4, string);
            statement.setString(5, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("user_id", resultSet.getInt("user_id"));
                hashMap.put("username", resultSet.getString("username"));
                hashMap.put("full_name", resultSet.getString("full_name"));
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + arrayList.size() + " b\u1ea1n b\u00e8");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y danh s\u00e1ch b\u1ea1n b\u00e8: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFriendshipStatus(String string, String string2) {
        String string3 = "SELECT f.status, f.user_id, u1.username as sender FROM friends f JOIN users u1 ON f.user_id = u1.user_id JOIN users u2 ON f.friend_id = u2.user_id WHERE (u1.username = ? AND u2.username = ?)    OR (u1.username = ? AND u2.username = ?)";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                String string4 = "none";
                return string4;
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, string2);
            statement.setString(4, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string5 = resultSet.getString("status");
                String string6 = resultSet.getString("sender");
                if ("accepted".equals(string5)) {
                    String string7 = "friends";
                    return string7;
                }
                if ("pending".equals(string5)) {
                    if (string6.equals(string)) {
                        String string8 = "pending_sent";
                        return string8;
                    }
                    String string9 = "pending_received";
                    return string9;
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi check friendship status: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return "none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getRecentChats(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        System.out.println("\ud83d\udd0d \u0110ang t\u00ecm recent chats cho user: " + string);
        String string2 = "WITH user_friends AS (   SELECT     CASE WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN f.friend_id ELSE f.user_id END as friend_user_id   FROM friends f   WHERE f.status = 'accepted'   AND (f.user_id = (SELECT user_id FROM users WHERE username = ?)        OR f.friend_id = (SELECT user_id FROM users WHERE username = ?)) ) SELECT DISTINCT   uf.friend_user_id,   u.username as friend_username,   u.full_name as friend_name,   m.last_message,   m.sent_at FROM user_friends uf JOIN users u ON uf.friend_user_id = u.user_id LEFT JOIN LATERAL (   SELECT content as last_message, created_at as sent_at   FROM messages   WHERE (sender_id = (SELECT user_id FROM users WHERE username = ?) AND receiver_id = uf.friend_user_id)      OR (sender_id = uf.friend_user_id AND receiver_id = (SELECT user_id FROM users WHERE username = ?))   ORDER BY created_at DESC   LIMIT 1 ) m ON true ORDER BY m.sent_at DESC NULLS LAST, u.full_name";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                System.err.println("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i database");
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            System.out.println("\u2705 \u0110\u00e3 k\u1ebft n\u1ed1i database");
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            statement.setString(2, string);
            statement.setString(3, string);
            statement.setString(4, string);
            statement.setString(5, string);
            System.out.println("\ud83d\udd04 \u0110ang execute query...");
            resultSet = statement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                ++n;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                String string3 = resultSet.getString("friend_username");
                String string4 = resultSet.getString("friend_name");
                String string5 = resultSet.getString("last_message");
                Timestamp timestamp = resultSet.getTimestamp("sent_at");
                System.out.println("  \ud83d\udccc T\u00ecm th\u1ea5y b\u1ea1n: " + string3 + " (" + string4 + ")");
                hashMap.put("friend_user_id", resultSet.getInt("friend_user_id"));
                hashMap.put("friend_username", string3);
                hashMap.put("friend_name", string4);
                hashMap.put("last_message", string5 != null ? string5 : "B\u1eaft \u0111\u1ea7u tr\u00f2 chuy\u1ec7n");
                hashMap.put("sent_at", timestamp);
                hashMap.put("unread_count", 0);
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + n + " b\u1ea1n b\u00e8 / " + arrayList.size() + " cu\u1ed9c tr\u00f2 chuy\u1ec7n");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i SQL khi l\u1ea5y recent chats: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getChatHistory(String string, String string2) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string3 = "SELECT   m.message_id,   m.sender_id,   m.receiver_id,   u1.username as sender_username,   m.content,   m.created_at FROM messages m JOIN users u1 ON m.sender_id = u1.user_id WHERE (   (m.sender_id = (SELECT user_id FROM users WHERE username = ?)    AND m.receiver_id = (SELECT user_id FROM users WHERE username = ?))   OR   (m.sender_id = (SELECT user_id FROM users WHERE username = ?)    AND m.receiver_id = (SELECT user_id FROM users WHERE username = ?)) ) AND NOT EXISTS (   SELECT 1 FROM deleted_messages dm   WHERE dm.message_id = m.message_id   AND dm.user_id = (SELECT user_id FROM users WHERE username = ?) ) ORDER BY m.created_at ASC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, string2);
            statement.setString(4, string);
            statement.setString(5, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("message_id", resultSet.getInt("message_id"));
                hashMap.put("sender_id", resultSet.getInt("sender_id"));
                hashMap.put("receiver_id", resultSet.getInt("receiver_id"));
                hashMap.put("sender_username", resultSet.getString("sender_username"));
                hashMap.put("content", resultSet.getString("content"));
                hashMap.put("sent_at", resultSet.getTimestamp("created_at"));
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + arrayList.size() + " tin nh\u1eafn");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y chat history: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveMessage(String string, String string2, String string3) {
        String string4 = "INSERT INTO messages (sender_id, receiver_id, content, created_at) VALUES (   (SELECT user_id FROM users WHERE username = ?),   (SELECT user_id FROM users WHERE username = ?),   ?,   CURRENT_TIMESTAMP ) RETURNING message_id";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                int n = -1;
                return n;
            }
            statement = connection.prepareStatement(string4);
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, string3);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt("message_id");
                System.out.println("\u2705 \u0110\u00e3 l\u01b0u tin nh\u1eafn #" + n + ": " + string + " \u2192 " + string2);
                int n2 = n;
                return n2;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u01b0u message: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> searchFriends(String string, String string2) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string3 = "SELECT DISTINCT   CASE     WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.user_id     ELSE u1.user_id   END as user_id,   CASE     WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.username     ELSE u1.username   END as username,   CASE     WHEN f.user_id = (SELECT user_id FROM users WHERE username = ?) THEN u2.full_name     ELSE u1.full_name   END as full_name FROM friends f JOIN users u1 ON f.user_id = u1.user_id JOIN users u2 ON f.friend_id = u2.user_id WHERE f.status = 'accepted' AND (u1.username = ? OR u2.username = ?) AND (   (f.user_id = (SELECT user_id FROM users WHERE username = ?) AND (LOWER(u2.username) LIKE LOWER(?) OR LOWER(u2.full_name) LIKE LOWER(?)))   OR   (f.friend_id = (SELECT user_id FROM users WHERE username = ?) AND (LOWER(u1.username) LIKE LOWER(?) OR LOWER(u1.full_name) LIKE LOWER(?))) ) ORDER BY full_name ASC, username ASC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string3);
            String string4 = "%" + string2 + "%";
            statement.setString(1, string);
            statement.setString(2, string);
            statement.setString(3, string);
            statement.setString(4, string);
            statement.setString(5, string);
            statement.setString(6, string);
            statement.setString(7, string4);
            statement.setString(8, string4);
            statement.setString(9, string);
            statement.setString(10, string4);
            statement.setString(11, string4);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("user_id", resultSet.getInt("user_id"));
                hashMap.put("username", resultSet.getString("username"));
                hashMap.put("full_name", resultSet.getString("full_name"));
                arrayList.add(hashMap);
            }
            System.out.println("\u2705 T\u00ecm th\u1ea5y " + arrayList.size() + " b\u1ea1n b\u00e8 kh\u1edbp v\u1edbi: " + string2);
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u00ecm ki\u1ebfm b\u1ea1n b\u00e8: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unfriend(String string, String string2) {
        String string3 = "DELETE FROM friends WHERE status = 'accepted' AND (   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?))   OR   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?)) )";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, string2);
            statement.setString(4, string);
            int n = statement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 \u0110\u00e3 hu\u1ef7 k\u1ebft b\u1ea1n: " + string + " <-> " + string2);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi hu\u1ef7 k\u1ebft b\u1ea1n: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUser(String string, String string2) {
        block46: {
            Connection connection = null;
            try {
                boolean bl;
                block45: {
                    PreparedStatement preparedStatement;
                    block43: {
                        boolean bl2;
                        block44: {
                            connection = this.dbConnection.getConnection();
                            if (connection == null) {
                                boolean bl3 = false;
                                return bl3;
                            }
                            connection.setAutoCommit(false);
                            String string3 = "DELETE FROM friends WHERE status = 'accepted' AND (   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?))   OR   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?)) )";
                            try (Object object = connection.prepareStatement(string3);){
                                object.setString(1, string);
                                object.setString(2, string2);
                                object.setString(3, string2);
                                object.setString(4, string);
                                object.executeUpdate();
                            }
                            object = "DELETE FROM friends WHERE status = 'pending' AND (   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?))   OR   (user_id = (SELECT user_id FROM users WHERE username = ?)    AND friend_id = (SELECT user_id FROM users WHERE username = ?)) )";
                            try (Object object = connection.prepareStatement((String)object);){
                                object.setString(1, string);
                                object.setString(2, string2);
                                object.setString(3, string2);
                                object.setString(4, string);
                                object.executeUpdate();
                            }
                            object = "INSERT INTO blocked_users (blocker_id, blocked_id, blocked_at) VALUES (   (SELECT user_id FROM users WHERE username = ?),   (SELECT user_id FROM users WHERE username = ?),   CURRENT_TIMESTAMP ) ON CONFLICT (blocker_id, blocked_id) DO NOTHING";
                            preparedStatement = connection.prepareStatement((String)object);
                            try {
                                preparedStatement.setString(1, string);
                                preparedStatement.setString(2, string2);
                                int n = preparedStatement.executeUpdate();
                                if (n <= 0) break block43;
                                connection.commit();
                                System.out.println("\u2705 \u0110\u00e3 block user: " + string + " -> " + string2);
                                bl2 = true;
                                if (preparedStatement == null) break block44;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (preparedStatement != null) {
                                        try {
                                            preparedStatement.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (SQLException sQLException) {
                                    System.err.println("\u274c L\u1ed7i khi block user: " + sQLException.getMessage());
                                    sQLException.printStackTrace();
                                    if (connection != null) {
                                        try {
                                            connection.rollback();
                                        }
                                        catch (SQLException sQLException2) {
                                            sQLException2.printStackTrace();
                                        }
                                    }
                                    break block46;
                                }
                            }
                            preparedStatement.close();
                        }
                        return bl2;
                    }
                    connection.commit();
                    bl = true;
                    if (preparedStatement == null) break block45;
                    preparedStatement.close();
                }
                return bl;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.setAutoCommit(true);
                        DatabaseConnection.closeConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getUserInfo(String string) {
        String string2 = "SELECT username, full_name, email, address, dob, gender, created_at FROM users WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) return null;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("username", resultSet.getString("username"));
            hashMap.put("full_name", resultSet.getString("full_name"));
            hashMap.put("email", resultSet.getString("email"));
            hashMap.put("address", resultSet.getString("address"));
            hashMap.put("dob", resultSet.getDate("dob"));
            hashMap.put("gender", resultSet.getString("gender"));
            hashMap.put("created_at", resultSet.getTimestamp("created_at"));
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y th\u00f4ng tin user: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateUserProfile(String string, String string2, String string3, String string4, Date date, String string5) {
        String string6 = "UPDATE users SET full_name = ?, email = ?, address = ?, dob = ?, gender = ? WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string6);
                try {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string3);
                    preparedStatement.setString(3, string4);
                    preparedStatement.setDate(4, date);
                    preparedStatement.setString(5, string5);
                    preparedStatement.setString(6, string);
                    int n = preparedStatement.executeUpdate();
                    boolean bl2 = bl = n > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt profile: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean unblockUser(String string, String string2) {
        String string3 = "DELETE FROM blocked_users WHERE blocker_id = (SELECT user_id FROM users WHERE username = ?) AND blocked_id = (SELECT user_id FROM users WHERE username = ?)";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    int n = preparedStatement.executeUpdate();
                    boolean bl2 = bl = n > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi unblock user: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    public List<Map<String, Object>> getBlockedUsers(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT u.username, u.full_name, bu.blocked_at FROM blocked_users bu JOIN users u ON bu.blocked_id = u.user_id WHERE bu.blocker_id = (SELECT user_id FROM users WHERE username = ?) ORDER BY bu.blocked_at DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("username", resultSet.getString("username"));
                hashMap.put("full_name", resultSet.getString("full_name"));
                hashMap.put("blocked_at", resultSet.getTimestamp("blocked_at"));
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y danh s\u00e1ch blocked users: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateFullName(String string, String string2) {
        String string3 = "UPDATE users SET full_name = ? WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string);
                    int n = preparedStatement.executeUpdate();
                    boolean bl2 = bl = n > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt full name: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportSpam(String string, String string2, String string3) {
        String string4 = "INSERT INTO spam_reports (reporter_id, reported_user_id, reason, status) SELECT u1.user_id, u2.user_id, ?, 'pending' FROM users u1, users u2 WHERE u1.username = ? AND u2.username = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                System.err.println("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i database");
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string4);
            statement.setString(1, string3);
            statement.setString(2, string);
            statement.setString(3, string2);
            int n = statement.executeUpdate();
            if (n > 0) {
                System.out.println("\u2705 B\u00e1o c\u00e1o spam th\u00e0nh c\u00f4ng: " + string + " -> " + string2);
                boolean bl = true;
                return bl;
            }
            System.err.println("\u274c Kh\u00f4ng th\u1ec3 t\u1ea1o b\u00e1o c\u00e1o spam");
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi b\u00e1o c\u00e1o spam: " + sQLException.getMessage());
            sQLException.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updatePassword(String string, String string2) {
        String string3 = "UPDATE users SET password = ? WHERE username = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setString(1, string2);
                    preparedStatement.setString(2, string);
                    int n = preparedStatement.executeUpdate();
                    boolean bl2 = bl = n > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt password: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    public List<Map<String, Object>> getChatHistoryWithUser(String string, String string2) {
        String string3 = "SELECT id, sender, receiver, content, sent_at FROM messages WHERE (sender = ? AND receiver = ?) OR (sender = ? AND receiver = ?) ORDER BY sent_at ASC";
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", resultSet.getInt("id"));
                hashMap.put("sender", resultSet.getString("sender"));
                hashMap.put("receiver", resultSet.getString("receiver"));
                hashMap.put("content", resultSet.getString("content"));
                hashMap.put("sent_at", resultSet.getTimestamp("sent_at"));
                arrayList.add(hashMap);
            }
            System.out.println("\ud83d\udcdc L\u1ea5y " + arrayList.size() + " tin nh\u1eafn v\u1edbi " + string2);
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y l\u1ecbch s\u1eed: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteMessages(List<Integer> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM messages WHERE id IN (");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("?");
            if (i >= list.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block17: {
                PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
                try {
                    int n;
                    for (n = 0; n < list.size(); ++n) {
                        preparedStatement.setInt(n + 1, list.get(n));
                    }
                    n = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 x\u00f3a " + n + " tin nh\u1eafn");
                    boolean bl2 = bl = n > 0;
                    if (preparedStatement == null) break block17;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi x\u00f3a tin nh\u1eafn: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteChatHistory(String string, String string2) {
        String string3 = "INSERT INTO deleted_messages (message_id, user_id) SELECT m.message_id, ? FROM messages m JOIN users u1 ON m.sender_id = u1.user_id JOIN users u2 ON m.receiver_id = u2.user_id WHERE ((u1.username = ? AND u2.username = ?) OR (u1.username = ? AND u2.username = ?)) AND NOT EXISTS (  SELECT 1 FROM deleted_messages dm   WHERE dm.message_id = m.message_id AND dm.user_id = ?)";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block24: {
                int n = -1;
                String string4 = "SELECT user_id FROM users WHERE username = ?";
                try (PreparedStatement preparedStatement = connection.prepareStatement(string4);){
                    preparedStatement.setString(1, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt("user_id");
                    }
                }
                if (n == -1) {
                    System.err.println("\u274c Kh\u00f4ng t\u00ecm th\u1ea5y user: " + string);
                    boolean bl2 = false;
                    return bl2;
                }
                preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string2);
                    preparedStatement.setString(4, string2);
                    preparedStatement.setString(5, string);
                    preparedStatement.setInt(6, n);
                    int n2 = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 \u0111\u00e1nh d\u1ea5u x\u00f3a " + n2 + " tin nh\u1eafn v\u1edbi " + string2 + " cho user " + string);
                    bl = true;
                    if (preparedStatement == null) break block24;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi x\u00f3a l\u1ecbch s\u1eed: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    public List<Map<String, Object>> searchInChatHistory(String string, String string2, String string3) {
        String string4 = "SELECT m.message_id, u1.username as sender, u2.username as receiver, m.content, m.created_at as sent_at FROM messages m JOIN users u1 ON m.sender_id = u1.user_id JOIN users u2 ON m.receiver_id = u2.user_id WHERE ((u1.username = ? AND u2.username = ?) OR (u1.username = ? AND u2.username = ?)) AND LOWER(m.content) LIKE LOWER(?) ORDER BY m.created_at DESC LIMIT 100";
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string4);){
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string2);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, "%" + string3 + "%");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", resultSet.getInt("message_id"));
                hashMap.put("sender", resultSet.getString("sender"));
                hashMap.put("receiver", resultSet.getString("receiver"));
                hashMap.put("content", resultSet.getString("content"));
                hashMap.put("sent_at", resultSet.getTimestamp("sent_at"));
                arrayList.add(hashMap);
            }
            System.out.println("\ud83d\udd0d T\u00ecm th\u1ea5y " + arrayList.size() + " k\u1ebft qu\u1ea3");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u00ecm ki\u1ebfm: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteMessageForMe(int n, String string) {
        String string2 = "CREATE TABLE IF NOT EXISTS deleted_messages (message_id INTEGER NOT NULL, user_id INTEGER NOT NULL, deleted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (message_id, user_id))";
        String string3 = "INSERT INTO deleted_messages (message_id, user_id) SELECT ?, user_id FROM users WHERE username = ? ON CONFLICT (message_id, user_id) DO NOTHING";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block23: {
                if (connection == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                    preparedStatement.execute();
                }
                preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    int n2 = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 \u1ea9n tin nh\u1eafn " + n + " cho " + string);
                    boolean bl3 = bl = n2 > 0;
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi x\u00f3a tin nh\u1eafn cho m\u00ecnh: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean recallMessage(int n, String string) {
        String string2 = "SELECT sender_id FROM messages m JOIN users u ON m.sender_id = u.user_id WHERE m.message_id = ? AND u.username = ?";
        String string3 = "DELETE FROM messages WHERE message_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block25: {
                if (connection == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        System.err.println("\u274c Kh\u00f4ng th\u1ec3 thu h\u1ed3i tin nh\u1eafn c\u1ee7a ng\u01b0\u1eddi kh\u00e1c!");
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                preparedStatement = connection.prepareStatement(string3);
                try {
                    preparedStatement.setInt(1, n);
                    int n2 = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 thu h\u1ed3i tin nh\u1eafn " + n);
                    boolean bl4 = bl = n2 > 0;
                    if (preparedStatement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi thu h\u1ed3i tin nh\u1eafn: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> searchAllChatHistory(String string, String string2) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string3 = "SELECT m.message_id, m.content, m.created_at as sent_at, sender.username as sender_username, receiver.username as receiver_username, CASE WHEN sender.username = ? THEN receiver.username ELSE sender.username END as friend_username FROM messages m JOIN users sender ON m.sender_id = sender.user_id JOIN users receiver ON m.receiver_id = receiver.user_id WHERE (sender.username = ? OR receiver.username = ?) AND LOWER(m.content) LIKE LOWER(?) AND m.message_id NOT IN (    SELECT dm.message_id FROM deleted_messages dm     JOIN users u ON dm.user_id = u.user_id     WHERE u.username = ?) ORDER BY m.created_at DESC LIMIT 100";
        try (Connection connection = this.dbConnection.getConnection();){
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string);
                preparedStatement.setString(4, "%" + string2 + "%");
                preparedStatement.setString(5, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("message_id", resultSet.getInt("message_id"));
                    hashMap.put("content", resultSet.getString("content"));
                    hashMap.put("sent_at", resultSet.getTimestamp("sent_at"));
                    hashMap.put("sender_username", resultSet.getString("sender_username"));
                    hashMap.put("receiver_username", resultSet.getString("receiver_username"));
                    hashMap.put("friend_username", resultSet.getString("friend_username"));
                    arrayList.add(hashMap);
                }
                System.out.println("\ud83d\udd0d T\u00ecm ki\u1ebfm to\u00e0n b\u1ed9: T\u00ecm th\u1ea5y " + arrayList.size() + " k\u1ebft qu\u1ea3 cho t\u1eeb kh\u00f3a: " + string2);
                return arrayList;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u00ecm ki\u1ebfm to\u00e0n b\u1ed9 l\u1ecbch s\u1eed: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        return arrayList;
    }
}

