/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionService {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int KEY_SIZE = 256;
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private static final Map<Integer, SecretKey> groupKeyCache = new ConcurrentHashMap<Integer, SecretKey>();
    private static final Map<Integer, String> groupKeyBase64Cache = new ConcurrentHashMap<Integer, String>();
    private static EncryptionService instance;

    public static EncryptionService getInstance() {
        if (instance == null) {
            instance = new EncryptionService();
        }
        return instance;
    }

    public String generateGroupKey(int n) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
            keyGenerator.init(256, new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            groupKeyCache.put(n, secretKey);
            String string = Base64.getEncoder().encodeToString(secretKey.getEncoded());
            groupKeyBase64Cache.put(n, string);
            System.out.println("\ud83d\udd10 \u0110\u00e3 t\u1ea1o kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m " + n);
            return string;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("\u274c L\u1ed7i t\u1ea1o kh\u00f3a m\u00e3 h\u00f3a: " + noSuchAlgorithmException.getMessage());
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public boolean loadGroupKey(int n, String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, ALGORITHM);
            groupKeyCache.put(n, secretKeySpec);
            groupKeyBase64Cache.put(n, string);
            System.out.println("\ud83d\udd13 \u0110\u00e3 load kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m " + n);
            return true;
        }
        catch (Exception exception) {
            System.err.println("\u274c L\u1ed7i load kh\u00f3a: " + exception.getMessage());
            return false;
        }
    }

    public String getGroupKeyBase64(int n) {
        return groupKeyBase64Cache.get(n);
    }

    public boolean hasGroupKey(int n) {
        return groupKeyCache.containsKey(n);
    }

    public String encryptMessage(int n, String string) {
        SecretKey secretKey = groupKeyCache.get(n);
        if (secretKey == null) {
            System.err.println("\u274c Kh\u00f4ng t\u00ecm th\u1ea5y kh\u00f3a cho nh\u00f3m " + n);
            return null;
        }
        try {
            byte[] byArray = new byte[12];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray);
            cipher.init(1, (Key)secretKey, gCMParameterSpec);
            byte[] byArray2 = cipher.doFinal(string.getBytes("UTF-8"));
            byte[] byArray3 = new byte[12 + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, 12);
            System.arraycopy(byArray2, 0, byArray3, 12, byArray2.length);
            String string2 = Base64.getEncoder().encodeToString(byArray3);
            System.out.println("\ud83d\udd12 \u0110\u00e3 m\u00e3 h\u00f3a tin nh\u1eafn cho nh\u00f3m " + n);
            return string2;
        }
        catch (Exception exception) {
            System.err.println("\u274c L\u1ed7i m\u00e3 h\u00f3a: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public String decryptMessage(int n, String string) {
        SecretKey secretKey = groupKeyCache.get(n);
        if (secretKey == null) {
            System.err.println("\u274c Kh\u00f4ng t\u00ecm th\u1ea5y kh\u00f3a cho nh\u00f3m " + n);
            return "\ud83d\udd12 [Kh\u00f4ng th\u1ec3 gi\u1ea3i m\u00e3 - Thi\u1ebfu kh\u00f3a]";
        }
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            byte[] byArray2 = new byte[12];
            byte[] byArray3 = new byte[byArray.length - 12];
            System.arraycopy(byArray, 0, byArray2, 0, 12);
            System.arraycopy(byArray, 12, byArray3, 0, byArray3.length);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray2);
            cipher.init(2, (Key)secretKey, gCMParameterSpec);
            byte[] byArray4 = cipher.doFinal(byArray3);
            return new String(byArray4, "UTF-8");
        }
        catch (Exception exception) {
            System.err.println("\u274c L\u1ed7i gi\u1ea3i m\u00e3: " + exception.getMessage());
            return "\ud83d\udd12 [Kh\u00f4ng th\u1ec3 gi\u1ea3i m\u00e3]";
        }
    }

    public void removeGroupKey(int n) {
        groupKeyCache.remove(n);
        groupKeyBase64Cache.remove(n);
        System.out.println("\ud83d\uddd1\ufe0f \u0110\u00e3 x\u00f3a kh\u00f3a nh\u00f3m " + n + " kh\u1ecfi cache");
    }

    public void clearAllKeys() {
        groupKeyCache.clear();
        groupKeyBase64Cache.clear();
        System.out.println("\ud83d\uddd1\ufe0f \u0110\u00e3 x\u00f3a t\u1ea5t c\u1ea3 kh\u00f3a m\u00e3 h\u00f3a");
    }

    public String hashWithSalt(String string, String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string2.getBytes());
            byte[] byArray = messageDigest.digest(string.getBytes());
            return Base64.getEncoder().encodeToString(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public String generateSalt() {
        byte[] byArray = new byte[16];
        new SecureRandom().nextBytes(byArray);
        return Base64.getEncoder().encodeToString(byArray);
    }
}

