/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class AIService {
    private static final String API_URL = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent";
    private static final String apiKey = AIService.loadApiKeyFromConfig();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadApiKeyFromConfig() {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream("release/config.properties");){
            properties.load(fileInputStream);
            String string = properties.getProperty("gemini.api.key", "").trim();
            if (string.isEmpty()) return "";
            System.out.println("\u2705 Gemini API key loaded from config.properties");
            String string2 = string;
            return string2;
        }
        catch (IOException iOException) {
            System.err.println("\u26a0\ufe0f Could not load gemini.api.key from config.properties: " + iOException.getMessage());
        }
        return "";
    }

    public String generateSuggestion(String string, String string2) {
        if (apiKey == null || apiKey.isEmpty()) {
            return this.generateOfflineSuggestion(string);
        }
        try {
            String string3 = this.buildSystemPrompt(string2);
            String string4 = this.callGeminiAPI(string3, string);
            return string4;
        }
        catch (Exception exception) {
            System.err.println("\u274c L\u1ed7i g\u1ecdi Gemini API: " + exception.getMessage());
            exception.printStackTrace();
            return this.generateOfflineSuggestion(string);
        }
    }

    private String buildSystemPrompt(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("B\u1ea1n l\u00e0 tr\u1ee3 l\u00fd AI gi\u00fap so\u1ea1n tin nh\u1eafn chat ti\u1ebfng Vi\u1ec7t. ");
        stringBuilder.append("H\u00e3y t\u1ea1o tin nh\u1eafn ng\u1eafn g\u1ecdn, t\u1ef1 nhi\u00ean, ph\u00f9 h\u1ee3p v\u1edbi ng\u1eef c\u1ea3nh. ");
        stringBuilder.append("Ch\u1ec9 tr\u1ea3 l\u1eddi n\u1ed9i dung tin nh\u1eafn, kh\u00f4ng gi\u1ea3i th\u00edch th\u00eam. ");
        stringBuilder.append("C\u00f3 th\u1ec3 d\u00f9ng emoji ph\u00f9 h\u1ee3p. ");
        if (string != null && !string.isEmpty()) {
            stringBuilder.append("\n\nNg\u1eef c\u1ea3nh cu\u1ed9c tr\u00f2 chuy\u1ec7n:\n").append(string);
        }
        return stringBuilder.toString();
    }

    private String callGeminiAPI(String string, String string2) throws Exception {
        Object object;
        URL uRL = new URL("https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=" + apiKey);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(30000);
        httpURLConnection.setReadTimeout(30000);
        String string3 = this.buildRequestBody(string, string2);
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            object = string3.getBytes(StandardCharsets.UTF_8);
            outputStream.write((byte[])object, 0, ((byte[])object).length);
        }
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
            try {
                String string4;
                StringBuilder stringBuilder = new StringBuilder();
                while ((string4 = ((BufferedReader)object).readLine()) != null) {
                    stringBuilder.append(string4);
                }
                String string5 = this.parseResponse(stringBuilder.toString());
                return string5;
            }
            finally {
                ((BufferedReader)object).close();
            }
        }
        object = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), StandardCharsets.UTF_8));
        try {
            String string6;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string6 = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string6);
            }
            System.err.println("API Error: " + stringBuilder.toString());
        }
        finally {
            ((BufferedReader)object).close();
        }
        throw new Exception("API returned code: " + n);
    }

    private String buildRequestBody(String string, String string2) {
        String string3 = this.escapeJson(string);
        String string4 = this.escapeJson(string2);
        return "{\"contents\": [{\"parts\": [{\"text\": \"" + string3 + "\\n\\nY\u00eau c\u1ea7u: " + string4 + "\"}]}],\"generationConfig\": {\"temperature\": 0.7,\"maxOutputTokens\": 256}}";
    }

    private String escapeJson(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String parseResponse(String string) {
        try {
            int n = string.indexOf("\"text\"");
            if (n == -1) {
                return "Kh\u00f4ng th\u1ec3 t\u1ea1o g\u1ee3i \u00fd. Vui l\u00f2ng th\u1eed l\u1ea1i!";
            }
            int n2 = string.indexOf(":", n);
            int n3 = string.indexOf("\"", n2 + 1);
            int n4 = this.findEndQuote(string, n3 + 1);
            if (n3 == -1 || n4 == -1) {
                return "Kh\u00f4ng th\u1ec3 t\u1ea1o g\u1ee3i \u00fd. Vui l\u00f2ng th\u1eed l\u1ea1i!";
            }
            String string2 = string.substring(n3 + 1, n4);
            return string2.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\"", "\"").replace("\\\\", "\\");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Kh\u00f4ng th\u1ec3 t\u1ea1o g\u1ee3i \u00fd. Vui l\u00f2ng th\u1eed l\u1ea1i!";
        }
    }

    private int findEndQuote(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    private String generateOfflineSuggestion(String string) {
        String string2 = string.toLowerCase();
        if (string2.contains("xin l\u1ed7i") || string2.contains("sorry") || string2.contains("l\u1ed7i")) {
            return this.pickRandom(new String[]{"M\u00ecnh th\u1eadt s\u1ef1 xin l\u1ed7i v\u1ec1 \u0111i\u1ec1u \u0111\u00f3. M\u00ecnh kh\u00f4ng c\u1ed1 \u00fd, mong b\u1ea1n th\u00f4ng c\u1ea3m nh\u00e9! \ud83d\ude4f", "M\u00ecnh xin l\u1ed7i b\u1ea1n nhi\u1ec1u l\u1eafm. L\u1ea7n sau m\u00ecnh s\u1ebd c\u1ea9n th\u1eadn h\u01a1n. B\u1ea1n tha l\u1ed7i cho m\u00ecnh nh\u00e9!", "M\u00ecnh bi\u1ebft m\u00ecnh sai r\u1ed3i, th\u00e0nh th\u1eadt xin l\u1ed7i b\u1ea1n. Hy v\u1ecdng b\u1ea1n kh\u00f4ng gi\u1eadn m\u00ecnh. \ud83d\ude14"});
        }
        if (string2.contains("c\u1ea3m \u01a1n") || string2.contains("thank") || string2.contains("bi\u1ebft \u01a1n")) {
            return this.pickRandom(new String[]{"C\u1ea3m \u01a1n b\u1ea1n r\u1ea5t nhi\u1ec1u! M\u00ecnh th\u1ef1c s\u1ef1 tr\u00e2n tr\u1ecdng s\u1ef1 gi\u00fap \u0111\u1ee1 c\u1ee7a b\u1ea1n! \ud83d\ude0a", "Thank you so much! B\u1ea1n tuy\u1ec7t v\u1eddi l\u1eafm! \ud83d\ude4f\ud83d\udc95", "M\u00ecnh kh\u00f4ng bi\u1ebft n\u00f3i g\u00ec h\u01a1n ngo\u00e0i l\u1eddi c\u1ea3m \u01a1n ch\u00e2n th\u00e0nh. B\u1ea1n th\u1eadt t\u1ed1t! \u2764\ufe0f"});
        }
        if (string2.contains("ch\u00fac m\u1eebng") || string2.contains("congrat")) {
            return this.pickRandom(new String[]{"Ch\u00fac m\u1eebng b\u1ea1n nh\u00e9! \ud83c\udf89\ud83c\udf8a M\u00ecnh th\u1eadt s\u1ef1 vui cho th\u00e0nh c\u00f4ng c\u1ee7a b\u1ea1n!", "Tuy\u1ec7t v\u1eddi qu\u00e1! Ch\u00fac m\u1eebng b\u1ea1n! B\u1ea1n x\u1ee9ng \u0111\u00e1ng \u0111\u01b0\u1ee3c \u0111i\u1ec1u n\u00e0y! \ud83c\udfc6\u2728", "Wow! Ch\u00fac m\u1eebng nha! C\u1ed1 l\u00ean, c\u00f2n nhi\u1ec1u th\u00e0nh c\u00f4ng n\u1eefa \u0111ang ch\u1edd b\u1ea1n! \ud83c\udf88\ud83c\udf81"});
        }
        if (string2.contains("sinh nh\u1eadt") || string2.contains("birthday")) {
            return this.pickRandom(new String[]{"Ch\u00fac m\u1eebng sinh nh\u1eadt b\u1ea1n! \ud83c\udf82\ud83c\udf89 Ch\u00fac b\u1ea1n m\u1ed9t tu\u1ed5i m\u1edbi th\u1eadt nhi\u1ec1u ni\u1ec1m vui v\u00e0 h\u1ea1nh ph\u00fac!", "Happy Birthday! \ud83c\udf88\ud83c\udf81 Ch\u00fac b\u1ea1n lu\u00f4n vui v\u1ebb, kh\u1ecfe m\u1ea1nh v\u00e0 g\u1eb7p nhi\u1ec1u may m\u1eafn!", "Sinh nh\u1eadt vui v\u1ebb nh\u00e9! \ud83e\udd73\ud83c\udf8a Hy v\u1ecdng m\u1ecdi \u01b0\u1edbc m\u01a1 c\u1ee7a b\u1ea1n \u0111\u1ec1u th\u00e0nh hi\u1ec7n th\u1ef1c!"});
        }
        if (string2.contains("h\u1eb9n g\u1eb7p") || string2.contains("meet") || string2.contains("m\u1eddi") || string2.contains("invite")) {
            return this.pickRandom(new String[]{"B\u1ea1n c\u00f3 r\u1ea3nh cu\u1ed1i tu\u1ea7n n\u00e0y kh\u00f4ng? M\u00ecnh mu\u1ed1n m\u1eddi b\u1ea1n \u0111i c\u00e0 ph\u00ea, l\u00e2u r\u1ed3i kh\u00f4ng g\u1eb7p! \u2615", "Ch\u00fang ta h\u1eb9n g\u1eb7p nhau l\u00fac [th\u1eddi gian] t\u1ea1i [\u0111\u1ecba \u0111i\u1ec3m] nh\u00e9! M\u00ecnh r\u1ea5t mong \u0111\u01b0\u1ee3c g\u1eb7p b\u1ea1n! \ud83e\udd1d", "M\u00ecnh mu\u1ed1n m\u1eddi b\u1ea1n tham gia [s\u1ef1 ki\u1ec7n]. B\u1ea1n \u0111i c\u00f9ng m\u00ecnh \u0111\u01b0\u1ee3c kh\u00f4ng? \ud83d\ude0a"});
        }
        if (string2.contains("h\u1ecfi th\u0103m") || string2.contains("s\u1ee9c kh\u1ecfe") || string2.contains("kh\u1ecfe kh\u00f4ng")) {
            return this.pickRandom(new String[]{"L\u00e2u r\u1ed3i kh\u00f4ng g\u1eb7p, d\u1ea1o n\u00e0y b\u1ea1n c\u00f3 kh\u1ecfe kh\u00f4ng? C\u00f4ng vi\u1ec7c/h\u1ecdc t\u1eadp th\u1ebf n\u00e0o r\u1ed3i? \ud83d\ude0a", "Hey! M\u00ecnh nh\u1edb b\u1ea1n qu\u00e1. B\u1ea1n d\u1ea1o n\u00e0y sao r\u1ed3i? C\u00f3 g\u00ec vui k\u1ec3 m\u00ecnh nghe v\u1edbi!", "Hi b\u1ea1n! H\u00f4m nay b\u1ea1n th\u1ebf n\u00e0o? Hy v\u1ecdng m\u1ecdi th\u1ee9 \u0111\u1ec1u \u1ed5n v\u1edbi b\u1ea1n nh\u00e9! \ud83d\udcaa"});
        }
        if (string2.contains("t\u1eeb ch\u1ed1i") || string2.contains("kh\u00f4ng \u0111i \u0111\u01b0\u1ee3c") || string2.contains("b\u1eadn")) {
            return this.pickRandom(new String[]{"C\u1ea3m \u01a1n b\u1ea1n \u0111\u00e3 m\u1eddi, nh\u01b0ng ti\u1ebfc qu\u00e1 m\u00ecnh c\u00f3 vi\u1ec7c b\u1eadn r\u1ed3i. H\u1eb9n d\u1ecbp kh\u00e1c nh\u00e9! \ud83d\ude05", "M\u00ecnh r\u1ea5t mu\u1ed1n \u0111i nh\u01b0ng l\u1ecbch m\u00ecnh h\u00f4m \u0111\u00f3 k\u00edn r\u1ed3i. L\u1ea7n sau nh\u1ea5t \u0111\u1ecbnh m\u00ecnh s\u1ebd c\u00f3 m\u1eb7t! \ud83d\ude4f", "Xin l\u1ed7i b\u1ea1n, m\u00ecnh kh\u00f4ng th\u1ec3 tham gia \u0111\u01b0\u1ee3c. Hy v\u1ecdng c\u00e1c b\u1ea1n vui v\u1ebb nh\u00e9! \ud83d\udc95"});
        }
        if (string2.contains("\u0111\u1ed9ng vi\u00ean") || string2.contains("an \u1ee7i") || string2.contains("bu\u1ed3n")) {
            return this.pickRandom(new String[]{"\u0110\u1eebng bu\u1ed3n n\u1eefa b\u1ea1n \u01a1i! M\u1ecdi chuy\u1ec7n r\u1ed3i s\u1ebd \u1ed5n th\u00f4i. M\u00ecnh lu\u00f4n \u1edf \u0111\u00e2y n\u1ebfu b\u1ea1n c\u1ea7n! \ud83d\udcaa\u2764\ufe0f", "C\u1ed1 l\u00ean b\u1ea1n nh\u00e9! Sau c\u01a1n m\u01b0a tr\u1eddi l\u1ea1i s\u00e1ng. B\u1ea1n m\u1ea1nh m\u1ebd h\u01a1n b\u1ea1n ngh\u0129 \u0111\u1ea5y! \u2b50", "M\u00ecnh hi\u1ec3u c\u1ea3m gi\u00e1c c\u1ee7a b\u1ea1n. H\u00e3y nh\u1edb r\u1eb1ng b\u1ea1n kh\u00f4ng \u0111\u01a1n \u0111\u1ed9c, m\u00ecnh lu\u00f4n \u1ee7ng h\u1ed9 b\u1ea1n! \ud83e\udd17"});
        }
        if (string2.contains("ok") || string2.contains("\u0111\u1ed3ng \u00fd") || string2.contains("x\u00e1c nh\u1eadn")) {
            return this.pickRandom(new String[]{"OK b\u1ea1n! M\u00ecnh \u0111\u00e3 ghi nh\u1eadn r\u1ed3i nh\u00e9! \ud83d\udc4d", "\u0110\u01b0\u1ee3c th\u00f4i, kh\u00f4ng v\u1ea5n \u0111\u1ec1 g\u00ec! \u2705", "Okie, m\u00ecnh hi\u1ec3u r\u1ed3i! C\u1ee9 y\u00ean t\u00e2m nh\u00e9! \ud83d\udc4c"});
        }
        if (string2.contains("l\u00e0m quen") || string2.contains("k\u1ebft b\u1ea1n") || string2.contains("ch\u00e0o")) {
            return this.pickRandom(new String[]{"Xin ch\u00e0o! M\u00ecnh l\u00e0 [t\u00ean]. R\u1ea5t vui \u0111\u01b0\u1ee3c l\u00e0m quen v\u1edbi b\u1ea1n! \ud83d\ude0a\ud83d\udc4b", "Hi! M\u00ecnh th\u1ea5y profile b\u1ea1n hay qu\u00e1 n\u00ean mu\u1ed1n l\u00e0m quen. Hy v\u1ecdng \u0111\u01b0\u1ee3c tr\u00f2 chuy\u1ec7n v\u1edbi b\u1ea1n!", "Ch\u00e0o b\u1ea1n! Ch\u00fang ta c\u00f3 th\u1ec3 k\u1ebft b\u1ea1n \u0111\u01b0\u1ee3c kh\u00f4ng? M\u00ecnh r\u1ea5t mu\u1ed1n \u0111\u01b0\u1ee3c bi\u1ebft th\u00eam v\u1ec1 b\u1ea1n! \ud83e\udd1d"});
        }
        return this.pickRandom(new String[]{"D\u1ef1a v\u00e0o y\u00eau c\u1ea7u \"" + string + "\":\n\nM\u00ecnh hi\u1ec3u \u00fd b\u1ea1n r\u1ed3i. Ch\u00fang ta c\u00f3 th\u1ec3 th\u1ea3o lu\u1eadn th\u00eam v\u1ec1 v\u1ea5n \u0111\u1ec1 n\u00e0y nh\u00e9! \ud83d\ude0a", "C\u1ea3m \u01a1n b\u1ea1n \u0111\u00e3 chia s\u1ebb! M\u00ecnh s\u1ebd suy ngh\u0129 v\u1ec1 \u0111i\u1ec1u n\u00e0y v\u00e0 ph\u1ea3n h\u1ed3i s\u1edbm nh\u00e9! \ud83e\udd14", "OK m\u00ecnh nh\u1eadn \u0111\u01b0\u1ee3c r\u1ed3i! \u0110\u1ec3 m\u00ecnh xem x\u00e9t v\u00e0 tr\u1ea3 l\u1eddi b\u1ea1n sau nh\u00e9! \ud83d\udc4d"});
    }

    private String pickRandom(String[] stringArray) {
        int n = (int)(Math.random() * (double)stringArray.length);
        return stringArray[n];
    }

    public boolean isAPIConfigured() {
        return apiKey != null && !apiKey.isEmpty();
    }
}

