/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.AIService;
import user.service.EncryptionService;
import user.service.GroupService;
import user.socket.Message;

public class GroupChatPanel
extends JPanel {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color ENCRYPTED_COLOR = new Color(0, 150, 80);
    private static final Color SENT_BUBBLE_COLOR = new Color(0, 132, 255);
    private static final Color RECEIVED_BUBBLE_COLOR = new Color(240, 242, 245);
    private static final Color BG_COLOR = Color.WHITE;
    private ZaloMainFrame mainFrame;
    private GroupService groupService;
    private AIService aiService;
    private EncryptionService encryptionService;
    private int groupId;
    private String groupName;
    private boolean isAdmin;
    private boolean isEncrypted;
    private JLabel groupNameLabel;
    private JLabel memberCountLabel;
    private JLabel encryptionBadge;
    private JPanel messageListPanel;
    private JScrollPane scrollPane;
    private JTextArea messageInput;
    private JButton sendButton;
    private Map<Integer, JPanel> messageBubbles = new HashMap<Integer, JPanel>();

    public GroupChatPanel(ZaloMainFrame zaloMainFrame, int n, String string, boolean bl) {
        this(zaloMainFrame, n, string, bl, false);
    }

    public GroupChatPanel(ZaloMainFrame zaloMainFrame, int n, String string, boolean bl, boolean bl2) {
        this.mainFrame = zaloMainFrame;
        this.groupService = new GroupService();
        this.aiService = new AIService();
        this.encryptionService = EncryptionService.getInstance();
        this.groupId = n;
        this.groupName = string;
        this.isAdmin = bl;
        this.isEncrypted = bl2;
        if (bl2) {
            this.loadEncryptionKey();
        }
        this.initializeUI();
        this.loadGroupMessages();
        this.loadMemberCount();
    }

    private void loadEncryptionKey() {
        if (!this.encryptionService.hasGroupKey(this.groupId)) {
            String string = this.groupService.getGroupEncryptionKey(this.groupId);
            if (string != null && !string.isEmpty()) {
                this.encryptionService.loadGroupKey(this.groupId, string);
                System.out.println("\ud83d\udd13 \u0110\u00e3 load kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m " + this.groupId);
            } else if (this.isAdmin) {
                System.out.println("\u26a0\ufe0f Nh\u00f3m m\u00e3 h\u00f3a ch\u01b0a c\u00f3 kh\u00f3a, \u0111ang t\u1ea1o kh\u00f3a m\u1edbi...");
                String string2 = this.encryptionService.generateGroupKey(this.groupId);
                if (string2 != null) {
                    this.groupService.saveEncryptionKey(this.groupId, string2);
                    System.out.println("\u2705 \u0110\u00e3 t\u1ea1o v\u00e0 l\u01b0u kh\u00f3a m\u00e3 h\u00f3a m\u1edbi cho nh\u00f3m " + this.groupId);
                }
            } else {
                System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m " + this.groupId + " - Li\u00ean h\u1ec7 admin");
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, "Kh\u00f4ng t\u00ecm th\u1ea5y kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m n\u00e0y.\nVui l\u00f2ng li\u00ean h\u1ec7 admin c\u1ee7a nh\u00f3m \u0111\u1ec3 \u0111\u01b0\u1ee3c c\u1ea5p kh\u00f3a.", "L\u1ed7i m\u00e3 h\u00f3a", 2));
            }
        }
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        JPanel jPanel = this.createHeaderPanel();
        this.messageListPanel = new JPanel();
        this.messageListPanel.setLayout(new BoxLayout(this.messageListPanel, 1));
        this.messageListPanel.setBackground(BG_COLOR);
        this.messageListPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.scrollPane = new JScrollPane(this.messageListPanel);
        this.scrollPane.setBorder(null);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel2 = this.createInputPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)jPanel2, "South");
    }

    private JPanel createHeaderPanel() {
        Object object;
        Accessible accessible;
        JComponent jComponent;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(this.isEncrypted ? new Color(240, 255, 240) : Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.isEncrypted ? ENCRYPTED_COLOR : new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.setOpaque(false);
        if (this.isEncrypted) {
            jComponent = new JLabel();
            try {
                accessible = new ImageIcon("icons/padlock.png");
                object = ((ImageIcon)accessible).getImage().getScaledInstance(20, 20, 4);
                ((JLabel)jComponent).setIcon(new ImageIcon((Image)object));
            }
            catch (Exception exception) {
                ((JLabel)jComponent).setText("\ud83d\udd12 ");
            }
            jPanel3.add(jComponent);
            jPanel3.add(Box.createHorizontalStrut(6));
        }
        this.groupNameLabel = new JLabel(this.groupName);
        this.groupNameLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        this.groupNameLabel.setForeground(this.isEncrypted ? ENCRYPTED_COLOR : Color.BLACK);
        jPanel3.add(this.groupNameLabel);
        if (this.isEncrypted) {
            this.encryptionBadge = new JLabel(" [E2E]");
            this.encryptionBadge.setFont(new Font(UIHelper.getDefaultFontName(), 1, 11));
            this.encryptionBadge.setForeground(ENCRYPTED_COLOR);
            this.encryptionBadge.setToolTipText("Nh\u00f3m \u0111\u01b0\u1ee3c m\u00e3 h\u00f3a \u0111\u1ea7u cu\u1ed1i - Tin nh\u1eafn ch\u1ec9 c\u00f3 th\u1ec3 \u0111\u1ecdc b\u1edfi th\u00e0nh vi\u00ean");
            jPanel3.add(this.encryptionBadge);
        }
        jComponent = new JPanel(new FlowLayout(0, 0, 0));
        jComponent.setOpaque(false);
        this.memberCountLabel = new JLabel("\u0110ang t\u1ea3i...");
        this.memberCountLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        this.memberCountLabel.setForeground(new Color(120, 120, 120));
        jComponent.add(this.memberCountLabel);
        jPanel3.setAlignmentX(0.0f);
        jComponent.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        jPanel2.add(jComponent);
        accessible = new JPanel(new FlowLayout(2, 5, 0));
        ((JComponent)((Object)accessible)).setOpaque(false);
        object = this.createHeaderButton("icons/search.png", "T\u00ecm ki\u1ebfm tin nh\u1eafn", 22);
        ((AbstractButton)object).addActionListener(actionEvent -> this.showSearchInGroupDialog());
        JButton jButton = this.createHeaderButton("icons/generative.png", "Tr\u1ee3 l\u00fd AI", 22);
        jButton.addActionListener(actionEvent -> this.showAIAssistant());
        JButton jButton2 = this.createHeaderButton("icons/file.png", "\u0110\u1ed5i t\u00ean nh\u00f3m", 22);
        jButton2.addActionListener(actionEvent -> this.renameGroup());
        JButton jButton3 = this.createHeaderButton("icons/add-friend.png", "Th\u00eam th\u00e0nh vi\u00ean", 22);
        jButton3.addActionListener(actionEvent -> this.addMember());
        JButton jButton4 = this.createHeaderButton("icons/user.png", "Qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean", 22);
        jButton4.addActionListener(actionEvent -> this.showMembersManagement());
        JButton jButton5 = this.createHeaderButton("icons/settings.png", "M\u00e3 h\u00f3a nh\u00f3m", 22);
        jButton5.addActionListener(actionEvent -> this.toggleEncryption());
        JButton jButton6 = this.createHeaderButton("icons/bin.png", "X\u00f3a nh\u00f3m", 22);
        jButton6.addActionListener(actionEvent -> this.deleteGroup());
        if (!this.isAdmin) {
            jButton6.setVisible(false);
        }
        ((Container)((Object)accessible)).add((Component)object);
        ((Container)((Object)accessible)).add(jButton);
        ((Container)((Object)accessible)).add(jButton2);
        ((Container)((Object)accessible)).add(jButton3);
        ((Container)((Object)accessible)).add(jButton4);
        ((Container)((Object)accessible)).add(jButton5);
        ((Container)((Object)accessible)).add(jButton6);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)((Object)accessible), "East");
        return jPanel;
    }

    private JButton createHeaderButton(String string, String string2, int n) {
        final JButton jButton = new JButton();
        try {
            ImageIcon imageIcon = new ImageIcon(string);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            jButton.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            jButton.setText("?");
            jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y icon: " + string);
        }
        jButton.setPreferredSize(new Dimension(36, 36));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setToolTipText(string2);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(true);
                jButton.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(false);
            }
        });
        return jButton;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(220, 220, 220)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
        this.messageInput = new JTextArea(2, 20);
        this.messageInput.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.messageInput.setLineWrap(true);
        this.messageInput.setWrapStyleWord(true);
        this.messageInput.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(8, 12, 8, 12)));
        this.messageInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !keyEvent.isShiftDown()) {
                    keyEvent.consume();
                    GroupChatPanel.this.sendMessage();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.messageInput);
        jScrollPane.setBorder(null);
        this.sendButton = new JButton("G\u1eedi");
        this.sendButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        this.sendButton.setForeground(Color.WHITE);
        this.sendButton.setBackground(PRIMARY_COLOR);
        this.sendButton.setPreferredSize(new Dimension(80, 40));
        this.sendButton.setBorderPainted(false);
        this.sendButton.setFocusPainted(false);
        this.sendButton.setOpaque(true);
        this.sendButton.setContentAreaFilled(true);
        this.sendButton.setCursor(new Cursor(12));
        this.sendButton.addActionListener(actionEvent -> this.sendMessage());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.sendButton, "East");
        return jPanel;
    }

    private void loadMemberCount() {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return GroupChatPanel.this.groupService.getGroupMembers(GroupChatPanel.this.groupId);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list != null) {
                        GroupChatPanel.this.memberCountLabel.setText(list.size() + " th\u00e0nh vi\u00ean");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void loadGroupMessages() {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                if (GroupChatPanel.this.isEncrypted) {
                    return GroupChatPanel.this.groupService.getGroupMessagesDecrypted(GroupChatPanel.this.groupId, true);
                }
                return GroupChatPanel.this.groupService.getGroupMessages(GroupChatPanel.this.groupId);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    GroupChatPanel.this.displayMessages(list);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GroupChatPanel.this, "L\u1ed7i khi t\u1ea3i tin nh\u1eafn: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private void displayMessages(List<Map<String, Object>> list) {
        this.messageListPanel.removeAll();
        this.messageBubbles.clear();
        if (list == null || list.isEmpty()) {
            String string = this.isEncrypted ? "Nhom ma hoa - Chua co tin nhan nao" : "Chua co tin nhan nao";
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 2, 14));
            jLabel.setForeground(this.isEncrypted ? ENCRYPTED_COLOR : new Color(150, 150, 150));
            jLabel.setAlignmentX(0.5f);
            this.messageListPanel.add(Box.createVerticalGlue());
            this.messageListPanel.add(jLabel);
            this.messageListPanel.add(Box.createVerticalGlue());
        } else {
            for (Map<String, Object> map : list) {
                int n = map.get("message_id") != null ? (Integer)map.get("message_id") : 0;
                String string = (String)map.get("sender_username");
                String string2 = (String)map.get("sender_full_name");
                String string3 = (String)map.get("message");
                LocalDateTime localDateTime = (LocalDateTime)map.get("sent_at");
                boolean bl = string.equals(this.mainFrame.getUsername());
                JPanel jPanel = this.createMessageBubble(n, string, string2 != null ? string2 : string, string3, localDateTime, bl);
                this.messageListPanel.add(jPanel);
                this.messageListPanel.add(Box.createVerticalStrut(8));
            }
            this.messageListPanel.add(Box.createVerticalGlue());
        }
        this.messageListPanel.revalidate();
        this.messageListPanel.repaint();
        SwingUtilities.invokeLater(() -> {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        });
    }

    private JPanel createMessageBubble(int n, String string, String string2, String string3, LocalDateTime localDateTime, boolean bl) {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(true);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 12, 10, 12));
        if (bl) {
            jPanel2.setBackground(SENT_BUBBLE_COLOR);
            jPanel.add(Box.createHorizontalGlue());
        } else {
            jPanel2.setBackground(RECEIVED_BUBBLE_COLOR);
            jComponent = new JLabel(string2);
            jComponent.setFont(new Font(UIHelper.getDefaultFontName(), 1, 11));
            jComponent.setForeground(PRIMARY_COLOR);
            jComponent.setAlignmentX(0.0f);
            jPanel2.add(jComponent);
            jPanel2.add(Box.createVerticalStrut(3));
        }
        jComponent = new JTextArea(string3);
        ((JTextArea)jComponent).setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jComponent.setForeground(bl ? Color.WHITE : Color.BLACK);
        jComponent.setOpaque(false);
        ((JTextComponent)jComponent).setEditable(false);
        ((JTextArea)jComponent).setLineWrap(true);
        ((JTextArea)jComponent).setWrapStyleWord(true);
        jComponent.setAlignmentX(0.0f);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        JLabel jLabel = new JLabel(localDateTime.format(dateTimeFormatter));
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
        jLabel.setForeground(bl ? new Color(220, 230, 255) : new Color(120, 120, 120));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jComponent);
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(jLabel);
        jPanel2.setMaximumSize(new Dimension(400, jPanel2.getPreferredSize().height + 50));
        jPanel.add(jPanel2);
        if (!bl) {
            jPanel.add(Box.createHorizontalGlue());
        }
        Dimension dimension = jPanel.getPreferredSize();
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, dimension.height + 20));
        if (n > 0) {
            this.messageBubbles.put(n, jPanel);
        }
        return jPanel;
    }

    private void sendMessage() {
        final String string = this.messageInput.getText().trim();
        if (string.isEmpty()) {
            return;
        }
        this.sendButton.setEnabled(false);
        this.sendButton.setText("\u0110ang g\u1eedi...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                if (GroupChatPanel.this.isEncrypted) {
                    return GroupChatPanel.this.groupService.sendGroupMessageEncrypted(GroupChatPanel.this.groupId, GroupChatPanel.this.mainFrame.getUsername(), string, true);
                }
                return GroupChatPanel.this.groupService.sendGroupMessage(GroupChatPanel.this.groupId, GroupChatPanel.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        GroupChatPanel.this.messageInput.setText("");
                        GroupChatPanel.this.loadGroupMessages();
                        if (GroupChatPanel.this.mainFrame.getSocketClient() != null && GroupChatPanel.this.mainFrame.getSocketClient().isConnected()) {
                            GroupChatPanel.this.mainFrame.getSocketClient().sendGroupMessage(GroupChatPanel.this.groupId, string);
                        }
                    } else {
                        JOptionPane.showMessageDialog(GroupChatPanel.this, "Kh\u00f4ng th\u1ec3 g\u1eedi tin nh\u1eafn!", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GroupChatPanel.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                }
                finally {
                    GroupChatPanel.this.sendButton.setEnabled(true);
                    GroupChatPanel.this.sendButton.setText("G\u1eedi");
                }
            }
        };
        swingWorker.execute();
    }

    private void showMembers() {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return GroupChatPanel.this.groupService.getGroupMembers(GroupChatPanel.this.groupId);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list != null) {
                        StringBuilder stringBuilder = new StringBuilder("Danh s\u00e1ch th\u00e0nh vi\u00ean:\n\n");
                        for (Map map : list) {
                            String string = (String)map.get("username");
                            String string2 = (String)map.get("full_name");
                            String string3 = (String)map.get("role");
                            String string4 = string2 != null && !string2.isEmpty() ? string2 : string;
                            stringBuilder.append("\u2022 ").append(string4);
                            if ("admin".equals(string3)) {
                                stringBuilder.append(" (Qu\u1ea3n tr\u1ecb vi\u00ean)");
                            }
                            stringBuilder.append("\n");
                        }
                        JOptionPane.showMessageDialog(GroupChatPanel.this, stringBuilder.toString(), "Th\u00e0nh vi\u00ean nh\u00f3m", 1);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void showGroupSettings() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBackground(Color.WHITE);
        jPopupMenu.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220)));
        JMenuItem jMenuItem = this.createMenuItem("\u0110\u1ed5i t\u00ean nh\u00f3m");
        jMenuItem.addActionListener(actionEvent -> this.handleRenameGroup());
        JMenuItem jMenuItem2 = this.createMenuItem("Th\u00eam th\u00e0nh vi\u00ean");
        jMenuItem2.addActionListener(actionEvent -> this.handleAddMember());
        JMenuItem jMenuItem3 = this.createMenuItem("Qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean");
        jMenuItem3.addActionListener(actionEvent -> this.handleManageMembers());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.show(this, this.getWidth() - 200, 60);
    }

    private JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jMenuItem.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        return jMenuItem;
    }

    private void handleRenameGroup() {
        final String string = JOptionPane.showInputDialog(this, "Nh\u1eadp t\u00ean nh\u00f3m m\u1edbi:", this.groupName);
        if (string != null && !string.trim().isEmpty() && !string.equals(this.groupName)) {
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return GroupChatPanel.this.groupService.renameGroup(GroupChatPanel.this.groupId, string.trim(), GroupChatPanel.this.mainFrame.getUsername());
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            GroupChatPanel.this.groupName = string.trim();
                            GroupChatPanel.this.groupNameLabel.setText(GroupChatPanel.this.groupName);
                            JOptionPane.showMessageDialog(GroupChatPanel.this, "\u0110\u1ed5i t\u00ean nh\u00f3m th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                        } else {
                            JOptionPane.showMessageDialog(GroupChatPanel.this, "Kh\u00f4ng th\u1ec3 \u0111\u1ed5i t\u00ean nh\u00f3m!", "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }
    }

    private void handleAddMember() {
        JOptionPane.showMessageDialog(this, "Ch\u1ee9c n\u0103ng th\u00eam th\u00e0nh vi\u00ean \u0111ang \u0111\u01b0\u1ee3c ph\u00e1t tri\u1ec3n...", "Th\u00f4ng b\u00e1o", 1);
    }

    private void handleManageMembers() {
        JOptionPane.showMessageDialog(this, "Ch\u1ee9c n\u0103ng qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean \u0111ang \u0111\u01b0\u1ee3c ph\u00e1t tri\u1ec3n...", "Th\u00f4ng b\u00e1o", 1);
    }

    public void receiveGroupMessage(String string, String string2) {
        this.loadGroupMessages();
    }

    public void handleIncomingMessage(Message message) {
        if (message != null && message.getSender() != null) {
            String string = message.getSender();
            String string2 = message.getContent();
            System.out.println("\ud83d\udce8 GroupChatPanel nh\u1eadn tin nh\u1eafn t\u1eeb: " + string);
            this.loadGroupMessages();
        }
    }

    public int getGroupId() {
        return this.groupId;
    }

    private void renameGroup() {
        if (!this.isAdmin) {
            JOptionPane.showMessageDialog(this, "Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n \u0111\u1ed5i t\u00ean nh\u00f3m!", "Th\u00f4ng b\u00e1o", 2);
            return;
        }
        final String string = JOptionPane.showInputDialog(this, "Nh\u1eadp t\u00ean m\u1edbi cho nh\u00f3m:", "\u0110\u1ed5i t\u00ean nh\u00f3m", 3);
        if (string != null && !string.trim().isEmpty()) {
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return GroupChatPanel.this.groupService.updateGroupName(GroupChatPanel.this.groupId, string.trim());
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            GroupChatPanel.this.groupName = string.trim();
                            GroupChatPanel.this.groupNameLabel.setText(GroupChatPanel.this.groupName);
                            JOptionPane.showMessageDialog(GroupChatPanel.this, "\u0110\u00e3 \u0111\u1ed5i t\u00ean nh\u00f3m th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                        } else {
                            JOptionPane.showMessageDialog(GroupChatPanel.this, "Kh\u00f4ng th\u1ec3 \u0111\u1ed5i t\u00ean nh\u00f3m!", "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }
    }

    private void addMember() {
        if (!this.isAdmin) {
            JOptionPane.showMessageDialog(this, "Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n th\u00eam th\u00e0nh vi\u00ean!", "Th\u00f4ng b\u00e1o", 2);
            return;
        }
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Th\u00eam th\u00e0nh vi\u00ean", true);
        jDialog.setSize(400, 200);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setBackground(Color.WHITE);
        JLabel jLabel = new JLabel("Nh\u1eadp username c\u1ea7n th\u00eam:");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel.setAlignmentX(0.0f);
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        jTextField.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jTextField);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
        jPanel2.setBackground(Color.WHITE);
        JButton jButton = new JButton("H\u1ee7y");
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        final JButton jButton2 = new JButton("Th\u00eam");
        jButton2.setBackground(PRIMARY_COLOR);
        jButton2.setForeground(Color.WHITE);
        jButton2.setFocusPainted(false);
        jButton2.setBorderPainted(false);
        jButton2.setOpaque(true);
        jButton2.setContentAreaFilled(true);
        jButton2.addActionListener(actionEvent -> {
            final String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp username!");
                return;
            }
            jButton2.setEnabled(false);
            jButton2.setText("\u0110ang th\u00eam...");
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return GroupChatPanel.this.groupService.addMemberToGroup(GroupChatPanel.this.groupId, string);
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            JOptionPane.showMessageDialog(jDialog, "\u0110\u00e3 th\u00eam " + string + " v\u00e0o nh\u00f3m!", "Th\u00e0nh c\u00f4ng", 1);
                            jDialog.dispose();
                            GroupChatPanel.this.loadMemberCount();
                        } else {
                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 th\u00eam th\u00e0nh vi\u00ean! Ki\u1ec3m tra username.", "L\u1ed7i", 0);
                            jButton2.setEnabled(true);
                            jButton2.setText("Th\u00eam");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jButton2.setEnabled(true);
                        jButton2.setText("Th\u00eam");
                    }
                }
            };
            swingWorker.execute();
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jDialog.add((Component)jPanel, "Center");
        jDialog.add((Component)jPanel2, "South");
        jDialog.setVisible(true);
    }

    private void showMembersManagement() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean", true);
        jDialog.setSize(600, 500);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("\ud83d\udc65 Th\u00e0nh vi\u00ean nh\u00f3m: " + this.groupName);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return GroupChatPanel.this.groupService.getGroupMembers(GroupChatPanel.this.groupId);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list == null || list.isEmpty()) {
                        JLabel jLabel = new JLabel("Kh\u00f4ng c\u00f3 th\u00e0nh vi\u00ean");
                        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                        jLabel.setForeground(new Color(150, 150, 150));
                        jPanel2.add(jLabel);
                    } else {
                        for (Map map : list) {
                            String string = (String)map.get("username");
                            String string2 = (String)map.get("full_name");
                            boolean bl = (Boolean)map.get("is_admin");
                            JPanel jPanel = new JPanel(new BorderLayout(10, 0));
                            jPanel.setBackground(Color.WHITE);
                            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 10, 12, 10)));
                            jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
                            JPanel jPanel22 = new JPanel();
                            jPanel22.setLayout(new BoxLayout(jPanel22, 1));
                            jPanel22.setOpaque(false);
                            JLabel jLabel = new JLabel((string2 != null ? string2 : string) + (bl ? " \ud83d\udc51" : ""));
                            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
                            JLabel jLabel2 = new JLabel("@" + string);
                            jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
                            jLabel2.setForeground(new Color(120, 120, 120));
                            jPanel22.add(jLabel);
                            jPanel22.add(jLabel2);
                            JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 0));
                            jPanel3.setOpaque(false);
                            if (GroupChatPanel.this.isAdmin && !string.equals(GroupChatPanel.this.mainFrame.getUsername())) {
                                JButton jButton = new JButton(bl ? "B\u1ecf Admin" : "G\u00e1n Admin");
                                jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
                                jButton.setBackground(bl ? new Color(255, 152, 0) : PRIMARY_COLOR);
                                jButton.setForeground(Color.WHITE);
                                jButton.setFocusPainted(false);
                                jButton.setBorderPainted(false);
                                jButton.addActionListener(actionEvent -> {
                                    int n = JOptionPane.showConfirmDialog(jDialog, (bl ? "B\u1ecf quy\u1ec1n admin c\u1ee7a " : "G\u00e1n quy\u1ec1n admin cho ") + string + "?", "X\u00e1c nh\u1eadn", 0);
                                    if (n == 0) {
                                        boolean bl2 = GroupChatPanel.this.groupService.setGroupAdmin(GroupChatPanel.this.groupId, string, !bl);
                                        if (bl2) {
                                            JOptionPane.showMessageDialog(jDialog, "\u0110\u00e3 c\u1eadp nh\u1eadt quy\u1ec1n!");
                                            jDialog.dispose();
                                            GroupChatPanel.this.showMembersManagement();
                                        } else {
                                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 c\u1eadp nh\u1eadt quy\u1ec1n!");
                                        }
                                    }
                                });
                                JButton jButton2 = new JButton("X\u00f3a");
                                jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
                                jButton2.setBackground(new Color(255, 59, 48));
                                jButton2.setForeground(Color.WHITE);
                                jButton2.setFocusPainted(false);
                                jButton2.setBorderPainted(false);
                                jButton2.addActionListener(actionEvent -> {
                                    int n = JOptionPane.showConfirmDialog(jDialog, "X\u00f3a " + string + " kh\u1ecfi nh\u00f3m?", "X\u00e1c nh\u1eadn", 0, 2);
                                    if (n == 0) {
                                        boolean bl = GroupChatPanel.this.groupService.removeMemberFromGroup(GroupChatPanel.this.groupId, string);
                                        if (bl) {
                                            JOptionPane.showMessageDialog(jDialog, "\u0110\u00e3 x\u00f3a th\u00e0nh vi\u00ean!");
                                            jDialog.dispose();
                                            GroupChatPanel.this.showMembersManagement();
                                            GroupChatPanel.this.loadMemberCount();
                                        } else {
                                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 x\u00f3a th\u00e0nh vi\u00ean!");
                                        }
                                    }
                                });
                                jPanel3.add(jButton);
                                jPanel3.add(jButton2);
                            }
                            jPanel.add((Component)jPanel22, "West");
                            jPanel.add((Component)jPanel3, "East");
                            jPanel2.add(jPanel);
                        }
                    }
                    jPanel2.revalidate();
                    jPanel2.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jScrollPane, "Center");
        jDialog.setVisible(true);
    }

    private void toggleEncryption() {
        if (!this.isAdmin) {
            JOptionPane.showMessageDialog(this, "Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n t\u1ea1o nh\u00f3m m\u00e3 h\u00f3a!", "Th\u00f4ng b\u00e1o", 2);
            return;
        }
        if (this.isEncrypted) {
            JOptionPane.showMessageDialog(this, "Nh\u00f3m n\u00e0y \u0111\u00e3 \u0111\u01b0\u1ee3c m\u00e3 h\u00f3a!\n\nNh\u00f3m m\u00e3 h\u00f3a kh\u00f4ng th\u1ec3 t\u1eaft m\u00e3 h\u00f3a.\nN\u1ebfu mu\u1ed1n, b\u1ea1n c\u00f3 th\u1ec3 x\u00f3a nh\u00f3m n\u00e0y.", "Th\u00f4ng b\u00e1o", 1);
            return;
        }
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "T\u1ea1o nh\u00f3m m\u00e3 h\u00f3a", true);
        jDialog.setSize(500, 420);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(76, 175, 80));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("\ud83d\udd12 T\u1ea1o nh\u00f3m m\u00e3 h\u00f3a \u0111\u1ea7u cu\u1ed1i");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel jLabel2 = new JLabel("<html><div style='width:400px;'><b>T\u1ea1o phi\u00ean b\u1ea3n m\u00e3 h\u00f3a c\u1ee7a nh\u00f3m \"" + this.groupName + "\"</b><br><br>\u0110i\u1ec1u n\u00e0y s\u1ebd t\u1ea1o m\u1ed9t <b>nh\u00f3m m\u1edbi</b> v\u1edbi:<br>\u2022 C\u00f9ng t\u00ean nh\u00f3m (c\u00f3 icon kh\u00f3a)<br>\u2022 C\u00f9ng danh s\u00e1ch th\u00e0nh vi\u00ean<br>\u2022 M\u00e3 h\u00f3a \u0111\u1ea7u cu\u1ed1i AES-256<br><br><b style='color:orange;'>L\u01b0u \u00fd quan tr\u1ecdng:</b><br>\u2022 Nh\u00f3m m\u00e3 h\u00f3a <b>KH\u00d4NG TH\u1ec2 T\u1eaeT</b> m\u00e3 h\u00f3a<br>\u2022 Ch\u1ec9 c\u00f3 th\u1ec3 <b>X\u00d3A</b> nh\u00f3m m\u00e3 h\u00f3a n\u1ebfu kh\u00f4ng c\u1ea7n<br>\u2022 Tin nh\u1eafn c\u0169 kh\u00f4ng \u0111\u01b0\u1ee3c chuy\u1ec3n sang nh\u00f3m m\u1edbi</div></html>");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(20));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 10));
        jPanel3.setBackground(Color.WHITE);
        JButton jButton = new JButton("H\u1ee7y");
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        final JButton jButton2 = new JButton("\ud83d\udd12 T\u1ea1o nh\u00f3m m\u00e3 h\u00f3a");
        jButton2.setBackground(new Color(76, 175, 80));
        jButton2.setForeground(Color.WHITE);
        jButton2.setFocusPainted(false);
        jButton2.setBorderPainted(false);
        jButton2.setOpaque(true);
        jButton2.setContentAreaFilled(true);
        jButton2.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(jDialog, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n t\u1ea1o phi\u00ean b\u1ea3n m\u00e3 h\u00f3a c\u1ee7a nh\u00f3m n\u00e0y?\n\nM\u1ed9t nh\u00f3m m\u1edbi s\u1ebd \u0111\u01b0\u1ee3c t\u1ea1o v\u1edbi m\u00e3 h\u00f3a E2E.", "X\u00e1c nh\u1eadn t\u1ea1o nh\u00f3m m\u00e3 h\u00f3a", 0, 3);
            if (n == 0) {
                jButton2.setEnabled(false);
                jButton2.setText("\u0110ang t\u1ea1o...");
                final ArrayList<String> arrayList = new ArrayList<String>();
                List<Map<String, Object>> list = this.groupService.getGroupMembers(this.groupId);
                for (Map<String, Object> map : list) {
                    String string = (String)map.get("username");
                    if (string.equals(this.mainFrame.getUsername())) continue;
                    arrayList.add(string);
                }
                SwingWorker<Integer, Void> swingWorker = new SwingWorker<Integer, Void>(){

                    @Override
                    protected Integer doInBackground() {
                        return GroupChatPanel.this.groupService.createGroup(GroupChatPanel.this.groupName, "Phi\u00ean b\u1ea3n m\u00e3 h\u00f3a c\u1ee7a nh\u00f3m " + GroupChatPanel.this.groupName, GroupChatPanel.this.mainFrame.getUsername(), arrayList, true);
                    }

                    @Override
                    protected void done() {
                        try {
                            int n = (Integer)this.get();
                            if (n > 0) {
                                JOptionPane.showMessageDialog(jDialog, "\ud83d\udd12 \u0110\u00e3 t\u1ea1o nh\u00f3m m\u00e3 h\u00f3a th\u00e0nh c\u00f4ng!\n\nNh\u00f3m m\u1edbi c\u00f3 icon \u1ed5 kh\u00f3a \u0111\u1ec3 ph\u00e2n bi\u1ec7t.", "Th\u00e0nh c\u00f4ng", 1);
                                jDialog.dispose();
                                GroupChatPanel.this.mainFrame.refreshGroupList();
                                GroupChatPanel.this.mainFrame.openGroupChat(n, GroupChatPanel.this.groupName, true, true);
                                if (GroupChatPanel.this.mainFrame.getSocketClient() != null && GroupChatPanel.this.mainFrame.getSocketClient().isConnected()) {
                                    GroupChatPanel.this.mainFrame.getSocketClient().sendGroupCreatedNotification(n, GroupChatPanel.this.groupName, arrayList);
                                }
                            } else {
                                JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 t\u1ea1o nh\u00f3m m\u00e3 h\u00f3a!", "L\u1ed7i", 0);
                                jButton2.setEnabled(true);
                                jButton2.setText("\ud83d\udd12 T\u1ea1o nh\u00f3m m\u00e3 h\u00f3a");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(jDialog, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                            jButton2.setEnabled(true);
                            jButton2.setText("\ud83d\udd12 T\u1ea1o nh\u00f3m m\u00e3 h\u00f3a");
                        }
                    }
                };
                swingWorker.execute();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.add((Component)jPanel3, "South");
        jDialog.setVisible(true);
    }

    private void deleteGroup() {
        if (!this.isAdmin) {
            JOptionPane.showMessageDialog(this, "Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n x\u00f3a nh\u00f3m!", "Kh\u00f4ng c\u00f3 quy\u1ec1n", 2);
            return;
        }
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "X\u00f3a nh\u00f3m chat", true);
        jDialog.setSize(400, 250);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(220, 53, 69));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel jLabel = new JLabel("!");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 40));
        jLabel.setForeground(Color.WHITE);
        JLabel jLabel2 = new JLabel("X\u00f3a nh\u00f3m \"" + this.groupName + "\"?");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel2.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        JLabel jLabel3 = new JLabel("H\u00e0nh \u0111\u1ed9ng n\u00e0y kh\u00f4ng th\u1ec3 ho\u00e0n t\u00e1c!");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jLabel3.setForeground(new Color(220, 53, 69));
        jLabel3.setAlignmentX(0.0f);
        JLabel jLabel4 = new JLabel("<html><div style='width: 300px;'>\u2022 T\u1ea5t c\u1ea3 tin nh\u1eafn trong nh\u00f3m s\u1ebd b\u1ecb x\u00f3a v\u0129nh vi\u1ec5n<br>\u2022 T\u1ea5t c\u1ea3 th\u00e0nh vi\u00ean s\u1ebd b\u1ecb x\u00f3a kh\u1ecfi nh\u00f3m<br>\u2022 Nh\u00f3m s\u1ebd kh\u00f4ng th\u1ec3 kh\u00f4i ph\u1ee5c</div></html>");
        jLabel4.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel4.setForeground(new Color(80, 80, 80));
        jLabel4.setAlignmentX(0.0f);
        jPanel2.add(jLabel3);
        jPanel2.add(Box.createVerticalStrut(15));
        jPanel2.add(jLabel4);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 15));
        jPanel3.setBackground(new Color(248, 249, 250));
        jPanel3.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(220, 220, 220)));
        JButton jButton = new JButton("H\u1ee7y");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton.setPreferredSize(new Dimension(100, 35));
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        final JButton jButton2 = new JButton("X\u00f3a nh\u00f3m");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton2.setBackground(new Color(220, 53, 69));
        jButton2.setForeground(Color.WHITE);
        jButton2.setPreferredSize(new Dimension(120, 35));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        jButton2.setCursor(new Cursor(12));
        jButton2.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(jDialog, "B\u1ea1n c\u00f3 CH\u1eaeC CH\u1eaeN mu\u1ed1n x\u00f3a nh\u00f3m \"" + this.groupName + "\" kh\u00f4ng?", "X\u00e1c nh\u1eadn x\u00f3a", 0, 2);
            if (n == 0) {
                jButton2.setEnabled(false);
                jButton2.setText("\u0110ang x\u00f3a...");
                SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() {
                        return GroupChatPanel.this.groupService.deleteGroup(GroupChatPanel.this.groupId, GroupChatPanel.this.mainFrame.getUsername());
                    }

                    @Override
                    protected void done() {
                        try {
                            boolean bl = (Boolean)this.get();
                            if (bl) {
                                jDialog.dispose();
                                JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(GroupChatPanel.this), "\u0110\u00e3 x\u00f3a nh\u00f3m \"" + GroupChatPanel.this.groupName + "\" th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                                GroupChatPanel.this.mainFrame.showGroupList();
                            } else {
                                JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 x\u00f3a nh\u00f3m! Vui l\u00f2ng th\u1eed l\u1ea1i.", "L\u1ed7i", 0);
                                jButton2.setEnabled(true);
                                jButton2.setText("X\u00f3a nh\u00f3m");
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(jDialog, "C\u00f3 l\u1ed7i x\u1ea3y ra: " + exception.getMessage(), "L\u1ed7i", 0);
                            jButton2.setEnabled(true);
                            jButton2.setText("X\u00f3a nh\u00f3m");
                        }
                    }
                };
                swingWorker.execute();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.add((Component)jPanel3, "South");
        jDialog.setVisible(true);
    }

    private void showSearchInGroupDialog() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "T\u00ecm ki\u1ebfm trong " + this.groupName, true);
        jDialog.setSize(600, 500);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("T\u00ecm ki\u1ebfm trong " + this.groupName);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 20, 10, 20));
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        final JButton jButton = new JButton("T\u00ecm ki\u1ebfm");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(100, 35));
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)new JLabel("T\u1eeb kh\u00f3a:"), "West");
        jPanel3.add((Component)jTextField, "Center");
        jPanel3.add((Component)jButton, "East");
        jPanel2.add((Component)jPanel3, "North");
        final JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(jPanel4);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel2.add((Component)jScrollPane, "Center");
        jButton.addActionListener(actionEvent -> {
            final String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp t\u1eeb kh\u00f3a!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            jPanel4.removeAll();
            jButton.setEnabled(false);
            jButton.setText("\u0110ang t\u00ecm...");
            SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

                @Override
                protected List<Map<String, Object>> doInBackground() {
                    return GroupChatPanel.this.groupService.searchGroupMessages(GroupChatPanel.this.groupId, string);
                }

                @Override
                protected void done() {
                    try {
                        List list = (List)this.get();
                        if (list == null || list.isEmpty()) {
                            JLabel jLabel = new JLabel("Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3");
                            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                            jLabel.setForeground(new Color(150, 150, 150));
                            jPanel4.add(jLabel);
                        } else {
                            for (Map map : list) {
                                int n = map.get("message_id") != null ? (Integer)map.get("message_id") : 0;
                                String string6 = (String)map.get("sender_username");
                                String string2 = (String)map.get("sender_full_name");
                                String string3 = (String)map.get("message");
                                LocalDateTime localDateTime = (LocalDateTime)map.get("sent_at");
                                final JPanel jPanel = new JPanel(new BorderLayout(10, 5));
                                jPanel.setBackground(Color.WHITE);
                                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 10, 12, 10)));
                                jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 80));
                                jPanel.setCursor(Cursor.getPredefinedCursor(12));
                                boolean bl = string6.equals(GroupChatPanel.this.mainFrame.getUsername());
                                String string4 = string2 != null ? string2 : string6;
                                String string5 = localDateTime.format(DateTimeFormatter.ofPattern("dd/MM HH:mm"));
                                JLabel jLabel = new JLabel((bl ? "B\u1ea1n" : string4) + " - " + string5);
                                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
                                jLabel.setForeground(bl ? PRIMARY_COLOR : new Color(100, 100, 100));
                                JLabel jLabel2 = new JLabel("<html>" + GroupChatPanel.this.highlightKeyword(string3, string) + "</html>");
                                jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
                                JLabel jLabel3 = new JLabel("\u2192");
                                jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
                                jLabel3.setForeground(PRIMARY_COLOR);
                                JPanel jPanel2 = new JPanel();
                                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                                jPanel2.setOpaque(false);
                                jPanel2.add(jLabel);
                                jPanel2.add(jLabel2);
                                jPanel.add((Component)jPanel2, "Center");
                                jPanel.add((Component)jLabel3, "East");
                                final int n2 = n;
                                jPanel.addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent mouseEvent) {
                                        jDialog.dispose();
                                        GroupChatPanel.this.scrollToMessage(n2);
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent mouseEvent) {
                                        jPanel.setBackground(new Color(240, 245, 255));
                                    }

                                    @Override
                                    public void mouseExited(MouseEvent mouseEvent) {
                                        jPanel.setBackground(Color.WHITE);
                                    }
                                });
                                jPanel4.add(jPanel);
                            }
                        }
                        jPanel4.revalidate();
                        jPanel4.repaint();
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                }
            };
            swingWorker.execute();
        });
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.setVisible(true);
    }

    private String highlightKeyword(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        return string.replaceAll("(?i)(" + Pattern.quote(string2) + ")", "<span style='background-color: yellow; font-weight: bold;'>$1</span>");
    }

    private void scrollToMessage(int n) {
        JPanel jPanel = this.messageBubbles.get(n);
        if (jPanel != null) {
            SwingUtilities.invokeLater(() -> {
                Rectangle rectangle = jPanel.getBounds();
                jPanel.scrollRectToVisible(rectangle);
                Color color = jPanel.getBackground();
                jPanel.setOpaque(true);
                jPanel.setBackground(new Color(255, 255, 150));
                Timer timer = new Timer(2000, actionEvent -> {
                    jPanel.setOpaque(false);
                    jPanel.setBackground(color);
                    jPanel.repaint();
                });
                timer.setRepeats(false);
                timer.start();
                jPanel.repaint();
            });
        } else {
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y tin nh\u1eafn v\u1edbi ID: " + n);
        }
    }

    private void showAIAssistant() {
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Tr\u1ee3 l\u00fd AI", true);
        jDialog.setSize(650, 600);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(138, 43, 226));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("Tr\u1ee3 l\u00fd AI - G\u1ee3i \u00fd tin nh\u1eafn");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        JLabel jLabel2 = new JLabel(this.aiService.isAPIConfigured() ? "Online" : "Offline Mode");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel2.setForeground(new Color(200, 200, 255));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 15));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 8, 5));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createTitledBorder("G\u1ee3i \u00fd nhanh:"));
        String[] stringArray = new String[]{"Xin l\u1ed7i", "C\u1ea3m \u01a1n", "Ch\u00fac m\u1eebng", "H\u1eb9n g\u1eb7p", "H\u1ecfi th\u0103m", "\u0110\u1ed9ng vi\u00ean"};
        JTextArea jTextArea = new JTextArea(3, 40);
        for (String object2 : stringArray) {
            jComponent = new JButton(object2);
            jComponent.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
            ((AbstractButton)jComponent).setFocusPainted(false);
            jComponent.setCursor(new Cursor(12));
            ((AbstractButton)jComponent).addActionListener(actionEvent -> jTextArea.setText(object2));
            jPanel3.add(jComponent);
        }
        JLabel jLabel3 = new JLabel("<html>M\u00f4 t\u1ea3 t\u00ecnh hu\u1ed1ng, AI s\u1ebd g\u1ee3i \u00fd tin nh\u1eafn ph\u00f9 h\u1ee3p cho nh\u00f3m:</html>");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jTextArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        final JButton jButton = new JButton("T\u1ea1o g\u1ee3i \u00fd");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(new Color(138, 43, 226));
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(130, 40));
        jButton.setCursor(new Cursor(12));
        final JTextArea jTextArea2 = new JTextArea(8, 40);
        jTextArea2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(new Color(248, 249, 250));
        jTextArea2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jTextArea2.setText("G\u1ee3i \u00fd s\u1ebd hi\u1ec3n th\u1ecb \u1edf \u0111\u00e2y...");
        jTextArea2.setForeground(new Color(150, 150, 150));
        jComponent = new JScrollPane(jTextArea2);
        jComponent.setBorder(BorderFactory.createTitledBorder("G\u1ee3i \u00fd t\u1eeb AI:"));
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 10, 0));
        jPanel4.setOpaque(false);
        final JButton jButton2 = new JButton("T\u1ea1o l\u1ea1i");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton2.setEnabled(false);
        jButton2.setCursor(new Cursor(12));
        final JButton jButton3 = new JButton("Sao ch\u00e9p");
        jButton3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton3.setEnabled(false);
        jButton3.setCursor(new Cursor(12));
        jButton3.addActionListener(actionEvent2 -> {
            StringSelection stringSelection = new StringSelection(jTextArea2.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            jButton3.setText("\u0110\u00e3 sao ch\u00e9p!");
            Timer timer = new Timer(2000, actionEvent -> jButton3.setText("Sao ch\u00e9p"));
            timer.setRepeats(false);
            timer.start();
        });
        final JButton jButton4 = new JButton("S\u1eed d\u1ee5ng");
        jButton4.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton4.setBackground(PRIMARY_COLOR);
        jButton4.setForeground(Color.WHITE);
        jButton4.setFocusPainted(false);
        jButton4.setBorderPainted(false);
        jButton4.setEnabled(false);
        jButton4.setCursor(new Cursor(12));
        jButton4.addActionListener(actionEvent -> {
            this.messageInput.setText(jTextArea2.getText());
            jDialog.dispose();
        });
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        Runnable runnable = () -> {
            final String string = jTextArea.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp y\u00eau c\u1ea7u!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            jButton.setEnabled(false);
            jButton.setText("\u23f3 \u0110ang t\u1ea1o...");
            jButton2.setEnabled(false);
            jTextArea2.setText("AI \u0111ang suy ngh\u0129...");
            jTextArea2.setForeground(new Color(100, 100, 100));
            SwingWorker<String, Void> swingWorker = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() {
                    String string2 = "\u0110ang chat trong nh\u00f3m: " + GroupChatPanel.this.groupName;
                    return GroupChatPanel.this.aiService.generateSuggestion(string, string2);
                }

                @Override
                protected void done() {
                    try {
                        String string2 = (String)this.get();
                        jTextArea2.setText(string2);
                        jTextArea2.setForeground(Color.BLACK);
                        jButton3.setEnabled(true);
                        jButton4.setEnabled(true);
                        jButton2.setEnabled(true);
                        jButton.setEnabled(true);
                        jButton.setText("T\u1ea1o g\u1ee3i \u00fd");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jTextArea2.setText("L\u1ed7i: Kh\u00f4ng th\u1ec3 t\u1ea1o g\u1ee3i \u00fd! Vui l\u00f2ng th\u1eed l\u1ea1i.");
                        jTextArea2.setForeground(new Color(200, 50, 50));
                        jButton.setEnabled(true);
                        jButton.setText("T\u1ea1o g\u1ee3i \u00fd");
                    }
                }
            };
            swingWorker.execute();
        };
        jButton.addActionListener(actionEvent -> runnable.run());
        jButton2.addActionListener(actionEvent -> runnable.run());
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.setOpaque(false);
        jPanel5.add((Component)jLabel3, "North");
        jPanel5.add((Component)jScrollPane, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 0));
        jPanel6.setOpaque(false);
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.add((Component)jButton, "East");
        JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
        jPanel7.setOpaque(false);
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 10));
        jPanel8.setOpaque(false);
        jPanel8.add((Component)jComponent, "Center");
        jPanel8.add((Component)jPanel4, "South");
        jPanel2.add((Component)jPanel7, "North");
        jPanel2.add((Component)jPanel8, "Center");
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.setVisible(true);
    }
}

