/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.AIService;
import user.service.UserService;
import user.socket.Message;

public class ChatContentPanel
extends JPanel {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color SENT_BUBBLE_COLOR = new Color(0, 132, 255);
    private static final Color RECEIVED_BUBBLE_COLOR = new Color(240, 242, 245);
    private static final Color BG_COLOR = Color.WHITE;
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private AIService aiService;
    private String currentChatUser;
    private JLabel chatUserLabel;
    private JLabel statusLabel;
    private JPanel messageListPanel;
    private JScrollPane scrollPane;
    private JTextArea messageInput;
    private JButton sendButton;
    private Map<Integer, JPanel> messageBubbles = new HashMap<Integer, JPanel>();

    public ChatContentPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.aiService = new AIService();
        this.initializeUI();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        JPanel jPanel = this.createHeaderPanel();
        this.messageListPanel = new JPanel();
        this.messageListPanel.setLayout(new BoxLayout(this.messageListPanel, 1));
        this.messageListPanel.setBackground(BG_COLOR);
        this.messageListPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.scrollPane = new JScrollPane(this.messageListPanel);
        this.scrollPane.setBorder(null);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel jPanel2 = this.createInputPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)jPanel2, "South");
        this.showWelcomeMessage();
    }

    private JPanel createHeaderPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        this.chatUserLabel = new JLabel("Ch\u1ecdn m\u1ed9t cu\u1ed9c tr\u00f2 chuy\u1ec7n");
        this.chatUserLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        this.statusLabel = new JLabel("B\u1eaft \u0111\u1ea7u chat ngay!");
        this.statusLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        this.statusLabel.setForeground(new Color(120, 120, 120));
        jPanel2.add(this.chatUserLabel);
        jPanel2.add(this.statusLabel);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 0));
        jPanel3.setOpaque(false);
        JButton jButton = this.createHeaderButton("icons/bin.png", "X\u00f3a l\u1ecbch s\u1eed", 22);
        JButton jButton2 = this.createHeaderButton("icons/search.png", "T\u00ecm ki\u1ebfm", 22);
        JButton jButton3 = this.createHeaderButton("icons/generative.png", "Tr\u1ee3 l\u00fd AI", 22);
        JButton jButton4 = this.createHeaderButton("icons/alert-sign.png", "B\u00e1o c\u00e1o spam", 22);
        jButton.addActionListener(actionEvent -> {
            if (this.currentChatUser != null) {
                this.clearCurrentChatHistory();
            }
        });
        jButton2.addActionListener(actionEvent -> {
            if (this.currentChatUser != null) {
                this.showSearchInChatDialog();
            }
        });
        jButton3.addActionListener(actionEvent -> this.showLLMAssistant());
        jButton4.addActionListener(actionEvent -> {
            if (this.currentChatUser != null) {
                this.showReportSpamDialog();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JButton createHeaderButton(String string, String string2, int n) {
        final JButton jButton = new JButton();
        try {
            ImageIcon imageIcon = new ImageIcon(string);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            jButton.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            jButton.setText("?");
            jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y icon: " + string);
        }
        jButton.setPreferredSize(new Dimension(36, 36));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setToolTipText(string2);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(true);
                jButton.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(false);
            }
        });
        return jButton;
    }

    private JPanel createInputPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(220, 220, 220)), BorderFactory.createEmptyBorder(12, 15, 12, 15)));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setOpaque(false);
        this.messageInput = new JTextArea();
        this.messageInput.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.messageInput.setLineWrap(true);
        this.messageInput.setWrapStyleWord(true);
        this.messageInput.setRows(2);
        this.messageInput.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1, true), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        JScrollPane jScrollPane = new JScrollPane(this.messageInput);
        jScrollPane.setBorder(null);
        this.sendButton = new JButton("G\u1eedi");
        this.sendButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        this.sendButton.setForeground(Color.WHITE);
        this.sendButton.setBackground(PRIMARY_COLOR);
        this.sendButton.setPreferredSize(new Dimension(70, 50));
        this.sendButton.setBorderPainted(false);
        this.sendButton.setFocusPainted(false);
        this.sendButton.setOpaque(true);
        this.sendButton.setContentAreaFilled(true);
        this.sendButton.setCursor(new Cursor(12));
        this.sendButton.addActionListener(actionEvent -> this.sendMessage());
        this.sendButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ChatContentPanel.this.sendButton.setBackground(new Color(0, 102, 204));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ChatContentPanel.this.sendButton.setBackground(PRIMARY_COLOR);
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)this.sendButton, "East");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JButton createInputButton(String string, String string2) {
        final JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getEmojiFontName(), 0, 20));
        jButton.setPreferredSize(new Dimension(40, 40));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setToolTipText(string2);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(true);
                jButton.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(false);
            }
        });
        return jButton;
    }

    private void showWelcomeMessage() {
        JLabel jLabel = new JLabel("Ch\u00e0o m\u1eebng \u0111\u1ebfn v\u1edbi Zalo Chat!");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 24));
        jLabel.setForeground(new Color(150, 150, 150));
        jLabel.setAlignmentX(0.5f);
        JLabel jLabel2 = new JLabel("Ch\u1ecdn m\u1ed9t cu\u1ed9c tr\u00f2 chuy\u1ec7n \u0111\u1ec3 b\u1eaft \u0111\u1ea7u nh\u1eafn tin");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel2.setForeground(new Color(180, 180, 180));
        jLabel2.setAlignmentX(0.5f);
        this.messageListPanel.add(Box.createVerticalGlue());
        this.messageListPanel.add(jLabel);
        this.messageListPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        this.messageListPanel.add(jLabel2);
        this.messageListPanel.add(Box.createVerticalGlue());
    }

    public void openChat(String string) {
        this.currentChatUser = string;
        this.chatUserLabel.setText(string);
        this.updateUserOnlineStatus(string);
        this.messageListPanel.removeAll();
        this.messageBubbles.clear();
        this.messageListPanel.revalidate();
        this.messageListPanel.repaint();
        this.loadChatHistory(string);
    }

    private void updateUserOnlineStatus(String string) {
        boolean bl = false;
        if (this.mainFrame.getSocketClient() != null) {
            List<String> list = this.mainFrame.getSocketClient().getOnlineUsers();
            bl = list.contains(string);
        }
        if (bl) {
            this.statusLabel.setText("\u25cf \u0110ang ho\u1ea1t \u0111\u1ed9ng");
            this.statusLabel.setForeground(new Color(67, 220, 96));
        } else {
            this.statusLabel.setText("\u25cb Kh\u00f4ng ho\u1ea1t \u0111\u1ed9ng");
            this.statusLabel.setForeground(new Color(120, 120, 120));
        }
    }

    public void refreshOnlineStatus() {
        if (this.currentChatUser != null && !this.currentChatUser.isEmpty()) {
            this.updateUserOnlineStatus(this.currentChatUser);
        }
    }

    private void loadChatHistory(final String string) {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return ChatContentPanel.this.userService.getChatHistory(ChatContentPanel.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    List list = (List)this.get();
                    if (list != null && !list.isEmpty()) {
                        for (Map map : list) {
                            int n = (Integer)map.get("message_id");
                            String string3 = (String)map.get("sender_username");
                            String string2 = (String)map.get("content");
                            Timestamp timestamp = (Timestamp)map.get("sent_at");
                            boolean bl = string3.equals(ChatContentPanel.this.mainFrame.getUsername());
                            LocalDateTime localDateTime = timestamp.toLocalDateTime();
                            ChatContentPanel.this.addMessageBubble(n, string2, bl, localDateTime);
                        }
                        ChatContentPanel.this.messageListPanel.add(Box.createVerticalGlue());
                        ChatContentPanel.this.scrollToBottom();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        swingWorker.execute();
    }

    private void sendMessage() {
        String string = this.messageInput.getText().trim();
        if (!string.isEmpty() && this.currentChatUser != null) {
            System.out.println("\ud83d\udcac User g\u1eedi: '" + string + "' \u2192 " + this.currentChatUser);
            int n = this.userService.saveMessage(this.mainFrame.getUsername(), this.currentChatUser, string);
            System.out.println(n > 0 ? "\u2705 \u0110\u00e3 l\u01b0u v\u00e0o DB" : "\u274c L\u01b0u DB th\u1ea5t b\u1ea1i");
            this.mainFrame.sendMessage(string, this.currentChatUser);
            if (n > 0) {
                this.addMessageBubble(n, string, true, LocalDateTime.now());
            }
            this.mainFrame.refreshChatList();
            this.messageInput.setText("");
            this.scrollToBottom();
        } else {
            if (string.isEmpty()) {
                System.err.println("\u26a0\ufe0f Tin nh\u1eafn tr\u1ed1ng, kh\u00f4ng g\u1eedi");
            }
            if (this.currentChatUser == null) {
                System.err.println("\u26a0\ufe0f Ch\u01b0a ch\u1ecdn ng\u01b0\u1eddi nh\u1eadn");
            }
        }
    }

    private void addMessageBubble(int n, String string, boolean bl, LocalDateTime localDateTime) {
        JPanel jPanel = new JPanel(new FlowLayout(bl ? 2 : 0, 10, 3));
        jPanel.setOpaque(false);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setOpaque(false);
        final JButton jButton = new JButton("...");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setForeground(new Color(150, 150, 150));
        jButton.setContentAreaFilled(false);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setPreferredSize(new Dimension(25, 25));
        jButton.setMaximumSize(new Dimension(25, 25));
        jButton.setVisible(false);
        final JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(bl ? SENT_BUBBLE_COLOR : RECEIVED_BUBBLE_COLOR);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea.setForeground(bl ? Color.WHITE : new Color(51, 51, 51));
        jTextArea.setBackground(bl ? SENT_BUBBLE_COLOR : RECEIVED_BUBBLE_COLOR);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jTextArea.setSize(new Dimension(280, Short.MAX_VALUE));
        Dimension dimension = jTextArea.getPreferredSize();
        jTextArea.setPreferredSize(new Dimension(Math.min(280, dimension.width), dimension.height));
        JLabel jLabel = new JLabel(localDateTime.format(DateTimeFormatter.ofPattern("HH:mm")));
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 10));
        jLabel.setForeground(bl ? new Color(220, 235, 255) : new Color(120, 120, 120));
        jLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jLabel.setAlignmentX(bl ? 1.0f : 0.0f);
        jPanel3.add(jTextArea);
        jPanel3.add(jLabel);
        if (bl) {
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(jPanel3);
        } else {
            jPanel2.add(jPanel3);
            jPanel2.add(Box.createHorizontalStrut(5));
            jPanel2.add(jButton);
        }
        jPanel.add(jPanel2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setVisible(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Point point2 = jPanel3.getLocationOnScreen();
                Rectangle rectangle = new Rectangle(point2, jPanel3.getSize());
                Point point3 = jButton.getLocationOnScreen();
                Rectangle rectangle2 = new Rectangle(point3, jButton.getSize());
                if (!rectangle.contains(point) && !rectangle2.contains(point)) {
                    jButton.setVisible(false);
                }
            }
        };
        jPanel3.addMouseListener(mouseAdapter);
        jButton.addMouseListener(mouseAdapter);
        jPanel.addMouseListener(mouseAdapter);
        jButton.addActionListener(actionEvent -> this.showMessageMenu(jButton, n, bl, jPanel));
        if (n > 0) {
            this.messageBubbles.put(n, jPanel);
        }
        this.messageListPanel.add(jPanel);
        this.messageListPanel.revalidate();
        this.messageListPanel.repaint();
    }

    private void addMessageBubble(String string, boolean bl, LocalDateTime localDateTime) {
        this.addMessageBubbleWithoutMenu(string, bl, localDateTime);
    }

    private void addMessageBubbleWithoutMenu(String string, boolean bl, LocalDateTime localDateTime) {
        JPanel jPanel = new JPanel(new FlowLayout(bl ? 2 : 0, 10, 3));
        jPanel.setOpaque(false);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(bl ? SENT_BUBBLE_COLOR : RECEIVED_BUBBLE_COLOR);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea.setForeground(bl ? Color.WHITE : new Color(51, 51, 51));
        jTextArea.setBackground(bl ? SENT_BUBBLE_COLOR : RECEIVED_BUBBLE_COLOR);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jTextArea.setSize(new Dimension(280, Short.MAX_VALUE));
        Dimension dimension = jTextArea.getPreferredSize();
        jTextArea.setPreferredSize(new Dimension(Math.min(280, dimension.width), dimension.height));
        JLabel jLabel = new JLabel(localDateTime.format(DateTimeFormatter.ofPattern("HH:mm")));
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 10));
        jLabel.setForeground(bl ? new Color(220, 235, 255) : new Color(120, 120, 120));
        jLabel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jLabel.setAlignmentX(bl ? 1.0f : 0.0f);
        jPanel2.add(jTextArea);
        jPanel2.add(jLabel);
        jPanel.add(jPanel2);
        this.messageListPanel.add(jPanel);
        this.messageListPanel.revalidate();
        this.messageListPanel.repaint();
    }

    private void showMessageMenu(JButton jButton, int n, boolean bl, JPanel jPanel) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)));
        JMenuItem jMenuItem = new JMenuItem("X\u00f3a ch\u1ec9 m\u00ecnh t\u00f4i");
        jMenuItem.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jMenuItem.addActionListener(actionEvent -> {
            int n2 = JOptionPane.showConfirmDialog(this, "Tin nh\u1eafn s\u1ebd b\u1ecb x\u00f3a kh\u1ecfi thi\u1ebft b\u1ecb n\u00e0y.\nNg\u01b0\u1eddi kh\u00e1c v\u1eabn c\u00f3 th\u1ec3 nh\u00ecn th\u1ea5y tin nh\u1eafn.", "X\u00f3a tin nh\u1eafn?", 0, 2);
            if (n2 == 0) {
                boolean bl = this.userService.deleteMessageForMe(n, this.mainFrame.getUsername());
                if (bl) {
                    this.messageListPanel.remove(jPanel);
                    this.messageListPanel.revalidate();
                    this.messageListPanel.repaint();
                    JOptionPane.showMessageDialog(this, "\u0110\u00e3 x\u00f3a tin nh\u1eafn", "Th\u00e0nh c\u00f4ng", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Kh\u00f4ng th\u1ec3 x\u00f3a tin nh\u1eafn", "L\u1ed7i", 0);
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        if (bl) {
            JMenuItem jMenuItem2 = new JMenuItem("Thu h\u1ed3i tin nh\u1eafn");
            jMenuItem2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
            jMenuItem2.setForeground(new Color(220, 53, 69));
            jMenuItem2.addActionListener(actionEvent -> {
                int n2 = JOptionPane.showConfirmDialog(this, "Tin nh\u1eafn s\u1ebd b\u1ecb x\u00f3a v\u0129nh vi\u1ec5n cho t\u1ea5t c\u1ea3 m\u1ecdi ng\u01b0\u1eddi.\nB\u1ea1n c\u00f3 ch\u1eafc ch\u1eafn mu\u1ed1n thu h\u1ed3i?", "Thu h\u1ed3i tin nh\u1eafn?", 0, 2);
                if (n2 == 0) {
                    boolean bl = this.userService.recallMessage(n, this.mainFrame.getUsername());
                    if (bl) {
                        this.messageListPanel.remove(jPanel);
                        this.messageListPanel.revalidate();
                        this.messageListPanel.repaint();
                        JOptionPane.showMessageDialog(this, "\u0110\u00e3 thu h\u1ed3i tin nh\u1eafn", "Th\u00e0nh c\u00f4ng", 1);
                    } else {
                        JOptionPane.showMessageDialog(this, "Kh\u00f4ng th\u1ec3 thu h\u1ed3i tin nh\u1eafn", "L\u1ed7i", 0);
                    }
                }
            });
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenuItem2);
        }
        jPopupMenu.show(jButton, 0, jButton.getHeight());
    }

    public void handleMessage(Message message) {
        System.out.println("\ud83d\udce9 Nh\u1eadn message: " + String.valueOf((Object)message.getType()) + " t\u1eeb " + message.getSender());
        switch (message.getType()) {
            case CHAT: 
            case PRIVATE_MESSAGE: {
                String string = message.getSender();
                String string2 = message.getContent();
                System.out.println("  \ud83d\udcac N\u1ed9i dung: " + string2);
                System.out.println("  \ud83d\udc64 Current chat user: " + this.currentChatUser);
                if (this.currentChatUser != null && string.equals(this.currentChatUser)) {
                    this.addMessageBubble(string2, false, LocalDateTime.now());
                    this.scrollToBottom();
                    System.out.println("  \u2705 \u0110\u00e3 hi\u1ec3n th\u1ecb message bubble");
                    break;
                }
                System.out.println("  \u26a0\ufe0f Kh\u00f4ng hi\u1ec3n th\u1ecb (kh\u00f4ng \u0111ang chat v\u1edbi " + string + ")");
                break;
            }
            case USER_JOINED: {
                if (this.currentChatUser == null || !message.getSender().equals(this.currentChatUser)) break;
                this.statusLabel.setText("\u25cf \u0110ang ho\u1ea1t \u0111\u1ed9ng");
                break;
            }
            case USER_LEFT: {
                if (this.currentChatUser == null || !message.getSender().equals(this.currentChatUser)) break;
                this.statusLabel.setText("\u25cb Kh\u00f4ng ho\u1ea1t \u0111\u1ed9ng");
                break;
            }
        }
    }

    public void scrollToBottom() {
        SwingUtilities.invokeLater(() -> {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
        });
    }

    public void scrollToMessage(int n) {
        JPanel jPanel = this.messageBubbles.get(n);
        if (jPanel != null) {
            SwingUtilities.invokeLater(() -> {
                Rectangle rectangle = jPanel.getBounds();
                jPanel.scrollRectToVisible(rectangle);
                Color color = jPanel.getBackground();
                jPanel.setOpaque(true);
                jPanel.setBackground(new Color(255, 255, 150));
                Timer timer = new Timer(2000, actionEvent -> {
                    jPanel.setOpaque(false);
                    jPanel.setBackground(color);
                    jPanel.repaint();
                });
                timer.setRepeats(false);
                timer.start();
                jPanel.repaint();
            });
        } else {
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y tin nh\u1eafn v\u1edbi ID: " + n);
        }
    }

    private void showReportSpamDialog() {
        if (this.currentChatUser == null) {
            return;
        }
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "B\u00e1o c\u00e1o spam", true);
        jDialog.setSize(450, 300);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(255, 59, 48));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("B\u00e1o c\u00e1o spam: " + this.currentChatUser);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        jPanel2.setBackground(Color.WHITE);
        JLabel jLabel2 = new JLabel("Vui l\u00f2ng ch\u1ecdn l\u00fd do b\u00e1o c\u00e1o:");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(10));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Tin nh\u1eafn spam", true);
        JRadioButton jRadioButton2 = new JRadioButton("Qu\u1ea5y r\u1ed1i");
        JRadioButton jRadioButton3 = new JRadioButton("N\u1ed9i dung kh\u00f4ng ph\u00f9 h\u1ee3p");
        JRadioButton jRadioButton4 = new JRadioButton("L\u1eeba \u0111\u1ea3o");
        JRadioButton jRadioButton5 = new JRadioButton("Kh\u00e1c");
        jRadioButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jRadioButton2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jRadioButton3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jRadioButton4.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jRadioButton5.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jRadioButton.setBackground(Color.WHITE);
        jRadioButton2.setBackground(Color.WHITE);
        jRadioButton3.setBackground(Color.WHITE);
        jRadioButton4.setBackground(Color.WHITE);
        jRadioButton5.setBackground(Color.WHITE);
        jRadioButton.setAlignmentX(0.0f);
        jRadioButton2.setAlignmentX(0.0f);
        jRadioButton3.setAlignmentX(0.0f);
        jRadioButton4.setAlignmentX(0.0f);
        jRadioButton5.setAlignmentX(0.0f);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
        jPanel2.add(jRadioButton);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jRadioButton2);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jRadioButton3);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jRadioButton4);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jRadioButton5);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 10, 10));
        jPanel3.setBackground(Color.WHITE);
        JButton jButton = new JButton("H\u1ee7y");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton.setPreferredSize(new Dimension(100, 35));
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        final JButton jButton2 = new JButton("G\u1eedi b\u00e1o c\u00e1o");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton2.setBackground(new Color(255, 59, 48));
        jButton2.setForeground(Color.WHITE);
        jButton2.setPreferredSize(new Dimension(120, 35));
        jButton2.setFocusPainted(false);
        jButton2.setBorderPainted(false);
        jButton2.setOpaque(true);
        jButton2.setContentAreaFilled(true);
        jButton2.addActionListener(actionEvent -> {
            final String string = jRadioButton.isSelected() ? "Tin nh\u1eafn spam" : (jRadioButton2.isSelected() ? "Qu\u1ea5y r\u1ed1i" : (jRadioButton3.isSelected() ? "N\u1ed9i dung kh\u00f4ng ph\u00f9 h\u1ee3p" : (jRadioButton4.isSelected() ? "L\u1eeba \u0111\u1ea3o" : (jRadioButton5.isSelected() ? "Kh\u00e1c" : "Kh\u00e1c"))));
            jButton2.setEnabled(false);
            jButton2.setText("\u0110ang g\u1eedi...");
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return ChatContentPanel.this.userService.reportSpam(ChatContentPanel.this.mainFrame.getUsername(), ChatContentPanel.this.currentChatUser, string);
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            JOptionPane.showMessageDialog(jDialog, "B\u00e1o c\u00e1o c\u1ee7a b\u1ea1n \u0111\u00e3 \u0111\u01b0\u1ee3c g\u1eedi.\nCh\u00fang t\u00f4i s\u1ebd xem x\u00e9t v\u00e0 x\u1eed l\u00fd.", "Th\u00e0nh c\u00f4ng", 1);
                            jDialog.dispose();
                        } else {
                            JOptionPane.showMessageDialog(jDialog, "Kh\u00f4ng th\u1ec3 g\u1eedi b\u00e1o c\u00e1o. Vui l\u00f2ng th\u1eed l\u1ea1i!", "L\u1ed7i", 0);
                            jButton2.setEnabled(true);
                            jButton2.setText("G\u1eedi b\u00e1o c\u00e1o");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(jDialog, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                        jButton2.setEnabled(true);
                        jButton2.setText("G\u1eedi b\u00e1o c\u00e1o");
                    }
                }
            };
            swingWorker.execute();
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.add((Component)jPanel3, "South");
        jDialog.setVisible(true);
    }

    private void clearCurrentChatHistory() {
        int n = JOptionPane.showConfirmDialog(this, "X\u00f3a to\u00e0n b\u1ed9 l\u1ecbch s\u1eed chat v\u1edbi " + this.currentChatUser + "?\nH\u00e0nh \u0111\u1ed9ng n\u00e0y kh\u00f4ng th\u1ec3 ho\u00e0n t\u00e1c!", "X\u00e1c nh\u1eadn x\u00f3a", 0, 2);
        if (n == 0) {
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return ChatContentPanel.this.userService.deleteChatHistory(ChatContentPanel.this.mainFrame.getUsername(), ChatContentPanel.this.currentChatUser);
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            JOptionPane.showMessageDialog(ChatContentPanel.this, "\u0110\u00e3 x\u00f3a to\u00e0n b\u1ed9 l\u1ecbch s\u1eed chat!", "Th\u00e0nh c\u00f4ng", 1);
                            ChatContentPanel.this.messageListPanel.removeAll();
                            ChatContentPanel.this.showWelcomeMessage();
                            ChatContentPanel.this.messageListPanel.revalidate();
                            ChatContentPanel.this.messageListPanel.repaint();
                            ChatContentPanel.this.mainFrame.updateChatListAfterDelete(ChatContentPanel.this.currentChatUser);
                        } else {
                            JOptionPane.showMessageDialog(ChatContentPanel.this, "Kh\u00f4ng th\u1ec3 x\u00f3a l\u1ecbch s\u1eed!", "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }
    }

    private void showSearchInChatDialog() {
        final JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "T\u00ecm ki\u1ebfm v\u1edbi " + this.currentChatUser, true);
        jDialog.setSize(600, 500);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("T\u00ecm ki\u1ebfm v\u1edbi " + this.currentChatUser);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 20, 10, 20));
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        final JButton jButton = new JButton("T\u00ecm ki\u1ebfm");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(100, 35));
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setOpaque(false);
        jPanel3.add((Component)new JLabel("T\u1eeb kh\u00f3a:"), "West");
        jPanel3.add((Component)jTextField, "Center");
        jPanel3.add((Component)jButton, "East");
        jPanel2.add((Component)jPanel3, "North");
        final JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane(jPanel4);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel2.add((Component)jScrollPane, "Center");
        jButton.addActionListener(actionEvent -> {
            final String string = jTextField.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp t\u1eeb kh\u00f3a!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            jPanel4.removeAll();
            jButton.setEnabled(false);
            jButton.setText("\u0110ang t\u00ecm...");
            SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

                @Override
                protected List<Map<String, Object>> doInBackground() {
                    return ChatContentPanel.this.userService.searchInChatHistory(ChatContentPanel.this.mainFrame.getUsername(), ChatContentPanel.this.currentChatUser, string);
                }

                @Override
                protected void done() {
                    try {
                        List list = (List)this.get();
                        if (list == null || list.isEmpty()) {
                            JLabel jLabel = new JLabel("Kh\u00f4ng t\u00ecm th\u1ea5y k\u1ebft qu\u1ea3");
                            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                            jLabel.setForeground(new Color(150, 150, 150));
                            jPanel4.add(jLabel);
                        } else {
                            for (Map map : list) {
                                int n = (Integer)map.get("id");
                                String string4 = (String)map.get("sender");
                                String string2 = (String)map.get("content");
                                Timestamp timestamp = (Timestamp)map.get("sent_at");
                                final JPanel jPanel = new JPanel(new BorderLayout(10, 5));
                                jPanel.setBackground(Color.WHITE);
                                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)), BorderFactory.createEmptyBorder(12, 10, 12, 10)));
                                jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
                                jPanel.setCursor(Cursor.getPredefinedCursor(12));
                                boolean bl = string4.equals(ChatContentPanel.this.mainFrame.getUsername());
                                String string3 = new SimpleDateFormat("dd/MM HH:mm").format(timestamp);
                                JLabel jLabel = new JLabel((bl ? "B\u1ea1n" : string4) + " - " + string3);
                                jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 12));
                                jLabel.setForeground(bl ? PRIMARY_COLOR : new Color(100, 100, 100));
                                JLabel jLabel2 = new JLabel("<html>" + ChatContentPanel.this.highlightKeyword(string2, string) + "</html>");
                                jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
                                JLabel jLabel3 = new JLabel("\u2192");
                                jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
                                jLabel3.setForeground(PRIMARY_COLOR);
                                JPanel jPanel2 = new JPanel();
                                jPanel2.setLayout(new BoxLayout(jPanel2, 1));
                                jPanel2.setOpaque(false);
                                jPanel2.add(jLabel);
                                jPanel2.add(jLabel2);
                                jPanel.add((Component)jPanel2, "Center");
                                jPanel.add((Component)jLabel3, "East");
                                final int n2 = n;
                                jPanel.addMouseListener(new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent mouseEvent) {
                                        jDialog.dispose();
                                        ChatContentPanel.this.scrollToMessage(n2);
                                    }

                                    @Override
                                    public void mouseEntered(MouseEvent mouseEvent) {
                                        jPanel.setBackground(new Color(240, 245, 255));
                                    }

                                    @Override
                                    public void mouseExited(MouseEvent mouseEvent) {
                                        jPanel.setBackground(Color.WHITE);
                                    }
                                });
                                jPanel4.add(jPanel);
                            }
                        }
                        jPanel4.revalidate();
                        jPanel4.repaint();
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jButton.setEnabled(true);
                        jButton.setText("T\u00ecm ki\u1ebfm");
                    }
                }
            };
            swingWorker.execute();
        });
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.setVisible(true);
    }

    private String highlightKeyword(String string, String string2) {
        if (string == null || string2 == null) {
            return string;
        }
        return string.replaceAll("(?i)(" + string2 + ")", "<span style='background-color: yellow; font-weight: bold;'>$1</span>");
    }

    private void showLLMAssistant() {
        JComponent jComponent;
        JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Tr\u1ee3 l\u00fd AI", true);
        jDialog.setSize(650, 600);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(new Color(138, 43, 226));
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("Tr\u1ee3 l\u00fd AI - G\u1ee3i \u00fd tin nh\u1eafn");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        jLabel.setForeground(Color.WHITE);
        JLabel jLabel2 = new JLabel(this.aiService.isAPIConfigured() ? "Online" : "Offline Mode");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel2.setForeground(new Color(200, 200, 255));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jLabel2, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 15));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 8, 5));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createTitledBorder("G\u1ee3i \u00fd nhanh:"));
        String[] stringArray = new String[]{"Xin l\u1ed7i", "C\u1ea3m \u01a1n", "Ch\u00fac m\u1eebng", "H\u1eb9n g\u1eb7p", "H\u1ecfi th\u0103m", "\u0110\u1ed9ng vi\u00ean", "T\u1eeb ch\u1ed1i l\u1ecbch s\u1ef1"};
        JTextArea jTextArea = new JTextArea(3, 40);
        for (String object2 : stringArray) {
            jComponent = new JButton(object2);
            jComponent.setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
            ((AbstractButton)jComponent).setFocusPainted(false);
            jComponent.setCursor(new Cursor(12));
            ((AbstractButton)jComponent).addActionListener(actionEvent -> jTextArea.setText(object2));
            jPanel3.add(jComponent);
        }
        JLabel jLabel3 = new JLabel("<html>M\u00f4 t\u1ea3 t\u00ecnh hu\u1ed1ng ho\u1eb7c nh\u1eadp y\u00eau c\u1ea7u, AI s\u1ebd g\u1ee3i \u00fd tin nh\u1eafn ph\u00f9 h\u1ee3p:</html>");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jTextArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        final JButton jButton = new JButton("T\u1ea1o g\u1ee3i \u00fd");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setBackground(new Color(138, 43, 226));
        jButton.setForeground(Color.WHITE);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setPreferredSize(new Dimension(130, 40));
        jButton.setCursor(new Cursor(12));
        final JTextArea jTextArea2 = new JTextArea(8, 40);
        jTextArea2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(new Color(248, 249, 250));
        jTextArea2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jTextArea2.setText("G\u1ee3i \u00fd s\u1ebd hi\u1ec3n th\u1ecb \u1edf \u0111\u00e2y...");
        jTextArea2.setForeground(new Color(150, 150, 150));
        jComponent = new JScrollPane(jTextArea2);
        jComponent.setBorder(BorderFactory.createTitledBorder("G\u1ee3i \u00fd t\u1eeb AI:"));
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 10, 0));
        jPanel4.setOpaque(false);
        final JButton jButton2 = new JButton("T\u1ea1o l\u1ea1i");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton2.setEnabled(false);
        jButton2.setCursor(new Cursor(12));
        final JButton jButton3 = new JButton("Sao ch\u00e9p");
        jButton3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton3.setEnabled(false);
        jButton3.setCursor(new Cursor(12));
        jButton3.addActionListener(actionEvent2 -> {
            StringSelection stringSelection = new StringSelection(jTextArea2.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            jButton3.setText("\u0110\u00e3 sao ch\u00e9p!");
            Timer timer = new Timer(2000, actionEvent -> jButton3.setText("Sao ch\u00e9p"));
            timer.setRepeats(false);
            timer.start();
        });
        final JButton jButton4 = new JButton("S\u1eed d\u1ee5ng");
        jButton4.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton4.setBackground(PRIMARY_COLOR);
        jButton4.setForeground(Color.WHITE);
        jButton4.setFocusPainted(false);
        jButton4.setBorderPainted(false);
        jButton4.setEnabled(false);
        jButton4.setCursor(new Cursor(12));
        jButton4.addActionListener(actionEvent -> {
            this.messageInput.setText(jTextArea2.getText());
            jDialog.dispose();
        });
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        Runnable runnable = () -> {
            final String string = jTextArea.getText().trim();
            if (string.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng nh\u1eadp y\u00eau c\u1ea7u!", "Th\u00f4ng b\u00e1o", 2);
                return;
            }
            jButton.setEnabled(false);
            jButton.setText("\u23f3 \u0110ang t\u1ea1o...");
            jButton2.setEnabled(false);
            jTextArea2.setText("AI \u0111ang suy ngh\u0129...");
            jTextArea2.setForeground(new Color(100, 100, 100));
            SwingWorker<String, Void> swingWorker = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() {
                    Object object = "";
                    if (ChatContentPanel.this.currentChatUser != null) {
                        object = "\u0110ang chat v\u1edbi: " + ChatContentPanel.this.currentChatUser;
                    }
                    return ChatContentPanel.this.aiService.generateSuggestion(string, (String)object);
                }

                @Override
                protected void done() {
                    try {
                        String string2 = (String)this.get();
                        jTextArea2.setText(string2);
                        jTextArea2.setForeground(Color.BLACK);
                        jButton3.setEnabled(true);
                        jButton4.setEnabled(true);
                        jButton2.setEnabled(true);
                        jButton.setEnabled(true);
                        jButton.setText("T\u1ea1o g\u1ee3i \u00fd");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jTextArea2.setText("L\u1ed7i: Kh\u00f4ng th\u1ec3 t\u1ea1o g\u1ee3i \u00fd! Vui l\u00f2ng th\u1eed l\u1ea1i.");
                        jTextArea2.setForeground(new Color(200, 50, 50));
                        jButton.setEnabled(true);
                        jButton.setText("T\u1ea1o g\u1ee3i \u00fd");
                    }
                }
            };
            swingWorker.execute();
        };
        jButton.addActionListener(actionEvent -> runnable.run());
        jButton2.addActionListener(actionEvent -> runnable.run());
        JPanel jPanel5 = new JPanel(new BorderLayout(5, 5));
        jPanel5.setOpaque(false);
        jPanel5.add((Component)jLabel3, "North");
        jPanel5.add((Component)jScrollPane, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 0));
        jPanel6.setOpaque(false);
        jPanel6.add((Component)jPanel5, "Center");
        jPanel6.add((Component)jButton, "East");
        JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
        jPanel7.setOpaque(false);
        jPanel7.add((Component)jPanel3, "North");
        jPanel7.add((Component)jPanel6, "Center");
        JPanel jPanel8 = new JPanel(new BorderLayout(0, 10));
        jPanel8.setOpaque(false);
        jPanel8.add((Component)jComponent, "Center");
        jPanel8.add((Component)jPanel4, "South");
        jPanel2.add((Component)jPanel7, "North");
        jPanel2.add((Component)jPanel8, "Center");
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jPanel2, "Center");
        jDialog.setVisible(true);
    }
}

