/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import admin.service.DatabaseConnection;
import admin.socket.SpamReport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SpamReportDAO {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    public List<SpamReport> getAllSpamReports() throws SQLException {
        ArrayList<SpamReport> arrayList = new ArrayList<SpamReport>();
        String string = "SELECT sr.report_id, sr.reporter_id, sr.reported_user_id, sr.reason, sr.report_time, sr.status, COALESCE(u1.full_name, 'User #' || sr.reporter_id) as reporter_name, COALESCE(u2.full_name, 'User #' || sr.reported_user_id) as reported_user_name FROM spam_reports sr LEFT JOIN users u1 ON sr.reporter_id = u1.user_id LEFT JOIN users u2 ON sr.reported_user_id = u2.user_id ORDER BY sr.report_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                arrayList.add(this.extractSpamReportFromResultSet(resultSet));
            }
        }
        return arrayList;
    }

    public List<SpamReport> getReportsByStatus(String string) throws SQLException {
        ArrayList<SpamReport> arrayList = new ArrayList<SpamReport>();
        String string2 = "SELECT sr.report_id, sr.reporter_id, sr.reported_user_id, sr.reason, sr.report_time, sr.status, COALESCE(u1.full_name, 'User #' || sr.reporter_id) as reporter_name, COALESCE(u2.full_name, 'User #' || sr.reported_user_id) as reported_user_name FROM spam_reports sr LEFT JOIN users u1 ON sr.reporter_id = u1.user_id LEFT JOIN users u2 ON sr.reported_user_id = u2.user_id WHERE sr.status = ? ORDER BY sr.report_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractSpamReportFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public boolean updateReportStatus(int n, String string) throws SQLException {
        String string2 = "UPDATE spam_reports SET status = ? WHERE report_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public int getTotalReports() throws SQLException {
        String string = "SELECT COUNT(*) FROM spam_reports";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public int countReportsByStatus(String string) throws SQLException {
        String string2 = "SELECT COUNT(*) FROM spam_reports WHERE status = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    public List<SpamReport> searchSpamReports(String string, String string2, String string3, String string4, String string5) throws SQLException {
        int n;
        Object object;
        ArrayList<SpamReport> arrayList = new ArrayList<SpamReport>();
        StringBuilder stringBuilder = new StringBuilder("SELECT sr.report_id, sr.reporter_id, sr.reported_user_id, sr.reason, sr.report_time, sr.status, COALESCE(u1.full_name, 'User #' || sr.reporter_id) as reporter_name, u1.username as reporter_username, COALESCE(u2.full_name, 'User #' || sr.reported_user_id) as reported_user_name, u2.username as reported_username FROM spam_reports sr LEFT JOIN users u1 ON sr.reporter_id = u1.user_id LEFT JOIN users u2 ON sr.reported_user_id = u2.user_id WHERE 1=1");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (string2 != null && !string2.trim().isEmpty()) {
            if ("reporter".equals(string)) {
                stringBuilder.append(" AND (u1.full_name LIKE ? OR u1.username LIKE ? OR u1.email LIKE ?)");
            } else {
                stringBuilder.append(" AND (u2.full_name LIKE ? OR u2.username LIKE ? OR u2.email LIKE ?)");
            }
            object = "%" + string2.trim() + "%";
            arrayList2.add(object);
            arrayList2.add(object);
            arrayList2.add(object);
        }
        if (string3 != null && !"T\u1ea5t c\u1ea3 th\u1eddi gian".equals(string3)) {
            switch (string3) {
                case "H\u00f4m nay": {
                    stringBuilder.append(" AND DATE(sr.report_time) = CURRENT_DATE");
                    break;
                }
                case "7 ng\u00e0y qua": {
                    stringBuilder.append(" AND sr.report_time >= NOW() - INTERVAL '7 days'");
                    break;
                }
                case "30 ng\u00e0y qua": {
                    stringBuilder.append(" AND sr.report_time >= NOW() - INTERVAL '30 days'");
                    break;
                }
                case "Th\u00e1ng n\u00e0y": {
                    stringBuilder.append(" AND EXTRACT(MONTH FROM sr.report_time) = EXTRACT(MONTH FROM NOW()) AND EXTRACT(YEAR FROM sr.report_time) = EXTRACT(YEAR FROM NOW())");
                }
            }
        }
        if (string4 != null && !"T\u1ea5t c\u1ea3 tr\u1ea1ng th\u00e1i".equals(string4)) {
            String string6 = string4;
            n = -1;
            switch (string6.hashCode()) {
                case -228882060: {
                    if (!string6.equals("Ch\u1edd x\u1eed l\u00fd")) break;
                    n = 0;
                    break;
                }
                case -1834241009: {
                    if (!string6.equals("\u0110\u00e3 x\u1eed l\u00fd")) break;
                    n = 1;
                    break;
                }
                case 535175238: {
                    if (!string6.equals("T\u1eeb ch\u1ed1i")) break;
                    n = 2;
                }
            }
            switch (n) {
                case 0: {
                    object = "pending";
                    break;
                }
                case 1: {
                    object = "resolved";
                    break;
                }
                case 2: {
                    object = "rejected";
                    break;
                }
                default: {
                    object = string4.toLowerCase();
                }
            }
            stringBuilder.append(" AND sr.status = ?");
            arrayList2.add(object);
        }
        if (string5 != null) {
            switch (string5) {
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian (M\u1edbi nh\u1ea5t)": {
                    stringBuilder.append(" ORDER BY sr.report_time DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo th\u1eddi gian (C\u0169 nh\u1ea5t)": {
                    stringBuilder.append(" ORDER BY sr.report_time ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o (A-Z)": {
                    stringBuilder.append(" ORDER BY u2.full_name ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u1ecb b\u00e1o c\u00e1o (Z-A)": {
                    stringBuilder.append(" ORDER BY u2.full_name DESC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u00e1o c\u00e1o (A-Z)": {
                    stringBuilder.append(" ORDER BY u1.full_name ASC");
                    break;
                }
                case "S\u1eafp x\u1ebfp theo ng\u01b0\u1eddi b\u00e1o c\u00e1o (Z-A)": {
                    stringBuilder.append(" ORDER BY u1.full_name DESC");
                    break;
                }
                default: {
                    stringBuilder.append(" ORDER BY sr.report_time DESC");
                    break;
                }
            }
        } else {
            stringBuilder.append(" ORDER BY sr.report_time DESC");
        }
        object = this.dbConnection.getConnection();
        try (PreparedStatement preparedStatement = object.prepareStatement(stringBuilder.toString());){
            for (n = 0; n < arrayList2.size(); ++n) {
                preparedStatement.setObject(n + 1, arrayList2.get(n));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractSpamReportFromResultSet(resultSet));
                }
            }
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
        return arrayList;
    }

    private SpamReport extractSpamReportFromResultSet(ResultSet resultSet) throws SQLException {
        SpamReport spamReport = new SpamReport();
        spamReport.setId(resultSet.getInt("report_id"));
        spamReport.setReporterId(resultSet.getInt("reporter_id"));
        spamReport.setReporterName(resultSet.getString("reporter_name"));
        spamReport.setReportedUserId(resultSet.getInt("reported_user_id"));
        spamReport.setReportedUserName(resultSet.getString("reported_user_name"));
        spamReport.setReason(resultSet.getString("reason"));
        spamReport.setStatus(resultSet.getString("status"));
        Timestamp timestamp = resultSet.getTimestamp("report_time");
        if (timestamp != null) {
            spamReport.setCreatedAt(timestamp.toLocalDateTime());
        }
        return spamReport;
    }
}

