/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import admin.service.DatabaseConnection;
import admin.socket.LoginHistory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class LoginHistoryDAO {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();

    public List<LoginHistory> getAllLoginHistory() throws SQLException {
        ArrayList<LoginHistory> arrayList = new ArrayList<LoginHistory>();
        String string = "SELECT lh.*, u.username, u.full_name FROM login_history lh JOIN users u ON lh.user_id = u.user_id ORDER BY lh.login_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            while (resultSet.next()) {
                arrayList.add(this.extractLoginHistoryFromResultSet(resultSet));
            }
        }
        return arrayList;
    }

    public List<LoginHistory> getLoginHistoryByUserId(int n) throws SQLException {
        ArrayList<LoginHistory> arrayList = new ArrayList<LoginHistory>();
        String string = "SELECT lh.*, u.username, u.full_name FROM login_history lh JOIN users u ON lh.user_id = u.user_id WHERE lh.user_id = ? ORDER BY lh.login_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractLoginHistoryFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public List<LoginHistory> getLoginHistoryByDateRange(LocalDateTime localDateTime, LocalDateTime localDateTime2) throws SQLException {
        ArrayList<LoginHistory> arrayList = new ArrayList<LoginHistory>();
        String string = "SELECT lh.*, u.username, u.full_name FROM login_history lh JOIN users u ON lh.user_id = u.user_id WHERE lh.login_time BETWEEN ? AND ? ORDER BY lh.login_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setTimestamp(1, Timestamp.valueOf(localDateTime));
            preparedStatement.setTimestamp(2, Timestamp.valueOf(localDateTime2));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractLoginHistoryFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public List<LoginHistory> searchLoginHistory(String string) throws SQLException {
        ArrayList<LoginHistory> arrayList = new ArrayList<LoginHistory>();
        String string2 = "SELECT lh.*, u.username, u.full_name FROM login_history lh JOIN users u ON lh.user_id = u.user_id WHERE u.username LIKE ? OR u.full_name LIKE ? ORDER BY lh.login_time DESC";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            String string3 = "%" + string + "%";
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string3);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(this.extractLoginHistoryFromResultSet(resultSet));
                }
            }
        }
        return arrayList;
    }

    public boolean addLoginHistory(LoginHistory loginHistory) throws SQLException {
        String string = "INSERT INTO login_history (user_id, login_time, ip_address, device_info) VALUES (?, ?, ?, ?)";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setInt(1, loginHistory.getUserId());
                    preparedStatement.setTimestamp(2, Timestamp.valueOf(loginHistory.getLoginTime()));
                    preparedStatement.setString(3, loginHistory.getIpAddress());
                    preparedStatement.setString(4, loginHistory.getUserAgent());
                    boolean bl2 = bl = preparedStatement.executeUpdate() > 0;
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
    }

    public int getTotalLoginCount() throws SQLException {
        String string = "SELECT COUNT(*) FROM login_history";
        try (Connection connection = this.dbConnection.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
        }
        return 0;
    }

    public int getLoginCountByUserId(int n) throws SQLException {
        String string = "SELECT COUNT(*) FROM login_history WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n2 = resultSet.getInt(1);
                    return n2;
                }
            }
        }
        return 0;
    }

    private LoginHistory extractLoginHistoryFromResultSet(ResultSet resultSet) throws SQLException {
        LoginHistory loginHistory = new LoginHistory();
        loginHistory.setId(resultSet.getInt("history_id"));
        loginHistory.setUserId(resultSet.getInt("user_id"));
        loginHistory.setUsername(resultSet.getString("username"));
        loginHistory.setFullName(resultSet.getString("full_name"));
        Timestamp timestamp = resultSet.getTimestamp("login_time");
        if (timestamp != null) {
            loginHistory.setLoginTime(timestamp.toLocalDateTime());
        }
        loginHistory.setIpAddress(resultSet.getString("ip_address"));
        loginHistory.setUserAgent(resultSet.getString("device_info"));
        return loginHistory;
    }
}

