/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.StatisticsDAO;
import admin.socket.UserActivity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class ActiveUserReportPanel
extends JPanel {
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color NEUTRAL_GRAY = new Color(108, 117, 125);
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private JTable reportTable;
    private DefaultTableModel tableModel;
    private JTextField dateFromField;
    private JTextField dateToField;
    private JTextField searchNameField;
    private JComboBox<String> sortCombo;
    private JComboBox<String> comparisonCombo;
    private JTextField activityCountField;
    private JButton filterButton;
    private JButton resetButton;
    private JButton refreshButton;
    private JButton exportButton;
    private JLabel totalLabel;
    private StatisticsDAO statisticsDAO;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public ActiveUserReportPanel() {
        this.statisticsDAO = new StatisticsDAO();
        this.initializeComponents();
        this.setupLayout();
        this.setupEventHandlers();
        this.dateFromField.setText("");
        this.dateToField.setText("");
        this.loadDefaultData();
    }

    private void loadDefaultData() {
        try {
            List<UserActivity> list = this.statisticsDAO.getUserActivitiesComprehensive(null, null, null, null, null, null);
            this.displayActiveUsers(list);
            this.updateStatistics();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void initializeComponents() {
        Object[] objectArray = new String[]{"ID", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "M\u1edf \u1ee9ng d\u1ee5ng", "S\u1ed1 l\u01b0\u1ee3ng ng\u01b0\u1eddi chat", "S\u1ed1 l\u01b0\u1ee3ng nh\u00f3m chat", "Ng\u00e0y t\u1ea1o"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.reportTable = new JTable(this.tableModel);
        this.reportTable.setRowHeight(28);
        this.reportTable.setSelectionMode(0);
        this.reportTable.setAutoCreateRowSorter(true);
        this.reportTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.reportTable.getTableHeader().setBackground(Color.WHITE);
        this.reportTable.getTableHeader().setForeground(Color.BLACK);
        TableColumnModel tableColumnModel = this.reportTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(120);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(130);
        tableColumnModel.getColumn(4).setPreferredWidth(150);
        tableColumnModel.getColumn(5).setPreferredWidth(170);
        tableColumnModel.getColumn(6).setPreferredWidth(120);
        this.dateFromField = new JTextField(10);
        this.dateFromField.setToolTipText("\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD");
        this.dateToField = new JTextField(10);
        this.dateToField.setToolTipText("\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD");
        this.searchNameField = new JTextField(20);
        this.sortCombo = new JComboBox<String>(new String[]{"S\u1eafp x\u1ebfp theo t\u00ean (A-Z)", "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)", "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (M\u1edbi nh\u1ea5t)", "S\u1eafp x\u1ebfp theo th\u1eddi gian t\u1ea1o (C\u0169 nh\u1ea5t)"});
        this.comparisonCombo = new JComboBox<String>(new String[]{"T\u1ea5t c\u1ea3", "=", ">", "<"});
        this.activityCountField = new JTextField(5);
        this.filterButton = this.createButtonWithIcon("T\u00ecm ki\u1ebfm v\u00e0 l\u1ecdc", "search");
        this.resetButton = this.createButtonWithIcon("\u0110\u1eb7t l\u1ea1i", "reset");
        this.refreshButton = this.createButtonWithIcon("L\u00e0m m\u1edbi", "refresh");
        this.exportButton = this.createButtonWithIcon("Xu\u1ea5t CSV", "export");
        this.stylePrimaryButton(this.filterButton);
        this.stylePrimaryButton(this.resetButton);
        this.styleAddUserButtonSimple(this.refreshButton);
        this.styleAddUserButtonSimple(this.exportButton);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createFilterPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createTablePanel();
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.createButtonPanel();
        this.add((Component)jPanel3, "South");
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("calendar", 20, 20);
        JLabel jLabel = new JLabel("T\u00f9y ch\u1ecdn b\u00e1o c\u00e1o ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("T\u1eeb ng\u00e0y:"));
        this.dateFromField.setPreferredSize(new Dimension(120, 30));
        jPanel2.add(this.dateFromField);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JLabel("\u0110\u1ebfn ng\u00e0y:"));
        this.dateToField.setPreferredSize(new Dimension(120, 30));
        jPanel2.add(this.dateToField);
        JLabel jLabel2 = new JLabel("(\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD)");
        jLabel2.setFont(new Font("Arial", 2, 11));
        jLabel2.setForeground(NEUTRAL_GRAY);
        jPanel2.add(jLabel2);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel3.setOpaque(false);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(new JLabel("L\u1ecdc theo t\u00ean:"));
        this.searchNameField.setPreferredSize(new Dimension(200, 30));
        jPanel3.add(this.searchNameField);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel4.setOpaque(false);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(new JLabel("S\u1ed1 l\u01b0\u1ee3ng ho\u1ea1t \u0111\u1ed9ng:"));
        this.comparisonCombo.setPreferredSize(new Dimension(80, 30));
        jPanel4.add(this.comparisonCombo);
        this.activityCountField.setPreferredSize(new Dimension(80, 30));
        jPanel4.add(this.activityCountField);
        jPanel4.add(Box.createHorizontalStrut(20));
        jPanel4.add(new JLabel("S\u1eafp x\u1ebfp:"));
        this.sortCombo.setPreferredSize(new Dimension(260, 30));
        jPanel4.add(this.sortCombo);
        jPanel.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel5.setOpaque(false);
        jPanel5.setAlignmentX(0.0f);
        jPanel5.add(this.filterButton);
        jPanel5.add(this.resetButton);
        jPanel.add(jPanel5);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("activity", 20, 20);
        JLabel jLabel = new JLabel("Danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel("T\u1ed5ng s\u1ed1: 0");
        }
        this.totalLabel.setFont(new Font("Arial", 1, 12));
        jPanel3.add(this.totalLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.reportTable), "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        jPanel.setOpaque(false);
        jPanel.add(this.refreshButton);
        jPanel.add(this.exportButton);
        return jPanel;
    }

    private void setupEventHandlers() {
        this.filterButton.addActionListener(actionEvent -> this.handleFilterReport());
        this.resetButton.addActionListener(actionEvent -> this.handleReset());
        this.refreshButton.addActionListener(actionEvent -> this.handleRefresh());
        this.exportButton.addActionListener(actionEvent -> this.handleExport());
    }

    private void handleFilterReport() {
        boolean bl;
        String string = this.dateFromField.getText().trim();
        String string2 = this.dateToField.getText().trim();
        boolean bl2 = bl = string.isEmpty() && string2.isEmpty();
        if (!bl) {
            if (string.isEmpty() || string2.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp \u0111\u1ea7y \u0111\u1ee7 kho\u1ea3ng th\u1eddi gian!\n\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD\nV\u00ed d\u1ee5: 2024-01-01\n\nHo\u1eb7c \u0111\u1ec3 tr\u1ed1ng c\u1ea3 2 \u0111\u1ec3 xem t\u1ea5t c\u1ea3", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            if (!this.isValidDateFormat(string) || !this.isValidDateFormat(string2)) {
                JOptionPane.showMessageDialog(this, "\u0110\u1ecbnh d\u1ea1ng ng\u00e0y kh\u00f4ng h\u1ee3p l\u1ec7!\nVui l\u00f2ng nh\u1eadp theo \u0111\u1ecbnh d\u1ea1ng: YYYY-MM-DD\nV\u00ed d\u1ee5: 2024-01-01", "L\u1ed7i", 0);
                return;
            }
        }
        String string3 = (String)this.comparisonCombo.getSelectedItem();
        String string4 = this.activityCountField.getText().trim();
        Integer n = null;
        if (!"T\u1ea5t c\u1ea3".equals(string3)) {
            if (string4.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp s\u1ed1 l\u01b0\u1ee3ng ho\u1ea1t \u0111\u1ed9ng \u0111\u1ec3 so s\u00e1nh!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            try {
                n = Integer.parseInt(string4);
                if (n < 0) {
                    JOptionPane.showMessageDialog(this, "S\u1ed1 l\u01b0\u1ee3ng ho\u1ea1t \u0111\u1ed9ng ph\u1ea3i >= 0!", "L\u1ed7i", 0);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "S\u1ed1 l\u01b0\u1ee3ng ho\u1ea1t \u0111\u1ed9ng kh\u00f4ng h\u1ee3p l\u1ec7!", "L\u1ed7i", 0);
                return;
            }
        }
        try {
            LocalDate localDate = null;
            LocalDate localDate2 = null;
            if (!bl) {
                localDate = LocalDate.parse(string, this.inputFormatter);
                localDate2 = LocalDate.parse(string2, this.inputFormatter);
            }
            String string5 = this.searchNameField.getText().trim();
            String string6 = (String)this.sortCombo.getSelectedItem();
            List<UserActivity> list = this.statisticsDAO.getUserActivitiesComprehensive(localDate, localDate2, string5.isEmpty() ? null : string5, string3, n, string6);
            this.displayActiveUsers(list);
            this.updateStatistics();
            String string7 = bl ? "T\u00ecm th\u1ea5y " + list.size() + " ng\u01b0\u1eddi d\u00f9ng (t\u1ea5t c\u1ea3 c\u00e1c n\u0103m)" : "T\u00ecm th\u1ea5y " + list.size() + " ng\u01b0\u1eddi d\u00f9ng\nT\u1eeb: " + string + " \u0111\u1ebfn: " + string2;
            JOptionPane.showMessageDialog(this, string7, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (DateTimeParseException dateTimeParseException) {
            this.showError("L\u1ed7i \u0111\u1ecbnh d\u1ea1ng ng\u00e0y: " + dateTimeParseException.getMessage());
        }
        catch (SQLException sQLException) {
            String string8 = sQLException.getMessage();
            String string9 = "L\u1ed7i load d\u1eef li\u1ec7u ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng: " + string8;
            if (string8 != null && (string8.contains("connection") || string8.contains("Connection"))) {
                string9 = string9 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Kho\u1ea3ng th\u1eddi gian \u0111\u00e3 ch\u1ecdn\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string9);
            sQLException.printStackTrace();
        }
    }

    private void displayActiveUsers(List<UserActivity> list) {
        this.tableModel.setRowCount(0);
        for (UserActivity userActivity : list) {
            Object[] objectArray = new Object[]{userActivity.getUserId(), userActivity.getUsername(), userActivity.getFullName(), userActivity.getLoginCount(), userActivity.getPrivateChatCount(), userActivity.getGroupChatCount(), userActivity.getCreatedAt() != null ? this.dateFormatter.format(userActivity.getCreatedAt()) : ""};
            this.tableModel.addRow(objectArray);
        }
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void loadFilteredData(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.handleFilterReport();
    }

    private void updateStatistics() {
        int n = this.reportTable.getRowCount();
        if (this.totalLabel != null) {
            this.totalLabel.setText("\ud83d\udcc8 T\u1ed5ng s\u1ed1: " + n);
        }
    }

    private boolean isValidDateFormat(String string) {
        if (string == null || string.length() != 10) {
            return false;
        }
        return string.matches("\\d{4}-\\d{2}-\\d{2}");
    }

    private void handleReset() {
        this.dateFromField.setText("");
        this.dateToField.setText("");
        this.searchNameField.setText("");
        this.comparisonCombo.setSelectedIndex(0);
        this.activityCountField.setText("");
        this.sortCombo.setSelectedIndex(0);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.reportTable.getModel();
        defaultTableModel.setRowCount(0);
        this.updateStatistics();
        JOptionPane.showMessageDialog(this, "\u0110\u00e3 \u0111\u1eb7t l\u1ea1i t\u1ea5t c\u1ea3 b\u1ed9 l\u1ecdc!", "Th\u00f4ng b\u00e1o", 1);
    }

    private void handleRefresh() {
        String string = this.dateFromField.getText().trim();
        String string2 = this.dateToField.getText().trim();
        if (!string.isEmpty() && !string2.isEmpty()) {
            this.handleFilterReport();
        } else {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn kho\u1ea3ng th\u1eddi gian tr\u01b0\u1edbc khi l\u00e0m m\u1edbi!", "C\u1ea3nh b\u00e1o", 2);
        }
    }

    private void handleExport() {
        if (this.reportTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("NguoiDungHoatDong.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,T\u00ean \u0111\u0103ng nh\u1eadp,H\u1ecd t\u00ean,M\u1edf \u1ee9ng d\u1ee5ng,S\u1ed1 l\u01b0\u1ee3ng ng\u01b0\u1eddi chat,S\u1ed1 l\u01b0\u1ee3ng nh\u00f3m chat,Ng\u00e0y t\u1ea1o");
                for (int i = 0; i < this.reportTable.getRowCount(); ++i) {
                    String string = String.format("%s,\"%s\",\"%s\",%s,%s,%s,\"%s\"", this.reportTable.getValueAt(i, 0), this.escapeCsv(this.reportTable.getValueAt(i, 1)), this.escapeCsv(this.reportTable.getValueAt(i, 2)), this.reportTable.getValueAt(i, 3), this.reportTable.getValueAt(i, 4), this.reportTable.getValueAt(i, 5), this.escapeCsv(this.reportTable.getValueAt(i, 6)));
                    printWriter.println(string);
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + this.reportTable.getRowCount() + " ng\u01b0\u1eddi d\u00f9ng v\u00e0o file:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "L\u1ed7i xu\u1ea5t file: " + exception.getMessage(), "L\u1ed7i", 0);
            exception.printStackTrace();
        }
    }

    private String escapeCsv(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        return string.replace("\"", "\"\"");
    }

    private void stylePrimaryButton(JButton jButton) {
        jButton.setBackground(ZALO_BLUE);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleNeutralButton(JButton jButton) {
        jButton.setBackground(NEUTRAL_GRAY);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleAddUserButtonSimple(JButton jButton) {
        Color color = new Color(32, 178, 170);
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 14));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(10, 20, 10, 20));
        jButton.setCursor(new Cursor(12));
    }

    private Component[] getAllComponents(Container container) {
        Component[] componentArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray = container.getComponents()) {
            Component[] componentArray2;
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            for (Component component2 : componentArray2 = this.getAllComponents((Container)component)) {
                arrayList.add(component2);
            }
        }
        return arrayList.toArray(new Component[0]);
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JButton createButtonWithIcon(String string, String string2) {
        JButton jButton = new JButton(string);
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        }
        jButton.setPreferredSize(new Dimension(200, 35));
        return jButton;
    }
}

