/*
 * Decompiled with CFR 0.152.
 */
package user.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import user.service.GroupService;
import user.socket.ChatServer;
import user.socket.Message;

public class ClientHandler
implements Runnable {
    private Socket socket;
    private ChatServer server;
    private String username;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    private volatile boolean running = false;

    public ClientHandler(Socket socket, ChatServer chatServer) {
        this.socket = socket;
        this.server = chatServer;
    }

    @Override
    public void run() {
        try {
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.socket.getInputStream());
            this.running = true;
            while (this.running) {
                try {
                    Message message = (Message)this.in.readObject();
                    this.handleMessage(message);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("\u274c Invalid message format");
                    break;
                }
            }
        }
        catch (EOFException eOFException) {
            System.out.println("\ud83d\udce4 Client disconnected: " + String.valueOf(this.username != null ? this.username : this.socket.getInetAddress()));
        }
        catch (IOException iOException) {
            if (this.running) {
                System.err.println("\u274c Error handling client: " + iOException.getMessage());
            }
        }
        finally {
            this.close();
        }
    }

    private void handleMessage(Message message) {
        System.out.println("\ud83d\udce8 Received: " + String.valueOf(message));
        switch (message.getType()) {
            case LOGIN: {
                this.handleLogin(message);
                break;
            }
            case LOGOUT: {
                this.handleLogout();
                break;
            }
            case CHAT: {
                this.handleChat(message);
                break;
            }
            case PRIVATE_MESSAGE: {
                this.handlePrivateMessage(message);
                break;
            }
            case TYPING: {
                this.handleTyping(message);
                break;
            }
            case FRIEND_REQUEST_SENT: 
            case FRIEND_REQUEST_ACCEPTED: 
            case FRIEND_REQUEST_REJECTED: 
            case FRIEND_REQUEST_RECALLED: {
                this.handleFriendRequestNotification(message);
                break;
            }
            case UNFRIEND: 
            case BLOCK: {
                this.handleFriendManagementNotification(message);
                break;
            }
            case GROUP_MESSAGE: {
                this.handleGroupMessage(message);
                break;
            }
            case GROUP_CREATED: {
                this.handleGroupCreated(message);
                break;
            }
            default: {
                System.err.println("\u26a0\ufe0f  Unknown message type: " + String.valueOf((Object)message.getType()));
            }
        }
    }

    private void handleLogin(Message message) {
        this.username = message.getSender();
        this.server.addClient(this.username, this);
        Message message2 = new Message(Message.MessageType.SUCCESS);
        message2.setContent("Login successful. Welcome " + this.username + "!");
        this.sendMessage(message2);
    }

    private void handleLogout() {
        this.running = false;
        this.close();
    }

    private void handleChat(Message message) {
        message.setSender(this.username);
        message.setType(Message.MessageType.BROADCAST);
        this.server.broadcast(message, this.username);
    }

    private void handlePrivateMessage(Message message) {
        message.setSender(this.username);
        String string = message.getReceiver();
        boolean bl = this.server.sendToUser(string, message);
        if (!bl) {
            Message message2 = new Message(Message.MessageType.ERROR);
            message2.setContent("User " + string + " is not online.");
            this.sendMessage(message2);
        }
    }

    private void handleTyping(Message message) {
        message.setSender(this.username);
        if (message.getReceiver() != null) {
            this.server.sendToUser(message.getReceiver(), message);
        } else {
            this.server.broadcast(message, this.username);
        }
    }

    private void handleFriendRequestNotification(Message message) {
        message.setSender(this.username);
        String string = message.getReceiver();
        if (string != null) {
            boolean bl = this.server.sendToUser(string, message);
            if (bl) {
                System.out.println("\u2705 Sent " + String.valueOf((Object)message.getType()) + " notification: " + this.username + " \u2192 " + string);
            } else {
                System.out.println("\u26a0\ufe0f  User " + string + " is offline. Notification not sent.");
            }
        }
    }

    private void handleFriendManagementNotification(Message message) {
        message.setSender(this.username);
        String string = message.getReceiver();
        if (string != null) {
            boolean bl = this.server.sendToUser(string, message);
            if (bl) {
                System.out.println("\u2705 Sent " + String.valueOf((Object)message.getType()) + " notification: " + this.username + " \u2192 " + string);
            } else {
                System.out.println("\u26a0\ufe0f  User " + string + " is offline. Notification not sent.");
            }
        }
    }

    private void handleGroupMessage(Message message) {
        message.setSender(this.username);
        int n = (Integer)message.getData();
        System.out.println("\ud83d\udce8 Group message from " + this.username + " to group " + n);
        try {
            GroupService groupService = new GroupService();
            List<Map<String, Object>> list = groupService.getGroupMembers(n);
            for (Map<String, Object> map : list) {
                boolean bl;
                String string = (String)map.get("username");
                if (string == null || string.equals(this.username) || !(bl = this.server.sendToUser(string, message))) continue;
                System.out.println("\u2705 Group message sent to: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("\u274c Error broadcasting group message: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void handleGroupCreated(Message message) {
        message.setSender(this.username);
        try {
            Map map = (Map)message.getData();
            int n = (Integer)map.get("groupId");
            List list = (List)map.get("members");
            System.out.println("\ud83d\udce8 Group created notification from " + this.username + " for group " + n);
            for (String string : list) {
                boolean bl;
                if (string.equals(this.username) || !(bl = this.server.sendToUser(string, message))) continue;
                System.out.println("\u2705 Group created notification sent to: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("\u274c Error handling group created: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void sendMessage(Message message) {
        try {
            if (this.out != null) {
                this.out.writeObject(message);
                this.out.flush();
                System.out.println("\ud83d\udce4 Sent to " + this.username + ": " + String.valueOf((Object)message.getType()));
            }
        }
        catch (IOException iOException) {
            System.err.println("\u274c Error sending message to " + this.username + ": " + iOException.getMessage());
            this.close();
        }
    }

    public void close() {
        this.running = false;
        if (this.username != null) {
            this.server.removeClient(this.username);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("\u274c Error closing resources: " + iOException.getMessage());
        }
    }

    public String getUsername() {
        return this.username;
    }
}

