/*
 * Decompiled with CFR 0.152.
 */
package user.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import user.socket.ClientHandler;
import user.socket.Message;

public class ChatServer {
    private static final int PORT = 8888;
    private static final int MAX_CLIENTS = 100;
    private static final ConcurrentHashMap<String, ClientHandler> clients = new ConcurrentHashMap();
    private static ExecutorService threadPool;
    private ServerSocket serverSocket;
    private volatile boolean running = false;

    public ChatServer() {
        threadPool = Executors.newFixedThreadPool(100);
    }

    public void start() {
        try {
            this.serverSocket = new ServerSocket(8888);
            this.running = true;
            System.out.println("=================================");
            System.out.println("  CHAT SERVER STARTED");
            System.out.println("  Port: 8888");
            System.out.println("  Waiting for clients...");
            System.out.println("=================================\n");
            while (this.running) {
                try {
                    Socket socket = this.serverSocket.accept();
                    System.out.println("\ud83d\udce5 New connection from: " + String.valueOf(socket.getInetAddress()));
                    ClientHandler clientHandler = new ClientHandler(socket, this);
                    threadPool.execute(clientHandler);
                }
                catch (IOException iOException) {
                    if (!this.running) continue;
                    System.err.println("\u274c Error accepting client: " + iOException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("\u274c Could not start server on port 8888");
            iOException.printStackTrace();
        }
        finally {
            this.stop();
        }
    }

    public void stop() {
        this.running = false;
        try {
            for (ClientHandler clientHandler : clients.values()) {
                clientHandler.close();
            }
            clients.clear();
            threadPool.shutdown();
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            System.out.println("\n\ud83d\uded1 Server stopped.");
        }
        catch (IOException iOException) {
            System.err.println("\u274c Error stopping server: " + iOException.getMessage());
        }
    }

    public void addClient(String string, ClientHandler clientHandler) {
        clients.put(string, clientHandler);
        System.out.println("\u2705 " + string + " joined. Total clients: " + clients.size());
        Message message = new Message(Message.MessageType.USER_JOINED, string, string + " joined the chat!");
        this.broadcast(message, null);
        this.sendOnlineUsers();
    }

    public void removeClient(String string) {
        ClientHandler clientHandler = clients.remove(string);
        if (clientHandler != null) {
            System.out.println("\ud83d\udc4b " + string + " left. Total clients: " + clients.size());
            Message message = new Message(Message.MessageType.USER_LEFT, string, string + " left the chat.");
            this.broadcast(message, null);
            this.sendOnlineUsers();
        }
    }

    public void broadcast(Message message, String string) {
        for (Map.Entry<String, ClientHandler> entry : clients.entrySet()) {
            String string2 = entry.getKey();
            ClientHandler clientHandler = entry.getValue();
            if (string != null && string2.equals(string)) continue;
            clientHandler.sendMessage(message);
        }
    }

    public boolean sendToUser(String string, Message message) {
        ClientHandler clientHandler = clients.get(string);
        if (clientHandler != null) {
            clientHandler.sendMessage(message);
            return true;
        }
        return false;
    }

    private void sendOnlineUsers() {
        ArrayList arrayList = new ArrayList(clients.keySet());
        Message message = new Message(Message.MessageType.ONLINE_USERS);
        message.setData(arrayList);
        this.broadcast(message, null);
    }

    public List<String> getOnlineUsers() {
        return new ArrayList<String>(clients.keySet());
    }

    public static void main(String[] stringArray) {
        ChatServer chatServer = new ChatServer();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("\n\ud83d\udd04 Shutting down server...");
            chatServer.stop();
        }));
        chatServer.start();
    }
}

