/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import user.service.DatabaseConnection;
import user.service.EncryptionService;

public class GroupService {
    private DatabaseConnection dbConnection = DatabaseConnection.getInstance();
    private EncryptionService encryptionService = EncryptionService.getInstance();

    public int createGroup(String string, String string2, String string3, List<String> list) {
        return this.createGroup(string, string2, string3, list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createGroup(String string, String string2, String string3, List<String> list, boolean bl) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                int n = -1;
                return n;
            }
            connection.setAutoCommit(false);
            int n = this.getUserId(connection, string3);
            if (n == -1) {
                connection.rollback();
                int n2 = -1;
                return n2;
            }
            String string4 = null;
            if (bl) {
                string4 = this.encryptionService.generateGroupKey(-1);
            }
            String string5 = "INSERT INTO groups (group_name, admin_id, is_encrypted, encryption_key, created_at) VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP) RETURNING group_id";
            statement = connection.prepareStatement(string5);
            statement.setString(1, string);
            statement.setInt(2, n);
            statement.setBoolean(3, bl);
            statement.setString(4, string4);
            resultSet = statement.executeQuery();
            int n3 = -1;
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            if (n3 == -1) {
                connection.rollback();
                int n4 = -1;
                return n4;
            }
            if (bl && string4 != null) {
                this.encryptionService.loadGroupKey(n3, string4);
            }
            String string6 = "INSERT INTO group_members (group_id, user_id, joined_at) VALUES (?, ?, CURRENT_TIMESTAMP)";
            try (Object object = connection.prepareStatement(string6);){
                object.setInt(1, n3);
                object.setInt(2, n);
                object.executeUpdate();
            }
            if (list != null && !list.isEmpty()) {
                object = "INSERT INTO group_members (group_id, user_id, joined_at) VALUES (?, (SELECT user_id FROM users WHERE username = ?), CURRENT_TIMESTAMP)";
                try (PreparedStatement preparedStatement = connection.prepareStatement((String)object);){
                    for (String string7 : list) {
                        if (string7.equals(string3)) continue;
                        preparedStatement.setInt(1, n3);
                        preparedStatement.setString(2, string7);
                        preparedStatement.addBatch();
                    }
                    preparedStatement.executeBatch();
                }
            }
            connection.commit();
            object = bl ? " [\ud83d\udd12 E2E]" : "";
            System.out.println("\u2705 \u0110\u00e3 t\u1ea1o nh\u00f3m: " + string + (String)object + " (ID: " + n3 + ")");
            int n5 = n3;
            return n5;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u1ea1o nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            int n = -1;
            return n;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
                DatabaseConnection.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameGroup(int n, String string, String string2) {
        if (!this.isAdmin(n, string2)) {
            System.err.println("\u274c Ch\u1ec9 admin m\u1edbi \u0111\u01b0\u1ee3c \u0111\u1ed5i t\u00ean nh\u00f3m");
            return false;
        }
        String string3 = "UPDATE groups SET group_name = ? WHERE group_id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setInt(2, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 \u0111\u1ed5i t\u00ean nh\u00f3m: " + string);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi \u0111\u1ed5i t\u00ean nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(int n, String string, String string2) {
        if (!this.isMember(n, string2)) {
            System.err.println("\u274c B\u1ea1n kh\u00f4ng ph\u1ea3i th\u00e0nh vi\u00ean c\u1ee7a nh\u00f3m n\u00e0y");
            return false;
        }
        String string3 = "INSERT INTO group_members (group_id, user_id, joined_at) VALUES (?, (SELECT user_id FROM users WHERE username = ?), CURRENT_TIMESTAMP)";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setInt(1, n);
            statement.setString(2, string);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 th\u00eam th\u00e0nh vi\u00ean: " + string);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().contains("duplicate key")) {
                System.err.println("\u274c Th\u00e0nh vi\u00ean \u0111\u00e3 c\u00f3 trong nh\u00f3m");
            } else {
                System.err.println("\u274c L\u1ed7i khi th\u00eam th\u00e0nh vi\u00ean: " + sQLException.getMessage());
                sQLException.printStackTrace();
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promoteToAdmin(int n, String string, String string2) {
        if (!this.isAdmin(n, string2)) {
            System.err.println("\u274c Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n g\u00e1n admin");
            return false;
        }
        if (!this.isMember(n, string)) {
            System.err.println("\u274c Ng\u01b0\u1eddi d\u00f9ng kh\u00f4ng ph\u1ea3i th\u00e0nh vi\u00ean c\u1ee7a nh\u00f3m");
            return false;
        }
        String string3 = "UPDATE groups SET admin_id = (SELECT user_id FROM users WHERE username = ?) WHERE group_id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setString(1, string);
            statement.setInt(2, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 g\u00e1n quy\u1ec1n admin cho: " + string);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi g\u00e1n quy\u1ec1n admin: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(int n, String string, String string2) {
        int n2;
        if (!this.isAdmin(n, string2)) {
            System.err.println("\u274c Ch\u1ec9 admin m\u1edbi c\u00f3 quy\u1ec1n x\u00f3a th\u00e0nh vi\u00ean");
            return false;
        }
        if (string.equals(string2) && (n2 = this.countAdmins(n)) <= 1) {
            System.err.println("\u274c Kh\u00f4ng th\u1ec3 r\u1eddi nh\u00f3m khi l\u00e0 admin duy nh\u1ea5t. H\u00e3y g\u00e1n admin cho ng\u01b0\u1eddi kh\u00e1c tr\u01b0\u1edbc.");
            return false;
        }
        String string3 = "DELETE FROM group_members WHERE group_id = ? AND user_id = (SELECT user_id FROM users WHERE username = ?)";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setInt(1, n);
            statement.setString(2, string);
            int n3 = statement.executeUpdate();
            if (n3 > 0) {
                System.out.println("\u2705 \u0110\u00e3 x\u00f3a th\u00e0nh vi\u00ean: " + string);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi x\u00f3a th\u00e0nh vi\u00ean: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendGroupMessage(int n, String string, String string2) {
        if (!this.isMember(n, string)) {
            System.err.println("\u274c B\u1ea1n kh\u00f4ng ph\u1ea3i th\u00e0nh vi\u00ean c\u1ee7a nh\u00f3m n\u00e0y");
            return false;
        }
        String string3 = "INSERT INTO group_messages (group_id, sender_id, message_text, sent_time) VALUES (?, (SELECT user_id FROM users WHERE username = ?), ?, CURRENT_TIMESTAMP)";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string3);
            statement.setInt(1, n);
            statement.setString(2, string);
            statement.setString(3, string2);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 g\u1eedi tin nh\u1eafn nh\u00f3m");
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi g\u1eedi tin nh\u1eafn nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    public List<Map<String, Object>> getGroupMessages(int n, String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        if (!this.isMember(n, string)) {
            System.err.println("\u274c B\u1ea1n kh\u00f4ng ph\u1ea3i th\u00e0nh vi\u00ean c\u1ee7a nh\u00f3m n\u00e0y");
            return arrayList;
        }
        return this.getGroupMessages(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getGroupMessages(int n) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string = "SELECT gm.message_id, gm.message_text, gm.sent_time, u.username, u.full_name FROM group_messages gm JOIN users u ON gm.sender_id = u.user_id WHERE gm.group_id = ? ORDER BY gm.sent_time ASC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("message_id", resultSet.getInt("message_id"));
                hashMap.put("message", resultSet.getString("message_text"));
                hashMap.put("sent_at", resultSet.getTimestamp("sent_time").toLocalDateTime());
                hashMap.put("sender_username", resultSet.getString("username"));
                hashMap.put("sender_full_name", resultSet.getString("full_name"));
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y tin nh\u1eafn nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getUserGroups(String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT g.group_id, g.group_name, g.created_at, g.admin_id, COALESCE(g.is_encrypted, false) as is_encrypted, g.encryption_key, (SELECT COUNT(*) FROM group_members WHERE group_id = g.group_id) as member_count, u.user_id FROM groups g JOIN group_members gm ON g.group_id = gm.group_id JOIN users u ON gm.user_id = u.user_id WHERE u.username = ? ORDER BY g.created_at DESC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                int n = resultSet.getInt("group_id");
                int n2 = resultSet.getInt("admin_id");
                int n3 = resultSet.getInt("user_id");
                boolean bl = resultSet.getBoolean("is_encrypted");
                String string3 = resultSet.getString("encryption_key");
                boolean bl2 = n2 == n3 || this.isCoAdmin(n, n3);
                hashMap.put("id", n);
                hashMap.put("group_name", resultSet.getString("group_name"));
                hashMap.put("created_at", resultSet.getTimestamp("created_at"));
                hashMap.put("role", bl2 ? "admin" : "member");
                hashMap.put("member_count", resultSet.getInt("member_count"));
                hashMap.put("is_encrypted", bl);
                if (bl && string3 != null && !string3.isEmpty() && !this.encryptionService.hasGroupKey(n)) {
                    this.encryptionService.loadGroupKey(n, string3);
                }
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y danh s\u00e1ch nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getGroupMembers(int n) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string = "SELECT u.user_id, u.username, u.full_name, gm.joined_at, g.admin_id FROM group_members gm JOIN users u ON gm.user_id = u.user_id JOIN groups g ON gm.group_id = g.group_id WHERE gm.group_id = ? ORDER BY gm.joined_at ASC";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int n2;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                int n3 = resultSet.getInt("user_id");
                boolean bl = n3 == (n2 = resultSet.getInt("admin_id")) || this.isCoAdmin(n, n3);
                hashMap.put("user_id", n3);
                hashMap.put("username", resultSet.getString("username"));
                hashMap.put("full_name", resultSet.getString("full_name"));
                hashMap.put("is_admin", bl);
                hashMap.put("role", bl ? "admin" : "member");
                hashMap.put("joined_at", resultSet.getTimestamp("joined_at"));
                arrayList.add(hashMap);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y danh s\u00e1ch th\u00e0nh vi\u00ean: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getGroupInfo(int n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = "SELECT g.group_id, g.group_name, g.admin_id, g.created_at, u.username as created_by, u.full_name as creator_name, (SELECT COUNT(*) FROM group_members WHERE group_id = g.group_id) as member_count FROM groups g JOIN users u ON g.admin_id = u.user_id WHERE g.group_id = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                hashMap.put("group_id", resultSet.getInt("group_id"));
                hashMap.put("group_name", resultSet.getString("group_name"));
                hashMap.put("created_by", resultSet.getString("created_by"));
                hashMap.put("creator_name", resultSet.getString("creator_name"));
                hashMap.put("created_at", resultSet.getTimestamp("created_at"));
                hashMap.put("member_count", resultSet.getInt("member_count"));
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y th\u00f4ng tin nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdmin(int n, String string) {
        String string2 = "SELECT g.admin_id, u.user_id FROM groups g, users u WHERE g.group_id = ? AND u.username = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            statement.setString(2, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int n2;
                int n3 = resultSet.getInt("admin_id");
                if (n3 == (n2 = resultSet.getInt("user_id"))) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this.isCoAdmin(n, n2);
                return bl;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoAdmin(int n, int n2) {
        String string = "SELECT is_admin FROM group_members WHERE group_id = ? AND user_id = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            statement.setInt(2, n2);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getBoolean("is_admin");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getMessage().contains("is_admin")) {
                sQLException.printStackTrace();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(int n, String string) {
        String string2 = "SELECT COUNT(*) FROM group_members WHERE group_id = ? AND user_id = (SELECT user_id FROM users WHERE username = ?)";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            statement.setString(2, string);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAdmins(int n) {
        int n2 = 1;
        String string = "SELECT COUNT(*) as co_admin_count FROM group_members WHERE group_id = ? AND is_admin = true";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                int n3 = n2;
                return n3;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                n2 += resultSet.getInt("co_admin_count");
            }
        }
        catch (SQLException sQLException) {
            if (!sQLException.getMessage().contains("is_admin")) {
                sQLException.printStackTrace();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return n2;
    }

    private int getUserId(Connection connection, String string) throws SQLException {
        String string2 = "SELECT user_id FROM users WHERE username = ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt("user_id");
                    return n;
                }
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUsernameById(int n) {
        String string = "SELECT username FROM users WHERE user_id = ?";
        try (Connection connection = this.dbConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                String string2 = resultSet.getString("username");
                return string2;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi l\u1ea5y username: " + sQLException.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateGroupName(int n, String string) {
        String string2 = "UPDATE groups SET group_name = ? WHERE group_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setString(1, string);
                    preparedStatement.setInt(2, n);
                    int n2 = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 \u0111\u1ed5i t\u00ean nh\u00f3m " + n + " th\u00e0nh: " + string);
                    boolean bl2 = bl = n2 > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi \u0111\u1ed5i t\u00ean nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
            return false;
        }
    }

    public boolean addMemberToGroup(int n, String string) {
        boolean bl;
        block10: {
            Connection connection = null;
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                return false;
            }
            int n2 = this.getUserId(connection, string);
            if (n2 == -1) {
                return false;
            }
            String string2 = "INSERT INTO group_members (group_id, user_id, is_admin, joined_at) VALUES (?, ?, false, CURRENT_TIMESTAMP)";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            try {
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                int n3 = preparedStatement.executeUpdate();
                System.out.println("\u2705 \u0110\u00e3 th\u00eam " + string + " v\u00e0o nh\u00f3m " + n);
                boolean bl2 = bl = n3 > 0;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    System.err.println("\u274c L\u1ed7i khi th\u00eam th\u00e0nh vi\u00ean: " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    public boolean setGroupAdmin(int n, String string, boolean bl) {
        boolean bl2;
        block10: {
            Connection connection = null;
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                return false;
            }
            int n2 = this.getUserId(connection, string);
            if (n2 == -1) {
                return false;
            }
            String string2 = "UPDATE group_members SET is_admin = ? WHERE group_id = ? AND user_id = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            try {
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setInt(2, n);
                preparedStatement.setInt(3, n2);
                int n3 = preparedStatement.executeUpdate();
                System.out.println("\u2705 \u0110\u00e3 " + (bl ? "g\u00e1n" : "b\u1ecf") + " quy\u1ec1n admin cho " + string);
                boolean bl3 = bl2 = n3 > 0;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    System.err.println("\u274c L\u1ed7i khi c\u1eadp nh\u1eadt quy\u1ec1n admin: " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl2;
    }

    public boolean removeMemberFromGroup(int n, String string) {
        boolean bl;
        block10: {
            Connection connection = null;
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                return false;
            }
            int n2 = this.getUserId(connection, string);
            if (n2 == -1) {
                return false;
            }
            String string2 = "DELETE FROM group_members WHERE group_id = ? AND user_id = ?";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            try {
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                int n3 = preparedStatement.executeUpdate();
                System.out.println("\u2705 \u0110\u00e3 x\u00f3a " + string + " kh\u1ecfi nh\u00f3m " + n);
                boolean bl2 = bl = n3 > 0;
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    System.err.println("\u274c L\u1ed7i khi x\u00f3a th\u00e0nh vi\u00ean: " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean toggleGroupEncryption(int n) {
        boolean bl = this.isGroupEncrypted(n);
        String string = "UPDATE groups SET is_encrypted = ? WHERE group_id = ?";
        try (Connection connection = this.dbConnection.getConnection();){
            boolean bl2;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                try {
                    preparedStatement.setBoolean(1, !bl);
                    preparedStatement.setInt(2, n);
                    int n2 = preparedStatement.executeUpdate();
                    System.out.println("\u2705 \u0110\u00e3 " + (!bl ? "b\u1eadt" : "t\u1eaft") + " m\u00e3 h\u00f3a cho nh\u00f3m " + n);
                    boolean bl3 = bl2 = n2 > 0;
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl2;
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi toggle encryption: " + sQLException.getMessage());
            System.err.println("\ud83d\udca1 B\u1ea1n c\u1ea7n th\u00eam c\u1ed9t 'encrypted BOOLEAN DEFAULT FALSE' v\u00e0o b\u1ea3ng groups");
            sQLException.printStackTrace();
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean deleteGroup(int var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> searchGroupMessages(int n, String string) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = "SELECT gm.message_id, gm.message_text, gm.sent_time, u.username, u.full_name FROM group_messages gm JOIN users u ON gm.sender_id = u.user_id WHERE gm.group_id = ? AND LOWER(gm.message_text) LIKE LOWER(?) ORDER BY gm.sent_time DESC LIMIT 100";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                ArrayList<Map<String, Object>> arrayList2 = arrayList;
                return arrayList2;
            }
            statement = connection.prepareStatement(string2);
            statement.setInt(1, n);
            statement.setString(2, "%" + string + "%");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("message_id", resultSet.getInt("message_id"));
                hashMap.put("message", resultSet.getString("message_text"));
                hashMap.put("sent_at", resultSet.getTimestamp("sent_time").toLocalDateTime());
                hashMap.put("sender_username", resultSet.getString("username"));
                hashMap.put("sender_full_name", resultSet.getString("full_name"));
                arrayList.add(hashMap);
            }
            System.out.println("\ud83d\udd0d T\u00ecm th\u1ea5y " + arrayList.size() + " tin nh\u1eafn trong nh\u00f3m");
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi t\u00ecm ki\u1ebfm tin nh\u1eafn nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGroupEncrypted(int n) {
        String string = "SELECT COALESCE(is_encrypted, false) as is_encrypted FROM groups WHERE group_id = ?";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getBoolean("is_encrypted");
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i ki\u1ec3m tra m\u00e3 h\u00f3a nh\u00f3m: " + sQLException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupEncryptionKey(int n) {
        String string = "SELECT encryption_key FROM groups WHERE group_id = ? AND is_encrypted = true";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                String string2 = null;
                return string2;
            }
            statement = connection.prepareStatement(string);
            statement.setInt(1, n);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string3 = resultSet.getString("encryption_key");
                if (string3 != null && !string3.isEmpty()) {
                    this.encryptionService.loadGroupKey(n, string3);
                }
                String string4 = string3;
                return string4;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i l\u1ea5y kh\u00f3a m\u00e3 h\u00f3a: " + sQLException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEncryptionKey(int n, String string) {
        String string2 = "UPDATE groups SET encryption_key = ?, is_encrypted = true WHERE group_id = ?";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl = false;
                return bl;
            }
            statement = connection.prepareStatement(string2);
            statement.setString(1, string);
            statement.setInt(2, n);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                System.out.println("\u2705 \u0110\u00e3 l\u01b0u kh\u00f3a m\u00e3 h\u00f3a cho nh\u00f3m " + n);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i l\u01b0u kh\u00f3a m\u00e3 h\u00f3a: " + sQLException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendGroupMessageEncrypted(int n, String string, String string2, boolean bl) {
        String string3;
        if (!this.isMember(n, string)) {
            System.err.println("\u274c B\u1ea1n kh\u00f4ng ph\u1ea3i th\u00e0nh vi\u00ean c\u1ee7a nh\u00f3m n\u00e0y");
            return false;
        }
        String string4 = string2;
        if (bl) {
            string3 = this.encryptionService.encryptMessage(n, string2);
            if (string3 != null) {
                string4 = string3;
            } else {
                System.err.println("\u274c Kh\u00f4ng th\u1ec3 m\u00e3 h\u00f3a tin nh\u1eafn!");
                return false;
            }
        }
        string3 = "INSERT INTO group_messages (group_id, sender_id, message_text, sent_time) VALUES (?, (SELECT user_id FROM users WHERE username = ?), ?, CURRENT_TIMESTAMP)";
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dbConnection.getConnection();
            if (connection == null) {
                boolean bl2 = false;
                return bl2;
            }
            statement = connection.prepareStatement(string3);
            statement.setInt(1, n);
            statement.setString(2, string);
            statement.setString(3, string4);
            int n2 = statement.executeUpdate();
            if (n2 > 0) {
                String string5 = bl ? " [\ud83d\udd12 E2E]" : "";
                System.out.println("\u2705 \u0110\u00e3 g\u1eedi tin nh\u1eafn nh\u00f3m" + string5);
                boolean bl3 = true;
                return bl3;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("\u274c L\u1ed7i khi g\u1eedi tin nh\u1eafn nh\u00f3m: " + sQLException.getMessage());
            sQLException.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                DatabaseConnection.closeConnection(connection);
            }
        }
        return false;
    }

    public List<Map<String, Object>> getGroupMessagesDecrypted(int n, boolean bl) {
        List<Map<String, Object>> list = this.getGroupMessages(n);
        if (!bl) {
            return list;
        }
        for (Map<String, Object> map : list) {
            String string = (String)map.get("message");
            if (string == null) continue;
            String string2 = this.encryptionService.decryptMessage(n, string);
            map.put("message", string2);
        }
        return list;
    }

    public EncryptionService getEncryptionService() {
        return this.encryptionService;
    }
}

