/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnection {
    private static DatabaseConnection instance;
    private String url;
    private String username;
    private String password;

    private DatabaseConnection() {
        try {
            this.loadConfig();
            Class.forName("org.postgresql.Driver");
            System.out.println("PostgreSQL Driver loaded!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadConfig() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream("release/config.properties");){
            properties.load(fileInputStream);
            this.url = properties.getProperty("db.url");
            this.username = properties.getProperty("db.username");
            this.password = properties.getProperty("db.password");
            System.out.println("Config loaded - URL: " + this.url);
        }
    }

    public static DatabaseConnection getInstance() {
        if (instance == null) {
            instance = new DatabaseConnection();
        }
        return instance;
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                System.err.println("Error closing connection: " + sQLException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing Supabase connection...");
        try {
            DatabaseConnection databaseConnection = DatabaseConnection.getInstance();
            Connection connection = databaseConnection.getConnection();
            System.out.println("SUCCESS! Connected to Supabase!");
            connection.close();
        }
        catch (Exception exception) {
            System.out.println("FAILED: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

