/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import user.gui.SettingsDialog;
import user.gui.UIHelper;
import user.gui.ViewProfileDialog;
import user.gui.ZaloMainFrame;

public class SidebarPanel
extends JPanel {
    private static final Color SIDEBAR_COLOR = new Color(0, 132, 255);
    private static final int SIDEBAR_WIDTH = 60;
    private ZaloMainFrame mainFrame;

    public SidebarPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setBackground(SIDEBAR_COLOR);
        this.setPreferredSize(new Dimension(60, 0));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        JButton jButton = this.createIconButton("icons/user.png", "T\u00e0i kho\u1ea3n", 36);
        jButton.addActionListener(actionEvent -> {
            ViewProfileDialog viewProfileDialog = new ViewProfileDialog(this.mainFrame);
            viewProfileDialog.setVisible(true);
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 25)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JButton jButton2 = this.createIconButton("icons/chat.png", "Tin nh\u1eafn", 28);
        JButton jButton3 = this.createIconButton("icons/contact.png", "Danh b\u1ea1", 28);
        jButton2.addActionListener(actionEvent -> this.mainFrame.showChatPanel());
        jButton3.addActionListener(actionEvent -> this.mainFrame.showContactPanel());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 15)));
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JButton jButton4 = this.createIconButton("icons/settings.png", "C\u00e0i \u0111\u1eb7t", 28);
        jButton4.addActionListener(actionEvent -> {
            SettingsDialog settingsDialog = new SettingsDialog(this.mainFrame);
            settingsDialog.setVisible(true);
        });
        jPanel3.add(jButton4);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
    }

    private JButton createIconButton(String string, String string2, int n) {
        final JButton jButton = new JButton();
        try {
            ImageIcon imageIcon = new ImageIcon(string);
            Image image = imageIcon.getImage();
            Image image2 = image.getScaledInstance(n, n, 4);
            ImageIcon imageIcon2 = new ImageIcon(image2);
            jButton.setIcon(imageIcon2);
        }
        catch (Exception exception) {
            jButton.setText("?");
            jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
            jButton.setForeground(Color.WHITE);
            System.err.println("\u26a0\ufe0f Kh\u00f4ng t\u00ecm th\u1ea5y icon: " + string);
        }
        jButton.setPreferredSize(new Dimension(50, 50));
        jButton.setMaximumSize(new Dimension(50, 50));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setToolTipText(string2);
        jButton.setAlignmentX(0.5f);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(true);
                jButton.setBackground(new Color(0, 102, 204));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setContentAreaFilled(false);
            }
        });
        return jButton;
    }
}

