/*
 * Decompiled with CFR 0.152.
 */
package admin.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnection {
    private static DatabaseConnection instance;
    private String url;
    private String username;
    private String password;
    private String driver;

    private DatabaseConnection() {
        try {
            this.loadConfig();
            Class.forName(this.driver);
            System.out.println("[Admin] Database Driver loaded: " + this.driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("[Admin] Database driver not found: " + classNotFoundException.getMessage());
            classNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("[Admin] Error initializing database connection: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void loadConfig() throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream("release/config.properties");){
            properties.load(fileInputStream);
            this.url = properties.getProperty("db.url");
            this.username = properties.getProperty("db.username");
            this.password = properties.getProperty("db.password");
            this.driver = properties.getProperty("db.driver", "org.postgresql.Driver");
            if (this.url == null || this.url.contains("YOUR_PROJECT_REF") || this.url.contains("YOUR_")) {
                throw new IOException("\u274c Database configuration ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh!\nVui l\u00f2ng c\u1eadp nh\u1eadt file release/config.properties v\u1edbi th\u00f4ng tin Supabase th\u1ef1c t\u1ebf.\nCh\u1ea1y: ./configure_db.sh \u0111\u1ec3 c\u1ea5u h\u00ecnh t\u1ef1 \u0111\u1ed9ng.");
            }
            if (this.password == null || this.password.contains("YOUR_PASSWORD") || this.password.contains("YOUR_")) {
                throw new IOException("\u274c Database password ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh!\nVui l\u00f2ng c\u1eadp nh\u1eadt db.password trong file release/config.properties.\nCh\u1ea1y: ./configure_db.sh \u0111\u1ec3 c\u1ea5u h\u00ecnh t\u1ef1 \u0111\u1ed9ng.");
            }
            if (this.url == null || this.username == null || this.password == null) {
                throw new IOException("\u274c Thi\u1ebfu th\u00f4ng tin c\u1ea5u h\u00ecnh database!\nC\u1ea7n c\u00f3: db.url, db.username, db.password trong file release/config.properties");
            }
            System.out.println("[Admin] Config loaded successfully");
            System.out.println("[Admin] Database URL: " + this.url);
            System.out.println("[Admin] Database User: " + this.username);
        }
        catch (IOException iOException) {
            System.err.println("[Admin] Failed to load config.properties: " + iOException.getMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseConnection getInstance() {
        if (instance != null) return instance;
        Class<DatabaseConnection> clazz = DatabaseConnection.class;
        synchronized (DatabaseConnection.class) {
            if (instance != null) return instance;
            instance = new DatabaseConnection();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.url == null || this.url.contains("YOUR_") || this.password == null || this.password.contains("YOUR_")) {
            throw new SQLException("Database configuration ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh. Vui l\u00f2ng c\u1eadp nh\u1eadt file release/config.properties ho\u1eb7c ch\u1ea1y ./configure_db.sh");
        }
        try {
            Connection connection = DriverManager.getConnection(this.url, this.username, this.password);
            System.out.println("[Admin] Database connection established");
            return connection;
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            System.err.println("[Admin] Failed to connect to database: " + string);
            if (string != null) {
                if (string.contains("password authentication failed")) {
                    throw new SQLException("\u274c Sai m\u1eadt kh\u1ea9u database!\nVui l\u00f2ng ki\u1ec3m tra l\u1ea1i db.password trong config.properties", sQLException);
                }
                if (string.contains("No route to host") || string.contains("Connection refused")) {
                    throw new SQLException("\u274c Kh\u00f4ng th\u1ec3 k\u1ebft n\u1ed1i \u0111\u1ebfn database!\nKi\u1ec3m tra:\n1. Project Reference c\u00f3 \u0111\u00fang kh\u00f4ng?\n2. Supabase project c\u00f3 b\u1ecb pause kh\u00f4ng? (Resume trong Dashboard)\n3. Network/Firewall c\u00f3 ch\u1eb7n kh\u00f4ng?", sQLException);
                }
                if (string.contains("The connection attempt failed")) {
                    throw new SQLException("\u274c K\u1ebft n\u1ed1i th\u1ea5t b\u1ea1i!\nKi\u1ec3m tra:\n1. File config.properties \u0111\u00e3 \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh \u0111\u00fang ch\u01b0a?\n2. Ch\u1ea1y: ./configure_db.sh \u0111\u1ec3 c\u1ea5u h\u00ecnh\n3. Ho\u1eb7c ki\u1ec3m tra Supabase Dashboard xem project c\u00f3 \u0111ang ho\u1ea1t \u0111\u1ed9ng kh\u00f4ng", sQLException);
                }
            }
            throw sQLException;
        }
    }

    public static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                System.out.println("[Admin] Database connection closed");
            }
            catch (SQLException sQLException) {
                System.err.println("[Admin] Error closing connection: " + sQLException.getMessage());
            }
        }
    }

    public boolean testConnection() {
        boolean bl;
        block8: {
            Connection connection = this.getConnection();
            try {
                boolean bl2 = bl = connection != null && !connection.isClosed();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    System.err.println("[Admin] Connection test failed: " + sQLException.getMessage());
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void reloadConfig() {
        try {
            this.loadConfig();
            System.out.println("[Admin] Configuration reloaded successfully");
        }
        catch (IOException iOException) {
            System.err.println("[Admin] Failed to reload configuration: " + iOException.getMessage());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDriver() {
        return this.driver;
    }

    public static void main(String[] stringArray) {
        System.out.println("========================================");
        System.out.println("Testing Admin Database Connection...");
        System.out.println("========================================");
        DatabaseConnection databaseConnection = DatabaseConnection.getInstance();
        if (databaseConnection.testConnection()) {
            System.out.println("\u2705 Connection test SUCCESSFUL!");
            System.out.println("Database: " + databaseConnection.getUrl());
            System.out.println("Driver: " + databaseConnection.getDriver());
        } else {
            System.out.println("\u274c Connection test FAILED!");
            System.out.println("Please check your config.properties file");
        }
        System.out.println("========================================");
    }
}

