/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.LoginHistoryDAO;
import admin.socket.LoginHistory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class LoginHistoryPanel
extends JPanel {
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color DANGER_RED = new Color(220, 53, 69);
    private JTable historyTable;
    private DefaultTableModel tableModel;
    private JButton refreshButton;
    private JButton exportButton;
    private JLabel totalLabel;
    private LoginHistoryDAO loginHistoryDAO;
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");

    public LoginHistoryPanel() {
        try {
            this.loginHistoryDAO = new LoginHistoryDAO();
            this.initializeComponents();
            this.setupLayout();
            this.loadLoginHistoryFromDatabase();
            this.setupEventHandlers();
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i kh\u1edfi t\u1ea1o: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void initializeComponents() {
        Object[] objectArray = new String[]{"ID", "Th\u1eddi gian", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.historyTable = new JTable(this.tableModel);
        this.historyTable.setRowHeight(28);
        this.historyTable.setAutoCreateRowSorter(true);
        this.historyTable.setFillsViewportHeight(true);
        this.historyTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.historyTable.getTableHeader().setBackground(Color.WHITE);
        this.historyTable.getTableHeader().setForeground(Color.BLACK);
        TableColumnModel tableColumnModel = this.historyTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(60);
        tableColumnModel.getColumn(1).setPreferredWidth(180);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(200);
        this.refreshButton = this.createButtonWithIcon("L\u00e0m m\u1edbi", "refresh");
        this.exportButton = this.createButtonWithIcon("Xu\u1ea5t CSV", "export");
        this.styleAddUserButtonSimple(this.refreshButton);
        this.styleAddUserButtonSimple(this.exportButton);
        this.totalLabel = new JLabel("T\u1ed5ng s\u1ed1 l\u01b0\u1ee3t: 0");
        this.totalLabel.setFont(new Font("Arial", 1, 12));
    }

    private void loadLoginHistoryFromDatabase() {
        try {
            List<LoginHistory> list = this.loginHistoryDAO.getAllLoginHistory();
            this.displayLoginHistories(list);
            this.totalLabel.setText("T\u1ed5ng s\u1ed1 l\u01b0\u1ee3t: " + list.size());
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            String string2 = "L\u1ed7i load d\u1eef li\u1ec7u l\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp: " + string;
            if (string != null && (string.contains("connection") || string.contains("Connection"))) {
                string2 = string2 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string2);
            sQLException.printStackTrace();
        }
    }

    private void displayLoginHistories(List<LoginHistory> list) {
        this.tableModel.setRowCount(0);
        for (LoginHistory loginHistory : list) {
            Object[] objectArray = new Object[]{loginHistory.getId(), loginHistory.getLoginTime() != null ? loginHistory.getLoginTime().format(this.dateTimeFormatter) : "", loginHistory.getUsername(), loginHistory.getFullName(), loginHistory.getIpAddress() != null ? loginHistory.getIpAddress() : "N/A"};
            this.tableModel.addRow(objectArray);
        }
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createTablePanel();
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = this.createButtonPanel();
        this.add((Component)jPanel2, "South");
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("history", 20, 20);
        JLabel jLabel = new JLabel("L\u1ecbch s\u1eed \u0111\u0103ng nh\u1eadp");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setIconTextGap(10);
            jLabel.setHorizontalTextPosition(4);
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setHorizontalAlignment(2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        this.totalLabel.setFont(new Font("Arial", 1, 12));
        jPanel3.add(this.totalLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        JScrollPane jScrollPane = new JScrollPane(this.historyTable);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        jPanel.setOpaque(false);
        jPanel.add(this.refreshButton);
        jPanel.add(this.exportButton);
        return jPanel;
    }

    private void setupEventHandlers() {
        this.refreshButton.addActionListener(actionEvent -> this.handleRefresh());
        this.exportButton.addActionListener(actionEvent -> this.handleExport());
    }

    private void handleRefresh() {
        this.loadLoginHistoryFromDatabase();
        JOptionPane.showMessageDialog(this, "\u0110\u00e3 l\u00e0m m\u1edbi d\u1eef li\u1ec7u!", "Th\u00f4ng b\u00e1o", 1);
    }

    private void handleExport() {
        try {
            List<LoginHistory> list = this.loginHistoryDAO.getAllLoginHistory();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("LichSuDangNhap.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,Th\u1eddi gian,T\u00ean \u0111\u0103ng nh\u1eadp,H\u1ecd t\u00ean,\u0110\u1ecba ch\u1ec9 IP,Thi\u1ebft b\u1ecb");
                for (LoginHistory loginHistory : list) {
                    String string = String.format("%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", loginHistory.getId(), loginHistory.getLoginTime() != null ? loginHistory.getLoginTime().format(this.dateTimeFormatter) : "", this.escapeCsv(loginHistory.getUsername()), this.escapeCsv(loginHistory.getFullName()), this.escapeCsv(loginHistory.getIpAddress()), this.escapeCsv(loginHistory.getUserAgent()));
                    printWriter.println(string);
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + list.size() + " b\u1ea3n ghi v\u00e0o file:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i xu\u1ea5t file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String escapeCsv(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\"", "\"\"");
    }

    private void stylePrimaryButton(JButton jButton) {
        jButton.setBackground(ZALO_BLUE);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleAddUserButtonSimple(JButton jButton) {
        Color color = new Color(32, 178, 170);
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private JButton createButtonWithIcon(String string, String string2) {
        JButton jButton = new JButton(string);
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        }
        return jButton;
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }
}

