/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.StatisticsDAO;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ActiveUserChartPanel
extends JPanel {
    private static final Color TEAL = new Color(75, 192, 192);
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color NEUTRAL_GRAY = new Color(108, 117, 125);
    private JComboBox<Integer> yearSelector;
    private JButton viewButton;
    private JButton refreshButton;
    private BarChartPanel chartPanel;
    private JLabel currentYearLabel;
    private JLabel totalActiveLabel;
    private StatisticsDAO statisticsDAO = new StatisticsDAO();

    public ActiveUserChartPanel() {
        this.initComponents();
        this.setupLayout();
        this.setupEventHandlers();
        this.loadDataForYear(2025);
    }

    private void initComponents() {
        Integer[] integerArray = new Integer[]{2025, 2024, 2023, 2022, 2021, 2020};
        this.yearSelector = new JComboBox<Integer>(integerArray);
        this.yearSelector.setPreferredSize(new Dimension(100, 30));
        this.viewButton = this.createButtonWithIcon("Xem bi\u1ec3u \u0111\u1ed3", "chart");
        this.refreshButton = this.createButtonWithIcon("L\u00e0m m\u1edbi", "refresh");
        this.stylePrimaryButton(this.viewButton);
        this.stylePrimaryButton(this.refreshButton);
        this.chartPanel = new BarChartPanel();
        this.currentYearLabel = new JLabel("N\u0103m: 2025");
        this.currentYearLabel.setFont(new Font("Arial", 1, 14));
        this.currentYearLabel.setForeground(ZALO_BLUE);
        this.totalActiveLabel = new JLabel("T\u1ed5ng s\u1ed1 l\u1ea7n m\u1edf \u1ee9ng d\u1ee5ng: 0");
        this.totalActiveLabel.setFont(new Font("Arial", 1, 13));
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createFilterPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createChartPanel();
        this.add((Component)jPanel2, "Center");
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TEAL, 2), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("chart", 20, 20);
        JLabel jLabel = new JLabel("T\u00f9y ch\u1ecdn bi\u1ec3u \u0111\u1ed3");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.add(new JLabel("Ch\u1ecdn n\u0103m:"));
        jPanel2.add(this.yearSelector);
        jPanel2.add(this.viewButton);
        jPanel2.add(this.refreshButton);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createChartPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TEAL, 2), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("activity", 20, 20);
        JLabel jLabel = new JLabel("Bi\u1ec3u \u0111\u1ed3 s\u1ed1 l\u01b0\u1ee3ng ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        jPanel3.add(this.currentYearLabel);
        jPanel3.add(new JLabel("|"));
        jPanel3.add(this.totalActiveLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBackground(Color.WHITE);
        jPanel4.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        jPanel4.add((Component)this.chartPanel, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private void setupEventHandlers() {
        this.viewButton.addActionListener(actionEvent -> {
            Integer n = (Integer)this.yearSelector.getSelectedItem();
            this.loadDataForYear(n);
        });
        this.refreshButton.addActionListener(actionEvent -> {
            Integer n = (Integer)this.yearSelector.getSelectedItem();
            this.loadDataForYear(n);
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 l\u00e0m m\u1edbi d\u1eef li\u1ec7u n\u0103m " + n + "!", "Th\u00f4ng b\u00e1o", 1);
        });
    }

    private void loadDataForYear(int n) {
        try {
            int[] nArray = this.statisticsDAO.getMonthlyActiveUsers(n);
            int n2 = this.statisticsDAO.getTotalActiveUsersInYear(n);
            this.chartPanel.updateData(nArray);
            this.currentYearLabel.setText("N\u0103m: " + n);
            this.totalActiveLabel.setText("T\u1ed5ng s\u1ed1 l\u1ea7n m\u1edf \u1ee9ng d\u1ee5ng: " + n2);
        }
        catch (SQLException sQLException) {
            String string = sQLException.getMessage();
            String string2 = "L\u1ed7i load d\u1eef li\u1ec7u ng\u01b0\u1eddi d\u00f9ng ho\u1ea1t \u0111\u1ed9ng: " + string;
            if (string != null && (string.contains("connection") || string.contains("Connection"))) {
                string2 = string2 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- N\u0103m \u0111\u00e3 ch\u1ecdn\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string2);
            sQLException.printStackTrace();
            this.chartPanel.updateData(new int[12]);
            this.currentYearLabel.setText("N\u0103m: " + n);
            this.totalActiveLabel.setText("T\u1ed5ng s\u1ed1 l\u1ea7n m\u1edf \u1ee9ng d\u1ee5ng: 0");
        }
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void stylePrimaryButton(JButton jButton) {
        jButton.setBackground(ZALO_BLUE);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleNeutralButton(JButton jButton) {
        jButton.setBackground(NEUTRAL_GRAY);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JButton createButtonWithIcon(String string, String string2) {
        JButton jButton = new JButton(string);
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        }
        jButton.setPreferredSize(new Dimension(200, 35));
        return jButton;
    }

    private class BarChartPanel
    extends JPanel {
        private int[] data = new int[12];
        private String[] months = new String[]{"T1", "T2", "T3", "T4", "T5", "T6", "T7", "T8", "T9", "T10", "T11", "T12"};

        public BarChartPanel() {
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(800, 400));
        }

        public void updateData(int[] nArray) {
            if (nArray != null && nArray.length == 12) {
                this.data = nArray;
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = 40;
            int n6 = 25;
            int n7 = n5 + n6;
            int n8 = n4 - n5 - n6;
            int n9 = n3 - 2 * n5 - n6;
            int n10 = n4 - 2 * n5 - n6;
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawLine(n7, n8, n7, n5);
            graphics2D.drawLine(n7, n8, n7 + n9, n8);
            graphics2D.setFont(new Font("Arial", 1, 12));
            graphics2D.drawString("S\u1ed1 l\u1ea7n m\u1edf", 5, n5 - 5);
            graphics2D.drawString("Th\u00e1ng", n7 + n9 + 10, n8 + 5);
            int n11 = 0;
            int[] nArray = this.data;
            int n12 = nArray.length;
            for (n2 = 0; n2 < n12; ++n2) {
                int n13 = nArray[n2];
                if (n13 <= n11) continue;
                n11 = n13;
            }
            if ((n11 = (int)(Math.ceil((double)n11 / 50.0) * 50.0)) == 0) {
                n11 = 100;
            }
            int n14 = 5;
            graphics2D.setStroke(new BasicStroke(1.0f));
            for (n12 = 0; n12 <= n14; ++n12) {
                n2 = n8 - n12 * n10 / n14;
                graphics2D.setColor(new Color(220, 220, 220));
                graphics2D.drawLine(n7, n2, n7 + n9, n2);
                graphics2D.setColor(Color.BLACK);
                String string = String.valueOf(n12 * n11 / n14);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                n = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, n7 - n - 8, n2 + fontMetrics.getHeight() / 2 - 3);
            }
            n2 = n12 = n9 / (this.data.length * 2);
            for (int i = 0; i < this.data.length; ++i) {
                int n15 = n7 + i * (n12 + n2) + n2 / 2;
                n = (int)((double)this.data[i] / (double)n11 * (double)n10);
                int n16 = n8 - n;
                GradientPaint gradientPaint = new GradientPaint(n15, n16, TEAL, n15, n8, new Color(120, 220, 220));
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(n15, n16, n12, n);
                graphics2D.setColor(TEAL.darker());
                graphics2D.drawRect(n15, n16, n12, n);
                graphics2D.setColor(Color.BLACK);
                graphics2D.setFont(new Font("Arial", 1, 11));
                String string = String.valueOf(this.data[i]);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n17 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, n15 + (n12 - n17) / 2, n16 - 5);
                graphics2D.setFont(new Font("Arial", 0, 11));
                String string2 = this.months[i];
                n17 = fontMetrics.stringWidth(string2);
                graphics2D.drawString(string2, n15 + (n12 - n17) / 2, n8 + fontMetrics.getHeight() + 2);
            }
        }
    }
}

