/*
 * Decompiled with CFR 0.152.
 */
package user.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailService {
    private String smtpHost;
    private int smtpPort;
    private String smtpUsername;
    private String smtpPassword;
    private String fromEmail;
    private String fromName;

    public EmailService() {
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream("release/config.properties");){
            properties.load(fileInputStream);
            this.smtpHost = properties.getProperty("email.host", "smtp.gmail.com");
            this.smtpPort = Integer.parseInt(properties.getProperty("email.port", "587"));
            this.smtpUsername = properties.getProperty("email.username", "");
            this.smtpPassword = properties.getProperty("email.password", "");
            this.fromEmail = properties.getProperty("email.from", this.smtpUsername);
            this.fromName = properties.getProperty("email.from.name", "InstantChat System");
            System.out.println("\u2705 Email configuration loaded");
            System.out.println("   SMTP Host: " + this.smtpHost + ":" + this.smtpPort);
            System.out.println("   Username: " + (this.smtpUsername.isEmpty() ? "(ch\u01b0a c\u1ea5u h\u00ecnh)" : this.smtpUsername));
            System.out.println("   From: " + this.fromName + " <" + this.fromEmail + ">");
        }
        catch (IOException | NumberFormatException exception) {
            System.err.println("\u26a0\ufe0f  Kh\u00f4ng \u0111\u1ecdc \u0111\u01b0\u1ee3c email config, d\u00f9ng gi\u00e1 tr\u1ecb m\u1eb7c \u0111\u1ecbnh");
            this.setDefaultConfiguration();
        }
    }

    private void setDefaultConfiguration() {
        this.smtpHost = "smtp.gmail.com";
        this.smtpPort = 587;
        this.smtpUsername = "";
        this.smtpPassword = "";
        this.fromEmail = "noreply@chatsystem.com";
        this.fromName = "InstantChat System";
    }

    public boolean sendResetPasswordEmail(String string, String string2, String string3) {
        if (this.smtpUsername == null || this.smtpUsername.isEmpty() || this.smtpPassword == null || this.smtpPassword.isEmpty()) {
            System.err.println("\u274c Email ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh!");
            System.err.println("   Vui l\u00f2ng c\u1eadp nh\u1eadt email.username v\u00e0 email.password trong config.properties");
            return false;
        }
        try {
            Properties properties = new Properties();
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.smtp.host", this.smtpHost);
            properties.put("mail.smtp.port", String.valueOf(this.smtpPort));
            properties.put("mail.smtp.ssl.protocols", "TLSv1.2");
            Session session = Session.getInstance(properties, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailService.this.smtpUsername, EmailService.this.smtpPassword);
                }
            });
            MimeMessage mimeMessage = new MimeMessage(session);
            ((Message)mimeMessage).setFrom(new InternetAddress(this.fromEmail, this.fromName));
            ((Message)mimeMessage).setRecipients(Message.RecipientType.TO, InternetAddress.parse(string));
            ((Message)mimeMessage).setSubject("[InstantChat] Kh\u00f4i Ph\u1ee5c M\u1eadt Kh\u1ea9u");
            String string4 = "<html><body style='font-family: Arial, sans-serif; padding: 20px; background-color: #f5f7fa;'>  <div style='max-width: 600px; margin: 0 auto; background-color: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);'>    <div style='text-align: center; margin-bottom: 30px;'>      <h1 style='color: #0084FF; margin: 0;'>\ud83d\udcac InstantChat</h1>    </div>    <h2 style='color: #333;'>Xin ch\u00e0o " + string2 + ",</h2>    <p style='color: #666; line-height: 1.6;'>Ch\u00fang t\u00f4i \u0111\u00e3 nh\u1eadn \u0111\u01b0\u1ee3c y\u00eau c\u1ea7u kh\u00f4i ph\u1ee5c m\u1eadt kh\u1ea9u cho t\u00e0i kho\u1ea3n c\u1ee7a b\u1ea1n.</p>    <div style='background-color: #f0f8ff; border-left: 4px solid #0084FF; padding: 20px; margin: 20px 0;'>      <p style='margin: 0 0 10px 0; color: #333; font-weight: bold;'>M\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi c\u1ee7a b\u1ea1n:</p>      <h1 style='margin: 10px 0; color: #0084FF; font-size: 32px; letter-spacing: 2px; font-family: monospace;'>" + string3 + "</h1>    </div>    <div style='background-color: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;'>      <p style='margin: 0 0 10px 0; color: #856404; font-weight: bold;'>\u26a0\ufe0f L\u01afU \u00dd B\u1ea2O M\u1eacT:</p>      <ul style='margin: 0; padding-left: 20px; color: #856404;'>        <li>Vui l\u00f2ng \u0111\u1ed5i m\u1eadt kh\u1ea9u ngay sau khi \u0111\u0103ng nh\u1eadp</li>        <li>Kh\u00f4ng chia s\u1ebb m\u1eadt kh\u1ea9u n\u00e0y v\u1edbi b\u1ea5t k\u1ef3 ai</li>        <li>N\u1ebfu b\u1ea1n kh\u00f4ng y\u00eau c\u1ea7u kh\u00f4i ph\u1ee5c, h\u00e3y li\u00ean h\u1ec7 admin ngay</li>      </ul>    </div>    <p style='color: #666; line-height: 1.6;'>C\u1ea3m \u01a1n b\u1ea1n \u0111\u00e3 s\u1eed d\u1ee5ng d\u1ecbch v\u1ee5 c\u1ee7a ch\u00fang t\u00f4i!</p>    <hr style='border: none; border-top: 1px solid #eee; margin: 30px 0;'>    <p style='color: #999; font-size: 12px; text-align: center;'>Email n\u00e0y \u0111\u01b0\u1ee3c g\u1eedi t\u1ef1 \u0111\u1ed9ng, vui l\u00f2ng kh\u00f4ng tr\u1ea3 l\u1eddi.<br>\u00a9 2025 InstantChat System. All rights reserved.</p>  </div></body></html>";
            mimeMessage.setContent(string4, "text/html; charset=utf-8");
            System.out.println("\n\ud83d\udce7 \u0110ang g\u1eedi email \u0111\u1ebfn: " + string + "...");
            Transport.send(mimeMessage);
            System.out.println("\u2705 Email \u0111\u00e3 \u0111\u01b0\u1ee3c g\u1eedi th\u00e0nh c\u00f4ng!");
            return true;
        }
        catch (Exception exception) {
            System.err.println("\u274c L\u1ed7i khi g\u1eedi email: " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean testEmailConfiguration() {
        System.out.println("\n\ud83e\uddea Testing Email Configuration...");
        System.out.println("   SMTP Host: " + this.smtpHost);
        System.out.println("   SMTP Port: " + this.smtpPort);
        System.out.println("   Username: " + (this.smtpUsername.isEmpty() ? "(ch\u01b0a c\u1ea5u h\u00ecnh)" : this.smtpUsername));
        System.out.println("   From Email: " + this.fromEmail);
        System.out.println("   From Name: " + this.fromName);
        if (this.smtpUsername.isEmpty()) {
            System.out.println("\n\u26a0\ufe0f  Email ch\u01b0a \u0111\u01b0\u1ee3c c\u1ea5u h\u00ecnh!");
            return false;
        }
        System.out.println("\n\u2705 Email configuration OK (DEMO MODE)");
        return true;
    }
}

