/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import user.gui.BlockedUsersDialog;
import user.gui.LoginFrame;
import user.gui.UIHelper;
import user.gui.UpdateProfileDialog;
import user.gui.ViewProfileDialog;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class SettingsDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private ZaloMainFrame mainFrame;
    private UserService userService = new UserService();

    public SettingsDialog(ZaloMainFrame zaloMainFrame) {
        super(zaloMainFrame, "C\u00e0i \u0111\u1eb7t", true);
        this.mainFrame = zaloMainFrame;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setSize(400, 500);
        this.setLocationRelativeTo(this.mainFrame);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("C\u00e0i \u0111\u1eb7t");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 20));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        JPanel jPanel3 = this.createMenuItem("\u2139\ufe0f", "Xem th\u00f4ng tin t\u00e0i kho\u1ea3n", "Xem th\u00f4ng tin c\u00e1 nh\u00e2n chi ti\u1ebft", () -> this.openViewProfileDialog());
        JPanel jPanel4 = this.createMenuItem("\ud83d\udc64", "C\u1eadp nh\u1eadt th\u00f4ng tin t\u00e0i kho\u1ea3n", "Thay \u0111\u1ed5i t\u00ean, email, ng\u00e0y sinh", () -> this.openUpdateProfileDialog());
        JPanel jPanel5 = this.createMenuItem("\ud83d\udd11", "\u0110\u1ed5i m\u1eadt kh\u1ea9u", "Thay \u0111\u1ed5i m\u1eadt kh\u1ea9u \u0111\u0103ng nh\u1eadp", () -> this.openChangePasswordDialog());
        JPanel jPanel6 = this.createMenuItem("\ud83d\udeab", "Danh s\u00e1ch ng\u01b0\u1eddi \u0111\u00e3 ch\u1eb7n", "Xem v\u00e0 b\u1ecf ch\u1eb7n ng\u01b0\u1eddi d\u00f9ng", () -> this.openBlockedUsersDialog());
        JPanel jPanel7 = this.createMenuItem("\ud83d\udeaa", "\u0110\u0103ng xu\u1ea5t t\u00e0i kho\u1ea3n", "Tho\u00e1t kh\u1ecfi \u1ee9ng d\u1ee5ng", () -> this.logout());
        jPanel2.add(jPanel3);
        jPanel2.add(this.createSeparator());
        jPanel2.add(jPanel4);
        jPanel2.add(this.createSeparator());
        jPanel2.add(jPanel5);
        jPanel2.add(this.createSeparator());
        jPanel2.add(jPanel6);
        jPanel2.add(this.createSeparator());
        jPanel2.add(jPanel7);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel createMenuItem(String string, String string2, String string3, final Runnable runnable) {
        final JPanel jPanel = new JPanel(new BorderLayout(15, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        jPanel.setCursor(new Cursor(12));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getEmojiFontName(), 0, 28));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 15));
        JLabel jLabel3 = new JLabel(string3);
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel3.setForeground(new Color(120, 120, 120));
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(3));
        jPanel2.add(jLabel3);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                runnable.run();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setBackground(Color.WHITE);
            }
        });
        return jPanel;
    }

    private JPanel createSeparator() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(230, 230, 230));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        jPanel.setPreferredSize(new Dimension(0, 1));
        return jPanel;
    }

    private void openViewProfileDialog() {
        this.dispose();
        ViewProfileDialog viewProfileDialog = new ViewProfileDialog(this.mainFrame);
        viewProfileDialog.setVisible(true);
    }

    private void openUpdateProfileDialog() {
        this.dispose();
        UpdateProfileDialog updateProfileDialog = new UpdateProfileDialog(this.mainFrame);
        updateProfileDialog.setVisible(true);
    }

    private void openBlockedUsersDialog() {
        this.dispose();
        BlockedUsersDialog blockedUsersDialog = new BlockedUsersDialog(this.mainFrame);
        blockedUsersDialog.setVisible(true);
    }

    private void openChangePasswordDialog() {
        final JDialog jDialog = new JDialog(this, "\u0110\u1ed5i m\u1eadt kh\u1ea9u", true);
        jDialog.setSize(400, 400);
        jDialog.setLocationRelativeTo(this);
        jDialog.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(PRIMARY_COLOR);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 20));
        JLabel jLabel = new JLabel("\ud83d\udd11 \u0110\u1ed5i m\u1eadt kh\u1ea9u");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jLabel.setForeground(Color.WHITE);
        jPanel.add((Component)jLabel, "West");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 25, 20, 25));
        JLabel jLabel2 = new JLabel("M\u1eadt kh\u1ea9u hi\u1ec7n t\u1ea1i");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel2.setAlignmentX(0.0f);
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPasswordField.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        jPasswordField.setAlignmentX(0.0f);
        jPasswordField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        JLabel jLabel3 = new JLabel("M\u1eadt kh\u1ea9u m\u1edbi");
        jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel3.setAlignmentX(0.0f);
        JPasswordField jPasswordField2 = new JPasswordField();
        jPasswordField2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPasswordField2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        jPasswordField2.setAlignmentX(0.0f);
        jPasswordField2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        JLabel jLabel4 = new JLabel("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u m\u1edbi");
        jLabel4.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel4.setAlignmentX(0.0f);
        JPasswordField jPasswordField3 = new JPasswordField();
        jPasswordField3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPasswordField3.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        jPasswordField3.setAlignmentX(0.0f);
        jPasswordField3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), BorderFactory.createEmptyBorder(8, 10, 8, 10)));
        jPanel2.add(jLabel2);
        jPanel2.add(Box.createVerticalStrut(8));
        jPanel2.add(jPasswordField);
        jPanel2.add(Box.createVerticalStrut(15));
        jPanel2.add(jLabel3);
        jPanel2.add(Box.createVerticalStrut(8));
        jPanel2.add(jPasswordField2);
        jPanel2.add(Box.createVerticalStrut(15));
        jPanel2.add(jLabel4);
        jPanel2.add(Box.createVerticalStrut(8));
        jPanel2.add(jPasswordField3);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 15));
        jPanel3.setBackground(Color.WHITE);
        jPanel3.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(230, 230, 230)));
        JButton jButton = new JButton("H\u1ee7y");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton.setPreferredSize(new Dimension(100, 38));
        jButton.addActionListener(actionEvent -> jDialog.dispose());
        final JButton jButton2 = new JButton("\u0110\u1ed5i m\u1eadt kh\u1ea9u");
        jButton2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton2.setBackground(PRIMARY_COLOR);
        jButton2.setForeground(Color.WHITE);
        jButton2.setPreferredSize(new Dimension(130, 38));
        jButton2.setBorderPainted(false);
        jButton2.setFocusPainted(false);
        jButton2.setOpaque(true);
        jButton2.setContentAreaFilled(true);
        jButton2.addActionListener(actionEvent -> {
            final String string = new String(jPasswordField.getPassword());
            final String string2 = new String(jPasswordField2.getPassword());
            String string3 = new String(jPasswordField3.getPassword());
            if (string.isEmpty() || string2.isEmpty() || string3.isEmpty()) {
                JOptionPane.showMessageDialog(jDialog, "Vui l\u00f2ng \u0111i\u1ec1n \u0111\u1ea7y \u0111\u1ee7 th\u00f4ng tin!", "L\u1ed7i", 0);
                return;
            }
            if (string2.length() < 6) {
                JOptionPane.showMessageDialog(jDialog, "M\u1eadt kh\u1ea9u m\u1edbi ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 6 k\u00fd t\u1ef1!", "L\u1ed7i", 0);
                return;
            }
            if (!string2.equals(string3)) {
                JOptionPane.showMessageDialog(jDialog, "M\u1eadt kh\u1ea9u m\u1edbi v\u00e0 x\u00e1c nh\u1eadn kh\u00f4ng kh\u1edbp!", "L\u1ed7i", 0);
                return;
            }
            if (string.equals(string2)) {
                JOptionPane.showMessageDialog(jDialog, "M\u1eadt kh\u1ea9u m\u1edbi ph\u1ea3i kh\u00e1c m\u1eadt kh\u1ea9u hi\u1ec7n t\u1ea1i!", "L\u1ed7i", 0);
                return;
            }
            jButton2.setEnabled(false);
            jButton2.setText("\u0110ang x\u1eed l\u00fd...");
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){
                private String errorMessage = "";

                @Override
                protected Boolean doInBackground() {
                    boolean bl = SettingsDialog.this.userService.verifyPassword(SettingsDialog.this.mainFrame.getUsername(), string);
                    if (!bl) {
                        this.errorMessage = "M\u1eadt kh\u1ea9u hi\u1ec7n t\u1ea1i kh\u00f4ng \u0111\u00fang!";
                        return false;
                    }
                    return SettingsDialog.this.userService.changePassword(SettingsDialog.this.mainFrame.getUsername(), string2);
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            JOptionPane.showMessageDialog(jDialog, "\u0110\u1ed5i m\u1eadt kh\u1ea9u th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                            jDialog.dispose();
                        } else {
                            JOptionPane.showMessageDialog(jDialog, this.errorMessage.isEmpty() ? "Kh\u00f4ng th\u1ec3 \u0111\u1ed5i m\u1eadt kh\u1ea9u!" : this.errorMessage, "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(jDialog, "C\u00f3 l\u1ed7i x\u1ea3y ra: " + exception.getMessage(), "L\u1ed7i", 0);
                    }
                    finally {
                        jButton2.setEnabled(true);
                        jButton2.setText("\u0110\u1ed5i m\u1eadt kh\u1ea9u");
                    }
                }
            };
            swingWorker.execute();
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JScrollPane jScrollPane = new JScrollPane(jPanel2);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jDialog.add((Component)jPanel, "North");
        jDialog.add((Component)jScrollPane, "Center");
        jDialog.add((Component)jPanel3, "South");
        jDialog.setVisible(true);
    }

    private void logout() {
        int n = JOptionPane.showConfirmDialog(this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n \u0111\u0103ng xu\u1ea5t?", "X\u00e1c nh\u1eadn \u0111\u0103ng xu\u1ea5t", 0, 3);
        if (n == 0) {
            if (this.mainFrame.getSocketClient() != null) {
                this.mainFrame.getSocketClient().disconnect();
            }
            this.dispose();
            this.mainFrame.setVisible(false);
            this.mainFrame.dispose();
            SwingUtilities.invokeLater(() -> {
                LoginFrame loginFrame = new LoginFrame();
                loginFrame.setVisible(true);
            });
        }
    }
}

