/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import user.gui.UIHelper;
import user.service.UserService;

public class RegisterFrame
extends JFrame {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color PRIMARY_DARK = new Color(0, 102, 204);
    private static final Color BACKGROUND_COLOR = new Color(245, 247, 250);
    private static final Color TEXT_COLOR = new Color(51, 51, 51);
    private static final Color PLACEHOLDER_COLOR = new Color(153, 153, 153);
    private JTextField usernameField;
    private JTextField fullNameField;
    private JTextField emailField;
    private JTextField addressField;
    private JPasswordField passwordField;
    private JPasswordField confirmPasswordField;
    private JComboBox<String> genderCombo;
    private JSpinner birthDateSpinner;
    private JButton registerButton;
    private JButton backButton;
    private JLabel titleLabel;
    private JLabel subtitleLabel;

    public RegisterFrame() {
        this.initializeComponents();
        this.setupLayout();
        this.applyModernStyle();
    }

    private void initializeComponents() {
        this.setTitle("\u0110\u0103ng k\u00fd t\u00e0i kho\u1ea3n - InstantChat");
        this.setDefaultCloseOperation(2);
        this.setSize(550, 750);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.getContentPane().setBackground(BACKGROUND_COLOR);
        this.titleLabel = new JLabel("T\u1ea1o t\u00e0i kho\u1ea3n m\u1edbi", 0);
        this.titleLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 28));
        this.titleLabel.setForeground(PRIMARY_COLOR);
        this.subtitleLabel = new JLabel("\u0110i\u1ec1n th\u00f4ng tin \u0111\u1ec3 b\u1eaft \u0111\u1ea7u", 0);
        this.subtitleLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.subtitleLabel.setForeground(TEXT_COLOR);
        this.usernameField = this.createStyledTextField("T\u00ean \u0111\u0103ng nh\u1eadp");
        this.passwordField = this.createStyledPasswordField("M\u1eadt kh\u1ea9u");
        this.confirmPasswordField = this.createStyledPasswordField("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u");
        this.fullNameField = this.createStyledTextField("H\u1ecd v\u00e0 t\u00ean");
        this.emailField = this.createStyledTextField("Email");
        this.addressField = this.createStyledTextField("\u0110\u1ecba ch\u1ec9");
        this.genderCombo = new JComboBox<String>(new String[]{"Nam", "N\u1eef", "Kh\u00e1c"});
        this.genderCombo.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.genderCombo.setPreferredSize(new Dimension(300, 45));
        this.genderCombo.setBackground(Color.WHITE);
        this.genderCombo.setForeground(TEXT_COLOR);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(calendar.getTime(), null, null, 5);
        this.birthDateSpinner = new JSpinner(spinnerDateModel);
        this.birthDateSpinner.setEditor(new JSpinner.DateEditor(this.birthDateSpinner, "dd/MM/yyyy"));
        this.birthDateSpinner.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.birthDateSpinner.setPreferredSize(new Dimension(300, 45));
        this.birthDateSpinner.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        this.registerButton = this.createPrimaryButton("\u0110\u0102NG K\u00dd");
        this.registerButton.addActionListener(actionEvent -> this.handleRegister());
        this.backButton = this.createSecondaryButton("Quay l\u1ea1i \u0111\u0103ng nh\u1eadp");
        this.backButton.addActionListener(actionEvent -> this.dispose());
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 40, 8, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(30, 40, 3, 40);
        this.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 40, 15, 40);
        this.add((Component)this.subtitleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 40, 8, 40);
        this.add((Component)this.usernameField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.passwordField, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.confirmPasswordField, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.fullNameField, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.emailField, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.add((Component)this.addressField, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        this.add(this.genderCombo, gridBagConstraints);
        gridBagConstraints.gridy = 9;
        this.add((Component)this.birthDateSpinner, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(15, 40, 8, 40);
        this.add((Component)this.registerButton, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(8, 40, 20, 40);
        this.add((Component)this.backButton, gridBagConstraints);
    }

    private void applyModernStyle() {
        this.addHoverEffect(this.registerButton, PRIMARY_COLOR, PRIMARY_DARK);
        this.addHoverEffect(this.backButton, Color.WHITE, new Color(240, 240, 240));
    }

    private JTextField createStyledTextField(final String string) {
        final JTextField jTextField = new JTextField(20);
        jTextField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jTextField.setForeground(TEXT_COLOR);
        jTextField.setText(string);
        jTextField.setForeground(PLACEHOLDER_COLOR);
        jTextField.setPreferredSize(new Dimension(300, 45));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jTextField.getText().equals(string)) {
                    jTextField.setText("");
                    jTextField.setForeground(TEXT_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (jTextField.getText().isEmpty()) {
                    jTextField.setForeground(PLACEHOLDER_COLOR);
                    jTextField.setText(string);
                }
            }
        });
        return jTextField;
    }

    private JPasswordField createStyledPasswordField(final String string) {
        final JPasswordField jPasswordField = new JPasswordField(20);
        jPasswordField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPasswordField.setForeground(TEXT_COLOR);
        jPasswordField.setEchoChar('\u0000');
        jPasswordField.setText(string);
        jPasswordField.setForeground(PLACEHOLDER_COLOR);
        jPasswordField.setPreferredSize(new Dimension(300, 45));
        jPasswordField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        jPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).equals(string)) {
                    jPasswordField.setText("");
                    jPasswordField.setEchoChar('\u2022');
                    jPasswordField.setForeground(TEXT_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).isEmpty()) {
                    jPasswordField.setForeground(PLACEHOLDER_COLOR);
                    jPasswordField.setEchoChar('\u0000');
                    jPasswordField.setText(string);
                }
            }
        });
        return jPasswordField;
    }

    private JButton createPrimaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        jButton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        return jButton;
    }

    private JButton createSecondaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jButton.setForeground(PRIMARY_COLOR);
        jButton.setBackground(Color.WHITE);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PRIMARY_COLOR, 1), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void addHoverEffect(final JButton jButton, final Color color, final Color color2) {
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setBackground(color2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setBackground(color);
            }
        });
    }

    private void handleRegister() {
        final String string = this.usernameField.getText().trim();
        final String string2 = String.valueOf(this.passwordField.getPassword());
        String string3 = String.valueOf(this.confirmPasswordField.getPassword());
        final String string4 = this.fullNameField.getText().trim();
        final String string5 = this.emailField.getText().trim();
        final String string6 = this.addressField.getText().trim();
        final String string7 = (String)this.genderCombo.getSelectedItem();
        final java.util.Date date = (java.util.Date)this.birthDateSpinner.getValue();
        if (!this.validateInputs(string, string2, string3, string4, string5, string6, date)) {
            return;
        }
        this.registerButton.setEnabled(false);
        this.registerButton.setText("\u0110ang \u0111\u0103ng k\u00fd...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                UserService userService = new UserService();
                Date date2 = new Date(date.getTime());
                return userService.registerUser(string, string2, string4, string5, string6, date2, string7);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        JOptionPane.showMessageDialog(RegisterFrame.this, "\u0110\u0103ng k\u00fd th\u00e0nh c\u00f4ng!\nB\u1ea1n c\u00f3 th\u1ec3 \u0111\u0103ng nh\u1eadp ngay b\u00e2y gi\u1edd.", "Th\u00e0nh c\u00f4ng", 1);
                        RegisterFrame.this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(RegisterFrame.this, "\u0110\u0103ng k\u00fd th\u1ea5t b\u1ea1i!\nT\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email \u0111\u00e3 t\u1ed3n t\u1ea1i.", "L\u1ed7i", 0);
                        RegisterFrame.this.registerButton.setEnabled(true);
                        RegisterFrame.this.registerButton.setText("\u0110\u0102NG K\u00dd");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(RegisterFrame.this, "L\u1ed7i k\u1ebft n\u1ed1i database!\n" + exception.getMessage(), "L\u1ed7i", 0);
                    RegisterFrame.this.registerButton.setEnabled(true);
                    RegisterFrame.this.registerButton.setText("\u0110\u0102NG K\u00dd");
                }
            }
        };
        swingWorker.execute();
    }

    private boolean validateInputs(String string, String string2, String string3, String string4, String string5, String string6, java.util.Date date) {
        if (string.equals("T\u00ean \u0111\u0103ng nh\u1eadp") || string.isEmpty()) {
            this.showError("Vui l\u00f2ng nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp!");
            return false;
        }
        if (string2.equals("M\u1eadt kh\u1ea9u") || string2.isEmpty()) {
            this.showError("Vui l\u00f2ng nh\u1eadp m\u1eadt kh\u1ea9u!");
            return false;
        }
        if (string3.equals("X\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u") || string3.isEmpty()) {
            this.showError("Vui l\u00f2ng x\u00e1c nh\u1eadn m\u1eadt kh\u1ea9u!");
            return false;
        }
        if (string4.equals("H\u1ecd v\u00e0 t\u00ean") || string4.isEmpty()) {
            this.showError("Vui l\u00f2ng nh\u1eadp h\u1ecd v\u00e0 t\u00ean!");
            return false;
        }
        if (string5.equals("Email") || string5.isEmpty()) {
            this.showError("Vui l\u00f2ng nh\u1eadp email!");
            return false;
        }
        if (string6.equals("\u0110\u1ecba ch\u1ec9") || string6.isEmpty()) {
            this.showError("Vui l\u00f2ng nh\u1eadp \u0111\u1ecba ch\u1ec9!");
            return false;
        }
        if (!string.matches("^[a-zA-Z0-9_]{3,20}$")) {
            this.showError("T\u00ean \u0111\u0103ng nh\u1eadp ph\u1ea3i t\u1eeb 3-20 k\u00fd t\u1ef1, ch\u1ec9 ch\u1ee9a ch\u1eef, s\u1ed1 v\u00e0 d\u1ea5u g\u1ea1ch d\u01b0\u1edbi!");
            return false;
        }
        if (string2.length() < 6) {
            this.showError("M\u1eadt kh\u1ea9u ph\u1ea3i c\u00f3 \u00edt nh\u1ea5t 6 k\u00fd t\u1ef1!");
            return false;
        }
        if (!string2.equals(string3)) {
            this.showError("M\u1eadt kh\u1ea9u x\u00e1c nh\u1eadn kh\u00f4ng kh\u1edbp!");
            return false;
        }
        if (!string5.matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$")) {
            this.showError("Email kh\u00f4ng h\u1ee3p l\u1ec7!");
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        int n = calendar.get(1) - calendar2.get(1);
        if (calendar.get(6) < calendar2.get(6)) {
            --n;
        }
        if (n < 13) {
            this.showError("B\u1ea1n ph\u1ea3i t\u1eeb 13 tu\u1ed5i tr\u1edf l\u00ean \u0111\u1ec3 \u0111\u0103ng k\u00fd!");
            return false;
        }
        if (n > 100) {
            this.showError("Ng\u00e0y sinh kh\u00f4ng h\u1ee3p l\u1ec7!");
            return false;
        }
        return true;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i nh\u1eadp li\u1ec7u", 2);
    }

    public static void main(String[] stringArray) {
        UIHelper.setupLookAndFeel();
        SwingUtilities.invokeLater(() -> new RegisterFrame().setVisible(true));
    }
}

