/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import user.gui.RegisterFrame;
import user.gui.ResetPasswordFrame;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class LoginFrame
extends JFrame {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color PRIMARY_DARK = new Color(0, 102, 204);
    private static final Color BACKGROUND_COLOR = new Color(245, 247, 250);
    private static final Color TEXT_COLOR = new Color(51, 51, 51);
    private static final Color PLACEHOLDER_COLOR = new Color(153, 153, 153);
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JButton loginButton;
    private JButton registerButton;
    private JButton forgotPasswordButton;
    private JLabel titleLabel;
    private JLabel welcomeLabel;

    public LoginFrame() {
        System.out.println("=== LoginFrame Constructor Started ===");
        this.initializeComponents();
        this.setupLayout();
        this.applyModernStyle();
        System.out.println("=== LoginFrame Constructor Finished ===");
    }

    private void initializeComponents() {
        this.setTitle("\u0110\u0103ng nh\u1eadp - InstantChat");
        this.setDefaultCloseOperation(3);
        this.setSize(450, 600);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.getContentPane().setBackground(BACKGROUND_COLOR);
        this.titleLabel = new JLabel("InstantChat", 0);
        this.titleLabel.setFont(UIHelper.getFont(1, 32));
        this.titleLabel.setForeground(PRIMARY_COLOR);
        this.welcomeLabel = new JLabel("\u0110\u0103ng nh\u1eadp \u0111\u1ec3 ti\u1ebfp t\u1ee5c", 0);
        this.welcomeLabel.setFont(UIHelper.getFont(0, 14));
        this.welcomeLabel.setForeground(TEXT_COLOR);
        this.usernameField = this.createStyledTextField("T\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email");
        this.passwordField = this.createStyledPasswordField("M\u1eadt kh\u1ea9u");
        this.loginButton = this.createPrimaryButton("\u0110\u0102NG NH\u1eacP");
        System.out.println("DEBUG: loginButton created = " + String.valueOf(this.loginButton));
        this.loginButton.addActionListener(actionEvent -> {
            System.out.println(">>> LOGIN BUTTON CLICKED <<<");
            this.handleLogin();
        });
        System.out.println("DEBUG: loginButton listener added");
        this.registerButton = this.createSecondaryButton("\u0110\u0103ng k\u00fd t\u00e0i kho\u1ea3n");
        this.registerButton.addActionListener(actionEvent -> {
            System.out.println(">>> REGISTER BUTTON CLICKED <<<");
            this.handleRegister();
        });
        this.forgotPasswordButton = this.createLinkButton("Qu\u00ean m\u1eadt kh\u1ea9u?");
        this.forgotPasswordButton.addActionListener(actionEvent -> this.handleForgotPassword());
    }

    private void setupLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(50, 40, 5, 40);
        this.add((Component)this.titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 40, 30, 40);
        this.add((Component)this.welcomeLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add((Component)this.usernameField, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.passwordField, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 40, 15, 40);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setOpaque(false);
        jPanel.add(this.forgotPasswordButton);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 40, 15, 40);
        this.add((Component)this.loginButton, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add((Component)this.createDividerPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(10, 40, 40, 40);
        this.add((Component)this.registerButton, gridBagConstraints);
    }

    private void applyModernStyle() {
        this.addHoverEffect(this.loginButton, PRIMARY_COLOR, PRIMARY_DARK);
        this.addHoverEffect(this.registerButton, Color.WHITE, new Color(240, 240, 240));
    }

    private JTextField createStyledTextField(final String string) {
        final JTextField jTextField = new JTextField(20);
        jTextField.setFont(UIHelper.getFont(0, 14));
        jTextField.setForeground(TEXT_COLOR);
        jTextField.setText(string);
        jTextField.setForeground(PLACEHOLDER_COLOR);
        jTextField.setPreferredSize(new Dimension(300, 45));
        jTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (jTextField.getText().equals(string)) {
                    jTextField.setText("");
                    jTextField.setForeground(TEXT_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (jTextField.getText().isEmpty()) {
                    jTextField.setForeground(PLACEHOLDER_COLOR);
                    jTextField.setText(string);
                }
            }
        });
        return jTextField;
    }

    private JPasswordField createStyledPasswordField(final String string) {
        final JPasswordField jPasswordField = new JPasswordField(20);
        jPasswordField.setFont(UIHelper.getFont(0, 14));
        jPasswordField.setForeground(TEXT_COLOR);
        jPasswordField.setEchoChar('\u0000');
        jPasswordField.setText(string);
        jPasswordField.setForeground(PLACEHOLDER_COLOR);
        jPasswordField.setPreferredSize(new Dimension(300, 45));
        jPasswordField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        jPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).equals(string)) {
                    jPasswordField.setText("");
                    jPasswordField.setEchoChar('\u2022');
                    jPasswordField.setForeground(TEXT_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (String.valueOf(jPasswordField.getPassword()).isEmpty()) {
                    jPasswordField.setForeground(PLACEHOLDER_COLOR);
                    jPasswordField.setEchoChar('\u0000');
                    jPasswordField.setText(string);
                }
            }
        });
        return jPasswordField;
    }

    private JButton createPrimaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(1, 14));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        if (UIHelper.isMac()) {
            jButton.putClientProperty("JButton.buttonType", "roundRect");
        }
        return jButton;
    }

    private JButton createSecondaryButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(0, 14));
        jButton.setForeground(PRIMARY_COLOR);
        jButton.setBackground(Color.WHITE);
        jButton.setPreferredSize(new Dimension(300, 45));
        jButton.setOpaque(true);
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PRIMARY_COLOR, 1), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        if (UIHelper.isMac()) {
            jButton.putClientProperty("JButton.buttonType", "roundRect");
        }
        return jButton;
    }

    private JButton createLinkButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(UIHelper.getFont(0, 12));
        jButton.setForeground(PRIMARY_COLOR);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        if (UIHelper.isMac()) {
            jButton.putClientProperty("JButton.buttonType", "text");
        }
        return jButton;
    }

    private JPanel createDividerPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(120, 1));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jSeparator, gridBagConstraints);
        JLabel jLabel = new JLabel(" ho\u1eb7c ");
        jLabel.setFont(UIHelper.getFont(0, 12));
        jLabel.setForeground(PLACEHOLDER_COLOR);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JSeparator jSeparator2 = new JSeparator();
        jSeparator2.setPreferredSize(new Dimension(120, 1));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jSeparator2, gridBagConstraints);
        return jPanel;
    }

    private void addHoverEffect(final JButton jButton, final Color color, final Color color2) {
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setBackground(color2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setBackground(color);
            }
        });
    }

    private void handleLogin() {
        final String string = this.usernameField.getText().trim();
        final String string2 = String.valueOf(this.passwordField.getPassword());
        System.out.println("DEBUG: handleLogin called");
        System.out.println("DEBUG: usernameOrEmail = '" + string + "'");
        if (string.equals("T\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email") || string.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp t\u00ean \u0111\u0103ng nh\u1eadp ho\u1eb7c email!", "Th\u00f4ng b\u00e1o", 2);
            return;
        }
        if (string2.equals("M\u1eadt kh\u1ea9u") || string2.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp m\u1eadt kh\u1ea9u!", "Th\u00f4ng b\u00e1o", 2);
            return;
        }
        this.loginButton.setEnabled(false);
        this.loginButton.setText("\u0110ang \u0111\u0103ng nh\u1eadp...");
        SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

            @Override
            protected Map<String, Object> doInBackground() throws Exception {
                UserService userService = new UserService();
                return userService.login(string, string2);
            }

            @Override
            protected void done() {
                try {
                    Map map = (Map)this.get();
                    if (((Boolean)map.get("success")).booleanValue()) {
                        String string3 = (String)map.get("username");
                        String string22 = (String)map.get("full_name");
                        JOptionPane.showMessageDialog(LoginFrame.this, "\u0110\u0103ng nh\u1eadp th\u00e0nh c\u00f4ng!\nCh\u00e0o m\u1eebng " + string22, "Th\u00e0nh c\u00f4ng", 1);
                        LoginFrame.this.dispose();
                        SwingUtilities.invokeLater(() -> {
                            ZaloMainFrame zaloMainFrame = new ZaloMainFrame(string3);
                            zaloMainFrame.setVisible(true);
                        });
                    } else {
                        String string4 = (String)map.get("message");
                        JOptionPane.showMessageDialog(LoginFrame.this, string4, "\u0110\u0103ng nh\u1eadp th\u1ea5t b\u1ea1i", 0);
                        LoginFrame.this.loginButton.setEnabled(true);
                        LoginFrame.this.loginButton.setText("\u0110\u0102NG NH\u1eacP");
                        LoginFrame.this.passwordField.setText("");
                        LoginFrame.this.passwordField.setForeground(PLACEHOLDER_COLOR);
                        LoginFrame.this.passwordField.setEchoChar('\u0000');
                        LoginFrame.this.passwordField.setText("M\u1eadt kh\u1ea9u");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(LoginFrame.this, "L\u1ed7i k\u1ebft n\u1ed1i \u0111\u1ebfn database!\n" + exception.getMessage(), "L\u1ed7i", 0);
                    LoginFrame.this.loginButton.setEnabled(true);
                    LoginFrame.this.loginButton.setText("\u0110\u0102NG NH\u1eacP");
                }
            }
        };
        swingWorker.execute();
    }

    private void handleRegister() {
        SwingUtilities.invokeLater(() -> {
            RegisterFrame registerFrame = new RegisterFrame();
            registerFrame.setVisible(true);
        });
    }

    private void handleForgotPassword() {
        String string = JOptionPane.showInputDialog(this, "Nh\u1eadp email c\u1ee7a b\u1ea1n \u0111\u1ec3 kh\u00f4i ph\u1ee5c m\u1eadt kh\u1ea9u:", "Qu\u00ean m\u1eadt kh\u1ea9u", 3);
        if (string != null && !string.trim().isEmpty()) {
            if (!(string = string.trim()).matches("^[A-Za-z0-9+_.-]+@[A-Za-z0-9.-]+$")) {
                JOptionPane.showMessageDialog(this, "Email kh\u00f4ng h\u1ee3p l\u1ec7! Vui l\u00f2ng nh\u1eadp \u0111\u00fang \u0111\u1ecbnh d\u1ea1ng.", "L\u1ed7i", 0);
                return;
            }
            final JDialog jDialog = new JDialog(this, "\u0110ang x\u1eed l\u00fd...", true);
            JLabel jLabel = new JLabel("\u0110ang g\u1eedi m\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi...", 0);
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
            jLabel.setBorder(BorderFactory.createEmptyBorder(20, 40, 20, 40));
            jDialog.add(jLabel);
            jDialog.setSize(300, 120);
            jDialog.setLocationRelativeTo(this);
            jDialog.setDefaultCloseOperation(0);
            final String string2 = string;
            SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

                @Override
                protected Map<String, Object> doInBackground() throws Exception {
                    UserService userService = new UserService();
                    return userService.sendResetPasswordEmail(string2);
                }

                @Override
                protected void done() {
                    jDialog.dispose();
                    try {
                        Map map = (Map)this.get();
                        if (((Boolean)map.get("success")).booleanValue()) {
                            String string = (String)map.get("temporary_password");
                            JOptionPane.showMessageDialog(LoginFrame.this, "M\u1eadt kh\u1ea9u t\u1ea1m th\u1eddi \u0111\u00e3 \u0111\u01b0\u1ee3c g\u1eedi \u0111\u1ebfn email!\n\nVui l\u00f2ng ki\u1ec3m tra email v\u00e0 l\u00e0m theo h\u01b0\u1edbng d\u1eabn.", "Th\u00e0nh c\u00f4ng", 1);
                            SwingUtilities.invokeLater(() -> {
                                ResetPasswordFrame resetPasswordFrame = new ResetPasswordFrame(string2, string);
                                resetPasswordFrame.setVisible(true);
                            });
                        } else {
                            JOptionPane.showMessageDialog(LoginFrame.this, map.get("message"), "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(LoginFrame.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                    }
                }
            };
            swingWorker.execute();
            jDialog.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("=================================");
        System.out.println("  INSTANT CHAT - CLIENT ONLY");
        System.out.println("=================================");
        System.out.println("\u26a0\ufe0f  L\u01b0u \u00fd: ChatServer ph\u1ea3i \u0111\u00e3 ch\u1ea1y \u1edf Main.java");
        System.out.println("=================================");
        UIHelper.setupLookAndFeel();
        SwingUtilities.invokeLater(() -> {
            LoginFrame loginFrame = new LoginFrame();
            loginFrame.setVisible(true);
            System.out.println("\u2705 LoginFrame started (client mode)");
            System.out.println("=================================");
        });
    }
}

