/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.GroupService;

public class GroupListPanel
extends JPanel {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(245, 247, 250);
    private ZaloMainFrame mainFrame;
    private GroupService groupService;
    private JPanel groupsContainer;
    private JScrollPane scrollPane;
    private JTextField searchField;
    private List<Map<String, Object>> allGroups = new ArrayList<Map<String, Object>>();

    public GroupListPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.groupService = new GroupService();
        this.initComponents();
        this.loadGroups();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        JPanel jPanel = new JPanel(new BorderLayout(8, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(220, 220, 220)), new EmptyBorder(12, 12, 12, 12)));
        JPanel jPanel2 = this.createSearchBar();
        jPanel.add((Component)jPanel2, "Center");
        this.groupsContainer = new JPanel();
        this.groupsContainer.setLayout(new BoxLayout(this.groupsContainer, 1));
        this.groupsContainer.setBackground(BG_COLOR);
        this.scrollPane = new JScrollPane(this.groupsContainer);
        this.scrollPane.setBorder(null);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)jPanel, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    private JPanel createSearchBar() {
        Accessible accessible;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setPreferredSize(new Dimension(240, 38));
        this.searchField = new JTextField();
        this.searchField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.searchField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1, true), BorderFactory.createEmptyBorder(8, 38, 8, 10)));
        this.searchField.setBackground(new Color(245, 245, 245));
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GroupListPanel.this.performSearch();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 8));
        jPanel2.setOpaque(false);
        jPanel2.setCursor(new Cursor(12));
        jPanel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GroupListPanel.this.performSearch();
            }
        });
        try {
            accessible = new ImageIcon("icons/search.png");
            Image image = ((ImageIcon)accessible).getImage().getScaledInstance(18, 18, 4);
            JLabel jLabel = new JLabel(new ImageIcon(image));
            jPanel2.add(jLabel);
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel("Tim");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jPanel2.add(jLabel);
        }
        accessible = new JLayeredPane();
        ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(240, 38));
        this.searchField.setBounds(0, 0, 240, 38);
        jPanel2.setBounds(0, 0, 40, 38);
        ((Container)((Object)accessible)).add((Component)this.searchField, JLayeredPane.DEFAULT_LAYER);
        ((Container)((Object)accessible)).add((Component)jPanel2, JLayeredPane.PALETTE_LAYER);
        jPanel.add((Component)((Object)accessible), "Center");
        return jPanel;
    }

    private void performSearch() {
        String string = this.searchField.getText().trim();
        if (string.isEmpty()) {
            this.displayGroups(this.allGroups);
        } else {
            this.filterGroups(string);
        }
    }

    private void filterGroups(String string) {
        if (this.allGroups == null || this.allGroups.isEmpty()) {
            return;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string2 = string.toLowerCase();
        for (Map<String, Object> map : this.allGroups) {
            String string3 = (String)map.get("group_name");
            if (string3 == null || !string3.toLowerCase().contains(string2)) continue;
            arrayList.add(map);
        }
        this.displayGroups(arrayList);
    }

    public void refreshGroupList() {
        this.loadGroups();
    }

    public void loadGroups() {
        this.groupsContainer.removeAll();
        JLabel jLabel = new JLabel("<html><center>\ud83d\udd04<br><br>\u0110ang t\u1ea3i danh s\u00e1ch nh\u00f3m...</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(new Color(120, 120, 120));
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
        this.groupsContainer.add(jLabel);
        this.groupsContainer.revalidate();
        this.groupsContainer.repaint();
        System.out.println("\ud83d\udd0d [GroupListPanel] Loading groups for user: " + this.mainFrame.getUsername());
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                try {
                    System.out.println("\u23f3 [GroupListPanel] Calling groupService.getUserGroups()...");
                    List<Map<String, Object>> list = GroupListPanel.this.groupService.getUserGroups(GroupListPanel.this.mainFrame.getUsername());
                    System.out.println("\u2705 [GroupListPanel] Got " + (list != null ? list.size() : 0) + " groups");
                    return list;
                }
                catch (Exception exception) {
                    System.err.println("\u274c [GroupListPanel] Error in doInBackground: " + exception.getMessage());
                    exception.printStackTrace();
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    List list;
                    GroupListPanel.this.allGroups = list = (List)this.get();
                    System.out.println("\ud83d\udcca [GroupListPanel] Displaying " + (list != null ? list.size() : 0) + " groups");
                    GroupListPanel.this.displayGroups(list);
                }
                catch (Exception exception) {
                    System.err.println("\u274c [GroupListPanel] Error in done(): " + exception.getMessage());
                    exception.printStackTrace();
                    GroupListPanel.this.groupsContainer.removeAll();
                    JLabel jLabel = new JLabel("<html><center>\u274c<br><br>L\u1ed7i khi t\u1ea3i danh s\u00e1ch nh\u00f3m<br>Vui l\u00f2ng th\u1eed l\u1ea1i sau</center></html>");
                    jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
                    jLabel.setForeground(Color.RED);
                    jLabel.setAlignmentX(0.5f);
                    jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
                    GroupListPanel.this.groupsContainer.add(jLabel);
                    GroupListPanel.this.groupsContainer.revalidate();
                    GroupListPanel.this.groupsContainer.repaint();
                }
            }
        };
        swingWorker.execute();
    }

    private void displayGroups(List<Map<String, Object>> list) {
        this.groupsContainer.removeAll();
        if (list == null || list.isEmpty()) {
            String string = this.searchField.getText().trim();
            JLabel jLabel = !string.isEmpty() ? new JLabel("<html><center>Kh\u00f4ng t\u00ecm th\u1ea5y nh\u00f3m<br>cho '" + string + "'</center></html>") : new JLabel("Ch\u01b0a c\u00f3 nh\u00f3m n\u00e0o");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 2, 14));
            jLabel.setForeground(new Color(150, 150, 150));
            jLabel.setAlignmentX(0.5f);
            jLabel.setBorder(new EmptyBorder(50, 0, 0, 0));
            this.groupsContainer.add(jLabel);
        } else {
            for (Map<String, Object> map : list) {
                GroupItemPanel groupItemPanel = new GroupItemPanel(map);
                this.groupsContainer.add(groupItemPanel);
            }
        }
        this.groupsContainer.revalidate();
        this.groupsContainer.repaint();
    }

    private class GroupItemPanel
    extends JPanel {
        private Map<String, Object> groupData;
        private static final Color ENCRYPTED_COLOR = new Color(0, 150, 80);

        public GroupItemPanel(Map<String, Object> map) {
            this.groupData = map;
            this.setLayout(new BorderLayout(12, 0));
            this.setBackground(Color.WHITE);
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(240, 240, 240)), new EmptyBorder(10, 15, 10, 15)));
            this.setCursor(new Cursor(12));
            boolean bl = map.get("is_encrypted") != null && (Boolean)map.get("is_encrypted") != false;
            JLabel jLabel = new JLabel();
            jLabel.setPreferredSize(new Dimension(50, 50));
            jLabel.setOpaque(true);
            jLabel.setBackground(bl ? ENCRYPTED_COLOR : PRIMARY_COLOR);
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            String string = (String)map.get("group_name");
            String string2 = this.getGroupInitials(string);
            jLabel.setText(string2);
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
            jLabel.setForeground(Color.WHITE);
            final JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBackground(Color.WHITE);
            JLabel jLabel2 = new JLabel(string);
            jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
            jLabel2.setForeground(bl ? ENCRYPTED_COLOR : new Color(50, 50, 50));
            if (bl) {
                jLabel2.setToolTipText("Nh\u00f3m m\u00e3 h\u00f3a \u0111\u1ea7u cu\u1ed1i (E2E)");
            }
            String string3 = (String)map.get("role");
            int n = ((Number)map.get("member_count")).intValue();
            String string4 = n + " th\u00e0nh vi\u00ean";
            if ("admin".equals(string3)) {
                string4 = "Qu\u1ea3n tr\u1ecb vi\u00ean \u2022 " + string4;
            }
            if (bl) {
                string4 = "E2E \u2022 " + string4;
            }
            JLabel jLabel3 = new JLabel(string4);
            jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
            jLabel3.setForeground(new Color(120, 120, 120));
            jPanel.add(jLabel2);
            jPanel.add(Box.createVerticalStrut(4));
            jPanel.add(jLabel3);
            this.add((Component)jLabel, "West");
            this.add((Component)jPanel, "Center");
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    GroupItemPanel.this.openGroupChat();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    GroupItemPanel.this.setBackground(new Color(240, 245, 250));
                    jPanel.setBackground(new Color(240, 245, 250));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    GroupItemPanel.this.setBackground(Color.WHITE);
                    jPanel.setBackground(Color.WHITE);
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        GroupItemPanel.this.showGroupMenu(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }

        private String getGroupInitials(String string) {
            if (string == null || string.isEmpty()) {
                return "G";
            }
            String[] stringArray = string.trim().split("\\s+");
            if (stringArray.length == 1) {
                return stringArray[0].substring(0, Math.min(2, stringArray[0].length())).toUpperCase();
            }
            return (stringArray[0].substring(0, 1) + stringArray[stringArray.length - 1].substring(0, 1)).toUpperCase();
        }

        private void openGroupChat() {
            int n = ((Number)this.groupData.get("id")).intValue();
            String string = (String)this.groupData.get("group_name");
            String string2 = (String)this.groupData.get("role");
            boolean bl = "admin".equals(string2);
            boolean bl2 = this.groupData.get("is_encrypted") != null && (Boolean)this.groupData.get("is_encrypted") != false;
            GroupListPanel.this.mainFrame.openGroupChat(n, string, bl, bl2);
        }

        private void showGroupMenu(int n, int n2) {
            JMenuItem jMenuItem;
            int n3 = ((Number)this.groupData.get("id")).intValue();
            String string = (String)this.groupData.get("role");
            boolean bl = "admin".equals(string);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.setBackground(Color.WHITE);
            jPopupMenu.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220)));
            JMenuItem jMenuItem2 = this.createMenuItem("Th\u00f4ng tin nh\u00f3m");
            jMenuItem2.addActionListener(actionEvent -> this.showGroupInfo());
            jPopupMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = this.createMenuItem("Th\u00eam th\u00e0nh vi\u00ean");
            jMenuItem3.addActionListener(actionEvent -> this.showAddMemberDialog());
            jPopupMenu.add(jMenuItem3);
            if (bl) {
                jPopupMenu.addSeparator();
                jMenuItem = this.createMenuItem("\u0110\u1ed5i t\u00ean nh\u00f3m");
                jMenuItem.addActionListener(actionEvent -> this.showRenameDialog());
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem4 = this.createMenuItem("Qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean");
                jMenuItem4.addActionListener(actionEvent -> this.showManageMembersDialog());
                jPopupMenu.add(jMenuItem4);
            }
            jPopupMenu.addSeparator();
            jMenuItem = this.createMenuItem("R\u1eddi nh\u00f3m");
            jMenuItem.setForeground(Color.RED);
            jMenuItem.addActionListener(actionEvent -> this.handleLeaveGroup());
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(this, n, n2);
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
            jMenuItem.setBorder(new EmptyBorder(8, 12, 8, 12));
            return jMenuItem;
        }

        private void showGroupInfo() {
            final int n = ((Number)this.groupData.get("id")).intValue();
            SwingWorker<Map<String, Object>, Void> swingWorker = new SwingWorker<Map<String, Object>, Void>(){

                @Override
                protected Map<String, Object> doInBackground() {
                    return GroupListPanel.this.groupService.getGroupInfo(n);
                }

                @Override
                protected void done() {
                    try {
                        Map map = (Map)this.get();
                        if (map != null) {
                            String string = (String)map.get("group_name");
                            String string2 = (String)map.get("created_by");
                            int n2 = ((Number)map.get("member_count")).intValue();
                            String string3 = "T\u00ean nh\u00f3m: " + string + "\n";
                            string3 = string3 + "Ng\u01b0\u1eddi t\u1ea1o: " + string2 + "\n";
                            string3 = string3 + "S\u1ed1 th\u00e0nh vi\u00ean: " + n2;
                            JOptionPane.showMessageDialog(GroupListPanel.this, string3, "Th\u00f4ng tin nh\u00f3m", 1);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }

        private void showRenameDialog() {
            final int n = ((Number)this.groupData.get("id")).intValue();
            String string = (String)this.groupData.get("group_name");
            final String string2 = JOptionPane.showInputDialog(GroupListPanel.this, "Nh\u1eadp t\u00ean nh\u00f3m m\u1edbi:", string);
            if (string2 != null && !string2.trim().isEmpty() && !string2.equals(string)) {
                SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() {
                        return GroupListPanel.this.groupService.renameGroup(n, string2.trim(), GroupListPanel.this.mainFrame.getUsername());
                    }

                    @Override
                    protected void done() {
                        try {
                            boolean bl = (Boolean)this.get();
                            if (bl) {
                                JOptionPane.showMessageDialog(GroupListPanel.this, "\u0110\u1ed5i t\u00ean nh\u00f3m th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                                GroupListPanel.this.loadGroups();
                            } else {
                                JOptionPane.showMessageDialog(GroupListPanel.this, "Kh\u00f4ng th\u1ec3 \u0111\u1ed5i t\u00ean nh\u00f3m. B\u1ea1n ph\u1ea3i l\u00e0 admin!", "L\u1ed7i", 0);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                swingWorker.execute();
            }
        }

        private void showAddMemberDialog() {
            int n = ((Number)this.groupData.get("id")).intValue();
            JOptionPane.showMessageDialog(GroupListPanel.this, "Ch\u1ee9c n\u0103ng th\u00eam th\u00e0nh vi\u00ean \u0111ang \u0111\u01b0\u1ee3c ph\u00e1t tri\u1ec3n...", "Th\u00f4ng b\u00e1o", 1);
        }

        private void showManageMembersDialog() {
            int n = ((Number)this.groupData.get("id")).intValue();
            JOptionPane.showMessageDialog(GroupListPanel.this, "Ch\u1ee9c n\u0103ng qu\u1ea3n l\u00fd th\u00e0nh vi\u00ean \u0111ang \u0111\u01b0\u1ee3c ph\u00e1t tri\u1ec3n...", "Th\u00f4ng b\u00e1o", 1);
        }

        private void handleLeaveGroup() {
            final int n = ((Number)this.groupData.get("id")).intValue();
            String string = (String)this.groupData.get("group_name");
            String string2 = (String)this.groupData.get("role");
            int n2 = JOptionPane.showConfirmDialog(GroupListPanel.this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n r\u1eddi nh\u00f3m \"" + string + "\"?", "X\u00e1c nh\u1eadn", 0, 2);
            if (n2 == 0) {
                if ("admin".equals(string2)) {
                    SwingWorker<Integer, Void> swingWorker = new SwingWorker<Integer, Void>(){

                        @Override
                        protected Integer doInBackground() {
                            return GroupListPanel.this.groupService.countAdmins(n);
                        }

                        @Override
                        protected void done() {
                            try {
                                int n2 = (Integer)this.get();
                                if (n2 <= 1) {
                                    JOptionPane.showMessageDialog(GroupListPanel.this, "Kh\u00f4ng th\u1ec3 r\u1eddi nh\u00f3m v\u00ec b\u1ea1n l\u00e0 admin duy nh\u1ea5t!\nH\u00e3y g\u00e1n quy\u1ec1n admin cho ng\u01b0\u1eddi kh\u00e1c tr\u01b0\u1edbc.", "L\u1ed7i", 0);
                                } else {
                                    GroupItemPanel.this.performLeaveGroup(n);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    };
                    swingWorker.execute();
                } else {
                    this.performLeaveGroup(n);
                }
            }
        }

        private void performLeaveGroup(final int n) {
            SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() {
                    return GroupListPanel.this.groupService.removeMember(n, GroupListPanel.this.mainFrame.getUsername(), GroupListPanel.this.mainFrame.getUsername());
                }

                @Override
                protected void done() {
                    try {
                        boolean bl = (Boolean)this.get();
                        if (bl) {
                            JOptionPane.showMessageDialog(GroupListPanel.this, "\u0110\u00e3 r\u1eddi nh\u00f3m th\u00e0nh c\u00f4ng!", "Th\u00e0nh c\u00f4ng", 1);
                            GroupListPanel.this.loadGroups();
                        } else {
                            JOptionPane.showMessageDialog(GroupListPanel.this, "Kh\u00f4ng th\u1ec3 r\u1eddi nh\u00f3m!", "L\u1ed7i", 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            swingWorker.execute();
        }
    }
}

