/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.gui.UserProfileDialog;
import user.gui.ZaloMainFrame;
import user.service.UserService;

public class FriendListPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private static final Color WHITE = Color.WHITE;
    private static final Color BORDER_COLOR = new Color(230, 230, 230);
    private static final Color TEXT_PRIMARY = new Color(50, 50, 50);
    private static final Color TEXT_SECONDARY = new Color(120, 120, 120);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private JPanel friendsPanel;
    private JTextField searchField;
    private List<Map<String, Object>> allFriends;
    private JLabel titleLabel;
    private JButton sortButton;
    private JButton filterButton;
    private boolean sortAscending = true;
    private String currentFilter = "all";

    public FriendListPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.initializeUI();
        this.loadFriends();
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        this.add((Component)this.createHeader(), "North");
        this.friendsPanel = new JPanel();
        this.friendsPanel.setLayout(new BoxLayout(this.friendsPanel, 1));
        this.friendsPanel.setBackground(BG_COLOR);
        JScrollPane jScrollPane = new JScrollPane(this.friendsPanel);
        jScrollPane.setBorder(null);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)jScrollPane, "Center");
    }

    private JPanel createHeader() {
        Object object;
        Accessible accessible;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR), new EmptyBorder(15, 15, 15, 15)));
        this.titleLabel = new JLabel("B\u1ea1n b\u00e8");
        this.titleLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        this.titleLabel.setForeground(TEXT_PRIMARY);
        jPanel.add((Component)this.titleLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(WHITE);
        jPanel2.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.searchField = new JTextField();
        this.searchField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.searchField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(8, 12, 8, 12)));
        this.searchField.setBackground(new Color(245, 245, 245));
        JLabel jLabel = new JLabel();
        try {
            accessible = new ImageIcon("icons/search.png");
            object = ((ImageIcon)accessible).getImage().getScaledInstance(16, 16, 4);
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            jLabel.setText("\ud83d\udd0d");
        }
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 8));
        accessible = new JPanel(new BorderLayout(5, 0));
        ((JComponent)((Object)accessible)).setBackground(new Color(245, 245, 245));
        ((JComponent)((Object)accessible)).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(8, 12, 8, 12)));
        this.searchField = new JTextField("T\u00ecm b\u1ea1n");
        this.searchField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.searchField.setBorder(null);
        this.searchField.setBackground(new Color(245, 245, 245));
        this.searchField.setForeground(new Color(150, 150, 150));
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (FriendListPanel.this.searchField.getText().equals("T\u00ecm b\u1ea1n")) {
                    FriendListPanel.this.searchField.setText("");
                    FriendListPanel.this.searchField.setForeground(TEXT_PRIMARY);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (FriendListPanel.this.searchField.getText().isEmpty()) {
                    FriendListPanel.this.searchField.setText("T\u00ecm b\u1ea1n");
                    FriendListPanel.this.searchField.setForeground(new Color(150, 150, 150));
                }
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FriendListPanel.this.filterFriends();
            }
        });
        ((Container)((Object)accessible)).add(jLabel, "West");
        ((Container)((Object)accessible)).add(this.searchField, "Center");
        jPanel2.add((Component)((Object)accessible), "Center");
        object = new JPanel(new FlowLayout(0, 10, 0));
        ((JComponent)object).setBackground(WHITE);
        ((JComponent)object).setBorder(new EmptyBorder(12, 0, 0, 0));
        this.sortButton = this.createToolButton("\u2b0d T\u00ean (A-Z)");
        this.filterButton = this.createToolButton("\u2261 T\u1ea5t c\u1ea3");
        this.sortButton.addActionListener(actionEvent -> {
            this.sortAscending = !this.sortAscending;
            this.sortButton.setText(this.sortAscending ? "\u2b0d T\u00ean (A-Z)" : "\u2b0d T\u00ean (Z-A)");
            this.applyFilterAndSort();
        });
        this.filterButton.addActionListener(actionEvent2 -> {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("T\u1ea5t c\u1ea3");
            jMenuItem.addActionListener(actionEvent -> {
                this.currentFilter = "all";
                this.filterButton.setText("\u2261 T\u1ea5t c\u1ea3");
                this.applyFilterAndSort();
            });
            JMenuItem jMenuItem2 = new JMenuItem("\u0110ang ho\u1ea1t \u0111\u1ed9ng");
            jMenuItem2.addActionListener(actionEvent -> {
                this.currentFilter = "online";
                this.filterButton.setText("\u2261 \u0110ang ho\u1ea1t \u0111\u1ed9ng");
                this.applyFilterAndSort();
            });
            JMenuItem jMenuItem3 = new JMenuItem("Kh\u00f4ng ho\u1ea1t \u0111\u1ed9ng");
            jMenuItem3.addActionListener(actionEvent -> {
                this.currentFilter = "offline";
                this.filterButton.setText("\u2261 Kh\u00f4ng ho\u1ea1t \u0111\u1ed9ng");
                this.applyFilterAndSort();
            });
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.show(this.filterButton, 0, this.filterButton.getHeight());
        });
        ((Container)object).add(this.sortButton);
        ((Container)object).add(this.filterButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(WHITE);
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)object, "Center");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JButton createToolButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton.setForeground(TEXT_PRIMARY);
        jButton.setBackground(WHITE);
        jButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1, true), new EmptyBorder(6, 12, 6, 12)));
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void loadFriends() {
        this.friendsPanel.removeAll();
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return FriendListPanel.this.userService.getFriendsList(FriendListPanel.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    FriendListPanel.this.allFriends = (List)this.get();
                    if (FriendListPanel.this.allFriends != null && !FriendListPanel.this.allFriends.isEmpty()) {
                        FriendListPanel.this.titleLabel.setText("B\u1ea1n b\u00e8 (" + FriendListPanel.this.allFriends.size() + ")");
                    } else {
                        FriendListPanel.this.titleLabel.setText("B\u1ea1n b\u00e8 (0)");
                    }
                    FriendListPanel.this.applyFilterAndSort();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    FriendListPanel.this.showEmptyMessage();
                }
            }
        };
        swingWorker.execute();
    }

    private void filterFriends() {
        this.applyFilterAndSort();
    }

    private void displayFriends(List<Map<String, Object>> list) {
        this.friendsPanel.removeAll();
        if (list == null || list.isEmpty()) {
            this.showEmptyMessage();
        } else {
            List<Object> list2 = this.mainFrame.getSocketClient() != null ? this.mainFrame.getSocketClient().getOnlineUsers() : new ArrayList();
            char c = '\u0000';
            for (Map<String, Object> map : list) {
                char c2;
                String string = (String)map.get("full_name");
                if (string == null || string.isEmpty()) {
                    string = (String)map.get("username");
                }
                if ((c2 = Character.toUpperCase(string.charAt(0))) != c) {
                    c = c2;
                    this.friendsPanel.add(this.createSectionHeader(String.valueOf(c)));
                }
                String string2 = (String)map.get("username");
                boolean bl = list2.contains(string2);
                this.friendsPanel.add(this.createFriendItem(map, bl));
            }
        }
        this.friendsPanel.revalidate();
        this.friendsPanel.repaint();
    }

    private JPanel createSectionHeader(String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(BG_COLOR);
        jPanel.setBorder(new EmptyBorder(12, 15, 8, 15));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        jLabel.setForeground(TEXT_SECONDARY);
        jPanel.add((Component)jLabel, "West");
        return jPanel;
    }

    private JPanel createFriendItem(Map<String, Object> map, boolean bl) {
        Object object;
        Accessible accessible;
        final JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        jPanel.setBackground(WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR), new EmptyBorder(12, 15, 12, 15)));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
        jPanel.setCursor(new Cursor(12));
        final String string = (String)map.get("username");
        String string2 = (String)map.get("full_name");
        String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setPreferredSize(new Dimension(50, 50));
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel();
        jLabel.setBounds(0, 0, 50, 50);
        jLabel.setHorizontalAlignment(0);
        try {
            accessible = new ImageIcon("icons/user.png");
            object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            jLabel.setText("[A]");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        }
        jPanel2.add(jLabel);
        if (bl) {
            accessible = new JPanel();
            ((JComponent)((Object)accessible)).setBackground(new Color(68, 214, 44));
            ((Component)((Object)accessible)).setBounds(36, 36, 14, 14);
            ((JComponent)((Object)accessible)).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(WHITE, 2), BorderFactory.createEmptyBorder()));
            jPanel2.add((Component)((Object)accessible));
        }
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(new BoxLayout((Container)((Object)accessible), 1));
        ((JComponent)((Object)accessible)).setOpaque(false);
        object = new JLabel(string3);
        ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 0, 15));
        ((JComponent)object).setForeground(TEXT_PRIMARY);
        JLabel jLabel2 = new JLabel(bl ? "\ud83d\udfe2 \u0110ang ho\u1ea1t \u0111\u1ed9ng" : "\u26aa Kh\u00f4ng ho\u1ea1t \u0111\u1ed9ng");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 12));
        jLabel2.setForeground(TEXT_SECONDARY);
        ((Container)((Object)accessible)).add((Component)object);
        ((Container)((Object)accessible)).add(Box.createVerticalStrut(4));
        ((Container)((Object)accessible)).add(jLabel2);
        JButton jButton = new JButton("\u22ee");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        jButton.setForeground(TEXT_SECONDARY);
        jButton.setPreferredSize(new Dimension(30, 30));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.addActionListener(actionEvent -> this.showFriendMenu(jButton, string, string3));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)((Object)accessible), "Center");
        jPanel.add((Component)jButton, "East");
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setBackground(new Color(245, 247, 250));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setBackground(WHITE);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                FriendListPanel.this.mainFrame.openChat(string);
                SwingUtilities.invokeLater(() -> FriendListPanel.this.mainFrame.switchToTab("chat"));
            }
        });
        return jPanel;
    }

    private void showFriendMenu(JComponent jComponent, String string, String string2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBorder(BorderFactory.createLineBorder(BORDER_COLOR, 1));
        JMenuItem jMenuItem = this.createMenuItem("Nh\u1eafn tin", null);
        jMenuItem.addActionListener(actionEvent -> {
            this.mainFrame.openChat(string);
            this.mainFrame.switchToTab("chat");
        });
        JMenuItem jMenuItem2 = this.createMenuItem("Xem trang c\u00e1 nh\u00e2n", null);
        jMenuItem2.addActionListener(actionEvent -> {
            UserProfileDialog userProfileDialog = new UserProfileDialog((Frame)SwingUtilities.getWindowAncestor(this), string);
            userProfileDialog.setVisible(true);
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem3 = this.createMenuItem("Hu\u1ef7 k\u1ebft b\u1ea1n", new Color(220, 53, 69));
        jMenuItem3.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this, "B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n hu\u1ef7 k\u1ebft b\u1ea1n v\u1edbi " + string2 + "?", "X\u00e1c nh\u1eadn hu\u1ef7 k\u1ebft b\u1ea1n", 0, 2);
            if (n == 0) {
                this.handleUnfriend(string, string2);
            }
        });
        JMenuItem jMenuItem4 = this.createMenuItem("Ch\u1eb7n ng\u01b0\u1eddi n\u00e0y", new Color(220, 53, 69));
        jMenuItem4.addActionListener(actionEvent -> {
            int n = JOptionPane.showConfirmDialog(this, "<html>B\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n ch\u1eb7n " + string2 + "?<br>H\u00e0nh \u0111\u1ed9ng n\u00e0y s\u1ebd:<br>\u2022 Hu\u1ef7 k\u1ebft b\u1ea1n v\u1edbi " + string2 + "<br>\u2022 Ng\u01b0\u1eddi n\u00e0y s\u1ebd kh\u00f4ng th\u1ec3 g\u1eedi l\u1eddi m\u1eddi k\u1ebft b\u1ea1n cho b\u1ea1n n\u1eefa</html>", "X\u00e1c nh\u1eadn ch\u1eb7n", 0, 2);
            if (n == 0) {
                this.handleBlockUser(string, string2);
            }
        });
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.show(jComponent, jComponent.getWidth() - jPopupMenu.getPreferredSize().width, jComponent.getHeight());
    }

    private JMenuItem createMenuItem(String string, Color color) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jMenuItem.setForeground(color != null ? color : TEXT_PRIMARY);
        jMenuItem.setBorder(new EmptyBorder(8, 12, 8, 12));
        jMenuItem.setCursor(new Cursor(12));
        return jMenuItem;
    }

    private void handleUnfriend(final String string, final String string2) {
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return FriendListPanel.this.userService.unfriend(FriendListPanel.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        System.out.println("\ud83d\udc94 \u0110\u00e3 h\u1ee7y k\u1ebft b\u1ea1n v\u1edbi: " + string);
                        FriendListPanel.this.mainFrame.sendUnfriendNotification(string);
                        JOptionPane.showMessageDialog(FriendListPanel.this, "\u0110\u00e3 hu\u1ef7 k\u1ebft b\u1ea1n v\u1edbi " + string2, "Th\u00e0nh c\u00f4ng", 1);
                        FriendListPanel.this.loadFriends();
                        FriendListPanel.this.mainFrame.refreshChatAndFriendList();
                    } else {
                        JOptionPane.showMessageDialog(FriendListPanel.this, "Kh\u00f4ng th\u1ec3 hu\u1ef7 k\u1ebft b\u1ea1n. Vui l\u00f2ng th\u1eed l\u1ea1i.", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(FriendListPanel.this, "\u0110\u00e3 x\u1ea3y ra l\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private void handleBlockUser(final String string, final String string2) {
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() {
                return FriendListPanel.this.userService.blockUser(FriendListPanel.this.mainFrame.getUsername(), string);
            }

            @Override
            protected void done() {
                try {
                    boolean bl = (Boolean)this.get();
                    if (bl) {
                        System.out.println("\ud83d\udeab \u0110\u00e3 ch\u1eb7n: " + string);
                        FriendListPanel.this.mainFrame.sendBlockNotification(string);
                        JOptionPane.showMessageDialog(FriendListPanel.this, "\u0110\u00e3 ch\u1eb7n " + string2, "Th\u00e0nh c\u00f4ng", 1);
                        FriendListPanel.this.loadFriends();
                        FriendListPanel.this.mainFrame.refreshChatAndFriendList();
                    } else {
                        JOptionPane.showMessageDialog(FriendListPanel.this, "Kh\u00f4ng th\u1ec3 ch\u1eb7n ng\u01b0\u1eddi d\u00f9ng. Vui l\u00f2ng th\u1eed l\u1ea1i.", "L\u1ed7i", 0);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(FriendListPanel.this, "\u0110\u00e3 x\u1ea3y ra l\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private JPanel createFriendItemOld(Map<String, Object> map) {
        Object object;
        Accessible accessible;
        final JPanel jPanel = new JPanel(new BorderLayout(12, 0));
        jPanel.setBackground(WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, BORDER_COLOR), new EmptyBorder(12, 15, 12, 15)));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
        jPanel.setCursor(new Cursor(12));
        final String string = (String)map.get("username");
        String string2 = (String)map.get("full_name");
        String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(50, 50));
        jLabel.setHorizontalAlignment(0);
        try {
            accessible = new ImageIcon("icons/user.png");
            object = ((ImageIcon)accessible).getImage().getScaledInstance(40, 40, 4);
            jLabel.setIcon(new ImageIcon((Image)object));
        }
        catch (Exception exception) {
            jLabel.setText("[A]");
            jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 16));
        }
        accessible = new JLabel(string3);
        ((JComponent)((Object)accessible)).setFont(new Font(UIHelper.getDefaultFontName(), 0, 15));
        ((JComponent)((Object)accessible)).setForeground(TEXT_PRIMARY);
        object = new JButton("\u22ee");
        ((JComponent)object).setFont(new Font(UIHelper.getDefaultFontName(), 1, 18));
        ((JComponent)object).setForeground(TEXT_SECONDARY);
        ((JComponent)object).setPreferredSize(new Dimension(30, 30));
        ((AbstractButton)object).setBorderPainted(false);
        ((AbstractButton)object).setContentAreaFilled(false);
        ((AbstractButton)object).setFocusPainted(false);
        ((Component)object).setCursor(new Cursor(12));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)((Object)accessible), "Center");
        jPanel.add((Component)object, "East");
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setBackground(new Color(245, 247, 250));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setBackground(WHITE);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                System.out.println("Open chat with: " + string);
            }
        });
        return jPanel;
    }

    private void showEmptyMessage() {
        this.friendsPanel.removeAll();
        JLabel jLabel = new JLabel("<html><center>\ud83d\ude14<br><br>Ch\u01b0a c\u00f3 b\u1ea1n b\u00e8 n\u00e0o</center></html>");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jLabel.setForeground(TEXT_SECONDARY);
        jLabel.setAlignmentX(0.5f);
        jLabel.setBorder(new EmptyBorder(80, 20, 80, 20));
        this.friendsPanel.add(jLabel);
        this.friendsPanel.revalidate();
        this.friendsPanel.repaint();
    }

    public void refreshOnlineStatus() {
        if (this.allFriends != null && !this.allFriends.isEmpty()) {
            this.applyFilterAndSort();
        }
    }

    public void refreshFriendList() {
        System.out.println("\ud83d\udd04 Refreshing friend list...");
        this.loadFriends();
    }

    private void applyFilterAndSort() {
        if (this.allFriends == null) {
            return;
        }
        String string = this.searchField.getText();
        String string2 = string != null ? string.trim().toLowerCase() : "";
        boolean bl = !string2.isEmpty() && !"t\u00ecm b\u1ea1n".equals(string2);
        List<Object> list = this.mainFrame.getSocketClient() != null ? this.mainFrame.getSocketClient().getOnlineUsers() : new ArrayList();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map3 : this.allFriends) {
            String string3;
            String string4;
            String string5 = (String)map3.get("username");
            String string6 = (String)map3.get("full_name");
            String string7 = string4 = string6 != null && !string6.isEmpty() ? string6 : string5;
            if (bl && !(string3 = string4 != null ? string4.toLowerCase() : "").contains(string2) || "online".equals(this.currentFilter) && !list.contains(string5) || "offline".equals(this.currentFilter) && list.contains(string5)) continue;
            arrayList.add(map3);
        }
        Comparator comparator = (map, map2) -> {
            String string = (String)map.get("full_name");
            String string2 = (String)map2.get("full_name");
            if (string == null || string.isEmpty()) {
                string = (String)map.get("username");
            }
            if (string2 == null || string2.isEmpty()) {
                string2 = (String)map2.get("username");
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            return string.compareToIgnoreCase(string2);
        };
        arrayList.sort(this.sortAscending ? comparator : comparator.reversed());
        this.displayFriends(arrayList);
    }
}

