/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;
import user.service.GroupService;
import user.service.UserService;

public class CreateGroupDialog
extends JDialog {
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final Color BG_COLOR = new Color(245, 247, 250);
    private static final Color ENCRYPTED_COLOR = new Color(0, 150, 80);
    private ZaloMainFrame mainFrame;
    private UserService userService;
    private GroupService groupService;
    private JTextField groupNameField;
    private JTextArea descriptionArea;
    private JList<CheckableItem> friendsList;
    private DefaultListModel<CheckableItem> friendsListModel;
    private JCheckBox encryptedCheckbox;
    private JButton createButton;
    private JButton cancelButton;
    private List<Map<String, Object>> allFriends;

    public CreateGroupDialog(ZaloMainFrame zaloMainFrame) {
        super(zaloMainFrame, "T\u1ea1o nh\u00f3m chat m\u1edbi", true);
        this.mainFrame = zaloMainFrame;
        this.userService = new UserService();
        this.groupService = new GroupService();
        this.initComponents();
        this.loadFriends();
    }

    private void initComponents() {
        this.setSize(500, 650);
        this.setLocationRelativeTo(this.mainFrame);
        this.setResizable(false);
        this.getContentPane().setBackground(BG_COLOR);
        this.setLayout(new BorderLayout(0, 15));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        JLabel jLabel = new JLabel("T\u1ea1o nh\u00f3m chat m\u1edbi");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 20));
        jLabel.setForeground(PRIMARY_COLOR);
        JLabel jLabel2 = new JLabel("Ch\u1ecdn t\u1ed1i thi\u1ec3u 1 b\u1ea1n b\u00e8 \u0111\u1ec3 t\u1ea1o nh\u00f3m");
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jLabel2.setForeground(new Color(120, 120, 120));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jLabel2);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(BG_COLOR);
        jPanel3.setBorder(new EmptyBorder(0, 20, 20, 20));
        JPanel jPanel4 = this.createFieldPanel("T\u00ean nh\u00f3m:");
        this.groupNameField = new JTextField();
        this.groupNameField.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.groupNameField.setPreferredSize(new Dimension(440, 40));
        this.groupNameField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1), new EmptyBorder(8, 12, 8, 12)));
        jPanel4.add(this.groupNameField);
        JPanel jPanel5 = this.createFieldPanel("M\u00f4 t\u1ea3 (t\u00f9y ch\u1ecdn):");
        this.descriptionArea = new JTextArea(3, 20);
        this.descriptionArea.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setBorder(new EmptyBorder(8, 12, 8, 12));
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea);
        jScrollPane.setPreferredSize(new Dimension(440, 80));
        jScrollPane.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1));
        jPanel5.add(jScrollPane);
        JPanel jPanel6 = this.createEncryptionPanel();
        JPanel jPanel7 = this.createFieldPanel("Ch\u1ecdn th\u00e0nh vi\u00ean:");
        this.friendsListModel = new DefaultListModel();
        this.friendsList = new JList<CheckableItem>(this.friendsListModel);
        this.friendsList.setCellRenderer(new CheckBoxListRenderer());
        this.friendsList.setSelectionMode(2);
        this.friendsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = CreateGroupDialog.this.friendsList.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    CheckableItem checkableItem;
                    checkableItem.setSelected(!(checkableItem = CreateGroupDialog.this.friendsListModel.getElementAt(n)).isSelected());
                    CreateGroupDialog.this.friendsList.repaint();
                }
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.friendsList);
        jScrollPane2.setPreferredSize(new Dimension(440, 220));
        jScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(220, 220, 220), 1));
        jPanel7.add(jScrollPane2);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jPanel6);
        jPanel3.add(Box.createVerticalStrut(15));
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(2, 10, 15));
        jPanel8.setBackground(Color.WHITE);
        jPanel8.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(220, 220, 220)));
        this.cancelButton = this.createButton("H\u1ee7y", Color.WHITE, new Color(100, 100, 100));
        this.cancelButton.addActionListener(actionEvent -> this.dispose());
        this.createButton = this.createButton("T\u1ea1o nh\u00f3m", PRIMARY_COLOR, Color.WHITE);
        this.createButton.addActionListener(actionEvent -> this.handleCreateGroup());
        jPanel8.add(this.cancelButton);
        jPanel8.add(this.createButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel8, "South");
    }

    private JPanel createEncryptionPanel() {
        Accessible accessible;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(BG_COLOR);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setBackground(new Color(240, 255, 240));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(ENCRYPTED_COLOR, 1, true), new EmptyBorder(10, 12, 10, 12)));
        JLabel jLabel = new JLabel();
        try {
            accessible = new ImageIcon("icons/padlock.png");
            Image image = ((ImageIcon)accessible).getImage().getScaledInstance(24, 24, 4);
            jLabel.setIcon(new ImageIcon(image));
        }
        catch (Exception exception) {
            jLabel.setText("\ud83d\udd12");
            jLabel.setFont(new Font(UIHelper.getEmojiFontName(), 0, 18));
        }
        this.encryptedCheckbox = new JCheckBox("M\u00e3 h\u00f3a \u0111\u1ea7u cu\u1ed1i (E2E)");
        this.encryptedCheckbox.setFont(new Font(UIHelper.getDefaultFontName(), 1, 14));
        this.encryptedCheckbox.setForeground(ENCRYPTED_COLOR);
        this.encryptedCheckbox.setBackground(new Color(240, 255, 240));
        this.encryptedCheckbox.setCursor(new Cursor(12));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.encryptedCheckbox);
        accessible = new JLabel("<html><small>\u2022 Tin nh\u1eafn \u0111\u01b0\u1ee3c m\u00e3 h\u00f3a AES-256, server kh\u00f4ng th\u1ec3 \u0111\u1ecdc<br>\u2022 Nh\u00f3m m\u00e3 h\u00f3a s\u1ebd hi\u1ec3n th\u1ecb v\u1edbi bi\u1ec3u t\u01b0\u1ee3ng \u1ed5 kh\u00f3a \ud83d\udd12</small></html>");
        ((JComponent)((Object)accessible)).setFont(new Font(UIHelper.getDefaultFontName(), 0, 11));
        ((JComponent)((Object)accessible)).setForeground(new Color(100, 100, 100));
        ((JComponent)((Object)accessible)).setBorder(new EmptyBorder(8, 0, 0, 0));
        jPanel.add(jPanel2);
        jPanel.add((Component)((Object)accessible));
        return jPanel;
    }

    private JPanel createFieldPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(BG_COLOR);
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jLabel.setForeground(new Color(50, 50, 50));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(8));
        return jPanel;
    }

    private JButton createButton(String string, Color color, Color color2) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 1, 13));
        jButton.setForeground(color2);
        jButton.setBackground(color);
        jButton.setPreferredSize(new Dimension(120, 38));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private void loadFriends() {
        SwingWorker<List<Map<String, Object>>, Void> swingWorker = new SwingWorker<List<Map<String, Object>>, Void>(){

            @Override
            protected List<Map<String, Object>> doInBackground() {
                return CreateGroupDialog.this.userService.getFriendsList(CreateGroupDialog.this.mainFrame.getUsername());
            }

            @Override
            protected void done() {
                try {
                    CreateGroupDialog.this.allFriends = (List)this.get();
                    if (CreateGroupDialog.this.allFriends != null && !CreateGroupDialog.this.allFriends.isEmpty()) {
                        for (Map<String, Object> map : CreateGroupDialog.this.allFriends) {
                            String string = (String)map.get("username");
                            String string2 = (String)map.get("full_name");
                            String string3 = string2 != null && !string2.isEmpty() ? string2 : string;
                            CreateGroupDialog.this.friendsListModel.addElement(new CheckableItem(string, string3));
                        }
                    } else {
                        JOptionPane.showMessageDialog(CreateGroupDialog.this, "B\u1ea1n ch\u01b0a c\u00f3 b\u1ea1n b\u00e8 n\u00e0o. H\u00e3y k\u1ebft b\u1ea1n tr\u01b0\u1edbc khi t\u1ea1o nh\u00f3m!", "Th\u00f4ng b\u00e1o", 1);
                        CreateGroupDialog.this.dispose();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(CreateGroupDialog.this, "L\u1ed7i khi t\u1ea3i danh s\u00e1ch b\u1ea1n b\u00e8: " + exception.getMessage(), "L\u1ed7i", 0);
                }
            }
        };
        swingWorker.execute();
    }

    private void handleCreateGroup() {
        Object object;
        int n;
        final String string = this.groupNameField.getText().trim();
        final String string2 = this.descriptionArea.getText().trim();
        boolean bl = this.encryptedCheckbox.isSelected();
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp t\u00ean nh\u00f3m!", "L\u1ed7i", 2);
            return;
        }
        final ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.friendsListModel.getSize(); n += 1) {
            object = this.friendsListModel.getElementAt(n);
            if (!((CheckableItem)object).isSelected()) continue;
            arrayList.add(((CheckableItem)object).getUsername());
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn \u00edt nh\u1ea5t 1 th\u00e0nh vi\u00ean!", "L\u1ed7i", 2);
            return;
        }
        if (bl && (n = JOptionPane.showConfirmDialog(this, "B\u1ea1n \u0111ang t\u1ea1o nh\u00f3m M\u00c3 H\u00d3A \u0110\u1ea6U CU\u1ed0I.\n\n\u26a0\ufe0f L\u01b0u \u00fd:\n\u2022 Tin nh\u1eafn s\u1ebd \u0111\u01b0\u1ee3c m\u00e3 h\u00f3a, server kh\u00f4ng th\u1ec3 \u0111\u1ecdc\n\u2022 N\u1ebfu m\u1ea5t kh\u00f3a, tin nh\u1eafn kh\u00f4ng th\u1ec3 kh\u00f4i ph\u1ee5c\n\u2022 Nh\u00f3m s\u1ebd hi\u1ec3n th\u1ecb v\u1edbi bi\u1ec3u t\u01b0\u1ee3ng \ud83d\udd12\n\nB\u1ea1n c\u00f3 ch\u1eafc mu\u1ed1n ti\u1ebfp t\u1ee5c?", "X\u00e1c nh\u1eadn t\u1ea1o nh\u00f3m m\u00e3 h\u00f3a", 0, 2))) {
            return;
        }
        this.createButton.setEnabled(false);
        this.createButton.setText("\u0110ang t\u1ea1o...");
        n = bl ? 1 : 0;
        object = new SwingWorker<Integer, Void>(n != 0){
            final /* synthetic */ boolean val$encrypted;
            {
                this.val$encrypted = bl;
            }

            @Override
            protected Integer doInBackground() {
                return CreateGroupDialog.this.groupService.createGroup(string, string2, CreateGroupDialog.this.mainFrame.getUsername(), arrayList, this.val$encrypted);
            }

            @Override
            protected void done() {
                try {
                    int n = (Integer)this.get();
                    if (n > 0) {
                        String string3 = this.val$encrypted ? "\ud83d\udd12 T\u1ea1o nh\u00f3m M\u00c3 H\u00d3A th\u00e0nh c\u00f4ng!\n\nTin nh\u1eafn trong nh\u00f3m n\u00e0y \u0111\u01b0\u1ee3c b\u1ea3o v\u1ec7 v\u1edbi m\u00e3 h\u00f3a AES-256." : "T\u1ea1o nh\u00f3m th\u00e0nh c\u00f4ng!";
                        JOptionPane.showMessageDialog(CreateGroupDialog.this, string3, "Th\u00e0nh c\u00f4ng", 1);
                        CreateGroupDialog.this.dispose();
                        CreateGroupDialog.this.mainFrame.openGroupChat(n, string, true, this.val$encrypted);
                        SwingUtilities.invokeLater(() -> {
                            CreateGroupDialog.this.mainFrame.refreshChatList();
                            CreateGroupDialog.this.mainFrame.refreshGroupList();
                        });
                        if (CreateGroupDialog.this.mainFrame.getSocketClient() != null && CreateGroupDialog.this.mainFrame.getSocketClient().isConnected()) {
                            CreateGroupDialog.this.mainFrame.getSocketClient().sendGroupCreatedNotification(n, string, arrayList);
                        }
                    } else {
                        JOptionPane.showMessageDialog(CreateGroupDialog.this, "Kh\u00f4ng th\u1ec3 t\u1ea1o nh\u00f3m. Vui l\u00f2ng th\u1eed l\u1ea1i!", "L\u1ed7i", 0);
                        CreateGroupDialog.this.createButton.setEnabled(true);
                        CreateGroupDialog.this.createButton.setText("T\u1ea1o nh\u00f3m");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(CreateGroupDialog.this, "L\u1ed7i: " + exception.getMessage(), "L\u1ed7i", 0);
                    CreateGroupDialog.this.createButton.setEnabled(true);
                    CreateGroupDialog.this.createButton.setText("T\u1ea1o nh\u00f3m");
                }
            }
        };
        ((SwingWorker)object).execute();
    }

    private class CheckBoxListRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckableItem> {
        public CheckBoxListRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> jList, CheckableItem checkableItem, int n, boolean bl, boolean bl2) {
            this.setSelected(checkableItem.isSelected());
            this.setText(checkableItem.getDisplayName());
            this.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
            if (bl) {
                this.setBackground(new Color(230, 240, 255));
            } else {
                this.setBackground(Color.WHITE);
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(240, 240, 240)), new EmptyBorder(8, 12, 8, 12)));
            return this;
        }
    }

    private class CheckableItem {
        private String username;
        private String displayName;
        private boolean selected;

        public CheckableItem(String string, String string2) {
            this.username = string;
            this.displayName = string2;
            this.selected = false;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

