/*
 * Decompiled with CFR 0.152.
 */
package user.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import user.gui.CreateGroupDialog;
import user.gui.UIHelper;
import user.gui.ZaloMainFrame;

public class ContactPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(250, 250, 250);
    private static final Color PRIMARY_COLOR = new Color(0, 132, 255);
    private static final int PANEL_WIDTH = 350;
    private ZaloMainFrame mainFrame;

    public ContactPanel(ZaloMainFrame zaloMainFrame) {
        this.mainFrame = zaloMainFrame;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setBackground(BG_COLOR);
        this.setPreferredSize(new Dimension(350, 0));
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createHeader();
        JPanel jPanel2 = this.createMenuPanel();
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
    }

    private JPanel createHeader() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JLabel jLabel = new JLabel("Danh b\u1ea1");
        jLabel.setFont(new Font(UIHelper.getDefaultFontName(), 1, 20));
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 0));
        jPanel2.setOpaque(false);
        JButton jButton = new JButton("T\u1ea1o Nh\u00f3m");
        jButton.setFont(new Font(UIHelper.getDefaultFontName(), 0, 13));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(PRIMARY_COLOR);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setOpaque(true);
        jButton.setContentAreaFilled(true);
        jButton.setCursor(new Cursor(12));
        jButton.setBorder(BorderFactory.createEmptyBorder(6, 15, 6, 15));
        jButton.addActionListener(actionEvent -> {
            CreateGroupDialog createGroupDialog = new CreateGroupDialog(this.mainFrame);
            createGroupDialog.setVisible(true);
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel createMenuPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(230, 230, 230)));
        jPanel.add(this.createMenuItem("\ud83d\udc65", "Danh s\u00e1ch b\u1ea1n b\u00e8", "FRIENDS", 0));
        jPanel.add(this.createMenuItem("\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "Danh s\u00e1ch nh\u00f3m", "GROUPS", 0));
        jPanel.add(this.createMenuItem("\ud83d\udc4b", "L\u1eddi m\u1eddi k\u1ebft b\u1ea1n", "FRIEND_REQUESTS", 0));
        return jPanel;
    }

    private JPanel createMenuItem(String string, String string2, final String string3, int n) {
        final JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 15, 12, 15));
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        jPanel.setCursor(new Cursor(12));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 0));
        jPanel2.setOpaque(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font(UIHelper.getEmojiFontName(), 0, 24));
        JLabel jLabel2 = new JLabel(string2);
        jLabel2.setFont(new Font(UIHelper.getDefaultFontName(), 0, 14));
        jPanel2.add(jLabel);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.setOpaque(false);
        if (n > 0) {
            JLabel jLabel3 = new JLabel(String.valueOf(n));
            jLabel3.setFont(new Font(UIHelper.getDefaultFontName(), 1, 11));
            jLabel3.setForeground(Color.WHITE);
            jLabel3.setBackground(new Color(255, 59, 48));
            jLabel3.setOpaque(true);
            jLabel3.setHorizontalAlignment(0);
            jLabel3.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
            jPanel3.add(jLabel3);
        }
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ContactPanel.this.mainFrame.showContactContent(string3);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jPanel.setBackground(new Color(240, 242, 245));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jPanel.setBackground(Color.WHITE);
            }
        });
        return jPanel;
    }
}

