/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.StatisticsDAO;
import admin.socket.User;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class NewUserReportPanel
extends JPanel {
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color NEUTRAL_GRAY = new Color(108, 117, 125);
    private JTable userTable;
    private DefaultTableModel tableModel;
    private JTextField dateFromField;
    private JTextField dateToField;
    private JTextField searchNameField;
    private JComboBox<String> searchTypeCombo;
    private JComboBox<String> sortCombo;
    private JButton filterButton;
    private JButton resetButton;
    private JButton refreshButton;
    private JButton exportButton;
    private JLabel totalLabel;
    private StatisticsDAO statisticsDAO;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public NewUserReportPanel() {
        this.statisticsDAO = new StatisticsDAO();
        this.initComponents();
        this.setupLayout();
        this.setupEventHandlers();
        this.dateFromField.setText("");
        this.dateToField.setText("");
        this.loadDefaultData();
    }

    private void loadDefaultData() {
        try {
            List<User> list = this.statisticsDAO.getNewUsers(null, null, null, null, "S\u1eafp x\u1ebfp theo th\u1eddi gian (M\u1edbi nh\u1ea5t)");
            this.displayNewUsers(list);
            this.updateStatistics();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void initComponents() {
        Object[] objectArray = new String[]{"ID", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "Email", "Ng\u00e0y \u0111\u0103ng k\u00fd", "Tr\u1ea1ng th\u00e1i"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.userTable = new JTable(this.tableModel);
        this.userTable.setRowHeight(28);
        this.userTable.setAutoCreateRowSorter(true);
        this.userTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.userTable.getTableHeader().setBackground(Color.WHITE);
        this.userTable.getTableHeader().setForeground(Color.BLACK);
        TableColumnModel tableColumnModel = this.userTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(120);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(180);
        tableColumnModel.getColumn(4).setPreferredWidth(120);
        tableColumnModel.getColumn(5).setPreferredWidth(110);
        this.dateFromField = new JTextField(10);
        this.dateFromField.setToolTipText("\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD");
        this.dateToField = new JTextField(10);
        this.dateToField.setToolTipText("\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD");
        this.searchNameField = new JTextField(20);
        this.searchTypeCombo = new JComboBox<String>(new String[]{"L\u1ecdc theo t\u00ean", "L\u1ecdc theo email"});
        this.sortCombo = new JComboBox<String>(new String[]{"S\u1eafp x\u1ebfp theo th\u1eddi gian (M\u1edbi nh\u1ea5t)", "S\u1eafp x\u1ebfp theo th\u1eddi gian (C\u0169 nh\u1ea5t)", "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)", "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)", "S\u1eafp x\u1ebfp theo email (A-Z)", "S\u1eafp x\u1ebfp theo email (Z-A)"});
        this.filterButton = this.createButtonWithIcon("T\u00ecm ki\u1ebfm v\u00e0 l\u1ecdc", "search");
        this.resetButton = this.createButtonWithIcon("\u0110\u1eb7t l\u1ea1i", "reset");
        this.refreshButton = this.createButtonWithIcon("L\u00e0m m\u1edbi", "refresh");
        this.exportButton = this.createButtonWithIcon("Xu\u1ea5t CSV", "export");
        this.stylePrimaryButton(this.filterButton);
        this.stylePrimaryButton(this.resetButton);
        this.styleAddUserButtonSimple(this.refreshButton);
        this.styleAddUserButtonSimple(this.exportButton);
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createFilterPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createTablePanel();
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.createButtonPanel();
        this.add((Component)jPanel3, "South");
    }

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("calendar", 20, 20);
        JLabel jLabel = new JLabel("T\u00f9y ch\u1ecdn b\u00e1o c\u00e1o ng\u01b0\u1eddi d\u00f9ng m\u1edbi");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("T\u1eeb ng\u00e0y:"));
        this.dateFromField.setPreferredSize(new Dimension(120, 30));
        jPanel2.add(this.dateFromField);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JLabel("\u0110\u1ebfn ng\u00e0y:"));
        this.dateToField.setPreferredSize(new Dimension(120, 30));
        jPanel2.add(this.dateToField);
        JLabel jLabel2 = new JLabel("(\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD)");
        jLabel2.setFont(new Font("Arial", 2, 11));
        jLabel2.setForeground(NEUTRAL_GRAY);
        jPanel2.add(jLabel2);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel3.setOpaque(false);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(new JLabel("Lo\u1ea1i l\u1ecdc:"));
        this.searchTypeCombo.setPreferredSize(new Dimension(120, 30));
        jPanel3.add(this.searchTypeCombo);
        jPanel3.add(new JLabel("T\u1eeb kh\u00f3a:"));
        this.searchNameField.setPreferredSize(new Dimension(200, 30));
        jPanel3.add(this.searchNameField);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(new JLabel("S\u1eafp x\u1ebfp:"));
        this.sortCombo.setPreferredSize(new Dimension(240, 30));
        jPanel3.add(this.sortCombo);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel4.setOpaque(false);
        jPanel4.setAlignmentX(0.0f);
        jPanel4.add(this.filterButton);
        jPanel4.add(this.resetButton);
        jPanel.add(jPanel4);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("list", 20, 20);
        JLabel jLabel = new JLabel("Danh s\u00e1ch ng\u01b0\u1eddi d\u00f9ng \u0111\u0103ng k\u00fd m\u1edbi");
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
            jLabel.setHorizontalTextPosition(4);
            jLabel.setIconTextGap(8);
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel("T\u1ed5ng s\u1ed1: 0");
        }
        this.totalLabel.setFont(new Font("Arial", 1, 12));
        jPanel3.add(this.totalLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.userTable), "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 10, 10));
        jPanel.setOpaque(false);
        jPanel.add(this.refreshButton);
        jPanel.add(this.exportButton);
        return jPanel;
    }

    private void setupEventHandlers() {
        this.filterButton.addActionListener(actionEvent -> this.handleFilterReport());
        this.resetButton.addActionListener(actionEvent -> this.handleReset());
        this.refreshButton.addActionListener(actionEvent -> this.handleRefresh());
        this.exportButton.addActionListener(actionEvent -> this.handleExport());
    }

    private void handleFilterReport() {
        String string = this.dateFromField.getText().trim();
        String string2 = this.dateToField.getText().trim();
        boolean bl = string.isEmpty() && string2.isEmpty();
        LocalDate localDate = null;
        LocalDate localDate2 = null;
        if (!bl) {
            if (string.isEmpty() || string2.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Vui l\u00f2ng nh\u1eadp \u0111\u1ea7y \u0111\u1ee7 kho\u1ea3ng th\u1eddi gian!\n\u0110\u1ecbnh d\u1ea1ng: YYYY-MM-DD\nV\u00ed d\u1ee5: 2024-01-01\n\nHo\u1eb7c \u0111\u1ec3 tr\u1ed1ng c\u1ea3 2 \u0111\u1ec3 xem t\u1ea5t c\u1ea3", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            if (!this.isValidDateFormat(string) || !this.isValidDateFormat(string2)) {
                JOptionPane.showMessageDialog(this, "\u0110\u1ecbnh d\u1ea1ng ng\u00e0y kh\u00f4ng h\u1ee3p l\u1ec7!\nVui l\u00f2ng nh\u1eadp theo \u0111\u1ecbnh d\u1ea1ng: YYYY-MM-DD\nV\u00ed d\u1ee5: 2024-01-01", "L\u1ed7i", 0);
                return;
            }
            localDate = LocalDate.parse(string, this.inputFormatter);
            localDate2 = LocalDate.parse(string2, this.inputFormatter);
        }
        try {
            String string3 = this.searchNameField.getText().trim();
            String string4 = (String)this.searchTypeCombo.getSelectedItem();
            String string5 = (String)this.sortCombo.getSelectedItem();
            String string6 = null;
            String string7 = null;
            if (!string3.isEmpty()) {
                if ("L\u1ecdc theo email".equals(string4)) {
                    string7 = string3;
                } else {
                    string6 = string3;
                }
            }
            List<User> list = this.statisticsDAO.getNewUsers(localDate, localDate2, string6, string7, string5);
            this.displayNewUsers(list);
            this.updateStatistics();
            String string8 = bl ? "\u0110\u00e3 t\u1ea3i " + list.size() + " ng\u01b0\u1eddi d\u00f9ng (t\u1ea5t c\u1ea3 c\u00e1c n\u0103m)" : "\u0110\u00e3 t\u1ea3i " + list.size() + " ng\u01b0\u1eddi d\u00f9ng m\u1edbi\nT\u1eeb: " + string + " \u0111\u1ebfn: " + string2;
            JOptionPane.showMessageDialog(this, string8, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (DateTimeParseException dateTimeParseException) {
            this.showError("L\u1ed7i \u0111\u1ecbnh d\u1ea1ng ng\u00e0y: " + dateTimeParseException.getMessage());
        }
        catch (SQLException sQLException) {
            String string9 = sQLException.getMessage();
            String string10 = "L\u1ed7i load d\u1eef li\u1ec7u ng\u01b0\u1eddi d\u00f9ng m\u1edbi: " + string9;
            if (string9 != null && (string9.contains("connection") || string9.contains("Connection"))) {
                string10 = string10 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Kho\u1ea3ng th\u1eddi gian \u0111\u00e3 ch\u1ecdn\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string10);
            sQLException.printStackTrace();
        }
    }

    private void displayNewUsersFromMap(List<Map<String, Object>> list) {
        this.tableModel.setRowCount(0);
        for (Map<String, Object> map : list) {
            Object[] objectArray = new Object[]{map.get("user_id"), map.get("username"), map.get("full_name"), map.get("email"), map.get("created_at"), "active".equals(map.get("status")) ? "Ho\u1ea1t \u0111\u1ed9ng" : "B\u1ecb kh\u00f3a"};
            this.tableModel.addRow(objectArray);
        }
    }

    private void displayNewUsers(List<User> list) {
        this.tableModel.setRowCount(0);
        for (User user : list) {
            Object[] objectArray = new Object[]{user.getId(), user.getUsername(), user.getFullName(), user.getEmail(), user.getCreatedAt() != null ? user.getCreatedAt().format(this.dateFormatter) : "", "active".equalsIgnoreCase(user.getStatus()) ? "Ho\u1ea1t \u0111\u1ed9ng" : "B\u1ecb kh\u00f3a"};
            this.tableModel.addRow(objectArray);
        }
    }

    private void loadFilteredData(String string, String string2, String string3, String string4) {
        this.handleFilterReport();
        this.updateStatistics();
    }

    private void updateStatistics() {
        int n = this.userTable.getRowCount();
        if (this.totalLabel != null) {
            this.totalLabel.setText("\ud83d\udcca T\u1ed5ng s\u1ed1: " + n);
        }
    }

    private boolean isValidDateFormat(String string) {
        if (string == null || string.length() != 10) {
            return false;
        }
        return string.matches("\\d{4}-\\d{2}-\\d{2}");
    }

    private void handleReset() {
        this.dateFromField.setText("");
        this.dateToField.setText("");
        this.searchNameField.setText("");
        this.searchTypeCombo.setSelectedIndex(0);
        this.sortCombo.setSelectedIndex(0);
        this.tableModel.setRowCount(0);
        this.updateStatistics();
        JOptionPane.showMessageDialog(this, "\u0110\u00e3 \u0111\u1eb7t l\u1ea1i t\u1ea5t c\u1ea3 b\u1ed9 l\u1ecdc!", "Th\u00f4ng b\u00e1o", 1);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void handleRefresh() {
        String string = this.dateFromField.getText().trim();
        String string2 = this.dateToField.getText().trim();
        if (!string.isEmpty() && !string2.isEmpty()) {
            String string3 = this.searchNameField.getText().trim();
            String string4 = (String)this.searchTypeCombo.getSelectedItem();
            String string5 = (String)this.sortCombo.getSelectedItem();
            String string6 = null;
            String string7 = null;
            if (!string3.isEmpty()) {
                if ("L\u1ecdc theo email".equals(string4)) {
                    string7 = string3;
                } else {
                    string6 = string3;
                }
            }
            try {
                LocalDate localDate = LocalDate.parse(string, this.inputFormatter);
                LocalDate localDate2 = LocalDate.parse(string2, this.inputFormatter);
                List<User> list = this.statisticsDAO.getNewUsers(localDate, localDate2, string6, string7, string5);
                this.displayNewUsers(list);
                this.updateStatistics();
            }
            catch (Exception exception) {
                this.showError("L\u1ed7i l\u00e0m m\u1edbi d\u1eef li\u1ec7u: " + exception.getMessage());
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 l\u00e0m m\u1edbi d\u1eef li\u1ec7u!", "Th\u00f4ng b\u00e1o", 1);
        } else {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn kho\u1ea3ng th\u1eddi gian tr\u01b0\u1edbc khi l\u00e0m m\u1edbi!", "C\u1ea3nh b\u00e1o", 2);
        }
    }

    private void handleExport() {
        if (this.userTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!\nVui l\u00f2ng t\u1ea1o b\u00e1o c\u00e1o tr\u01b0\u1edbc.", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("NguoiDungMoi.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,T\u00ean \u0111\u0103ng nh\u1eadp,H\u1ecd t\u00ean,Email,Ng\u00e0y \u0111\u0103ng k\u00fd,Tr\u1ea1ng th\u00e1i");
                for (int i = 0; i < this.userTable.getRowCount(); ++i) {
                    String string = String.format("%s,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", this.userTable.getValueAt(i, 0), this.escapeCsv(this.userTable.getValueAt(i, 1)), this.escapeCsv(this.userTable.getValueAt(i, 2)), this.escapeCsv(this.userTable.getValueAt(i, 3)), this.escapeCsv(this.userTable.getValueAt(i, 4)), this.escapeCsv(this.userTable.getValueAt(i, 5)));
                    printWriter.println(string);
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + this.userTable.getRowCount() + " ng\u01b0\u1eddi d\u00f9ng v\u00e0o file:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i xu\u1ea5t file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String escapeCsv(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        return string.replace("\"", "\"\"");
    }

    private Border createTitledBorder(String string) {
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitleColor(ZALO_BLUE);
        titledBorder.setTitleFont(new Font("Arial", 1, 14));
        return BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
    }

    private void stylePrimaryButton(JButton jButton) {
        jButton.setBackground(ZALO_BLUE);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleNeutralButton(JButton jButton) {
        jButton.setBackground(NEUTRAL_GRAY);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
    }

    private void styleAddUserButtonSimple(JButton jButton) {
        Color color = new Color(32, 178, 170);
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 14));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(10, 20, 10, 20));
        jButton.setCursor(new Cursor(12));
    }

    private Component[] getAllComponents(Container container) {
        Component[] componentArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray = container.getComponents()) {
            Component[] componentArray2;
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            for (Component component2 : componentArray2 = this.getAllComponents((Container)component)) {
                arrayList.add(component2);
            }
        }
        return arrayList.toArray(new Component[0]);
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not load icon: " + string);
        }
        return null;
    }

    private JButton createButtonWithIcon(String string, String string2) {
        JButton jButton = new JButton(string);
        ImageIcon imageIcon = this.loadIcon(string2, 16, 16);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
            jButton.setHorizontalTextPosition(4);
            jButton.setIconTextGap(8);
        }
        jButton.setPreferredSize(new Dimension(200, 35));
        return jButton;
    }
}

