/*
 * Decompiled with CFR 0.152.
 */
package admin.gui;

import admin.service.GroupDAO;
import admin.service.UserDAO;
import admin.socket.ChatGroup;
import admin.socket.User;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class GroupManagementPanel
extends JPanel {
    private static final Color ZALO_BLUE = new Color(0, 102, 255);
    private static final Color WARNING_ORANGE = new Color(255, 193, 7);
    private static final Color SUCCESS_GREEN = new Color(40, 167, 69);
    private static final Color DANGER_RED = new Color(220, 53, 69);
    private static final Color INFO_CYAN = new Color(23, 162, 184);
    private JTable groupTable;
    private DefaultTableModel tableModel;
    private JTextField searchField;
    private JComboBox<String> sortCombo;
    private JComboBox<String> searchTypeCombo;
    private JLabel totalLabel;
    private GroupDAO groupDAO;
    private UserDAO userDAO;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private List<ChatGroup> currentGroups = new ArrayList<ChatGroup>();

    public GroupManagementPanel() {
        this.groupDAO = new GroupDAO();
        this.userDAO = new UserDAO();
        this.initComponents();
        this.setupLayout();
        this.loadGroupsFromDatabase();
        this.setupEventHandlers();
    }

    private void initComponents() {
        Object[] objectArray = new String[]{"ID", "T\u00ean nh\u00f3m", "Admin (S\u1ed1 l\u01b0\u1ee3ng)", "S\u1ed1 th\u00e0nh vi\u00ean", "Ng\u00e0y t\u1ea1o"};
        this.tableModel = new DefaultTableModel(objectArray, 0){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.groupTable = new JTable(this.tableModel);
        this.groupTable.setRowHeight(28);
        this.groupTable.setAutoCreateRowSorter(true);
        this.groupTable.getTableHeader().setFont(new Font("Arial", 1, 13));
        this.groupTable.getTableHeader().setBackground(Color.WHITE);
        this.groupTable.getTableHeader().setForeground(Color.BLACK);
        TableColumnModel tableColumnModel = this.groupTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(50);
        tableColumnModel.getColumn(1).setPreferredWidth(200);
        tableColumnModel.getColumn(2).setPreferredWidth(200);
        tableColumnModel.getColumn(3).setPreferredWidth(100);
        tableColumnModel.getColumn(4).setPreferredWidth(120);
        this.searchField = new JTextField(20);
        this.searchTypeCombo = new JComboBox<String>(new String[]{"T\u00ecm theo t\u00ean nh\u00f3m", "T\u00ecm theo admin"});
        this.sortCombo = new JComboBox<String>(new String[]{"S\u1eafp x\u1ebfp theo t\u00ean (A-Z)", "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)", "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (M\u1edbi nh\u1ea5t)", "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (C\u0169 nh\u1ea5t)"});
    }

    private void loadGroupsFromDatabase() {
        this.tableModel.setRowCount(0);
        this.tableModel.addRow(new Object[]{"\u23f3", "\u0110ang t\u1ea3i d\u1eef li\u1ec7u...", "", "", ""});
        System.out.println("\ud83d\udd0d [GroupManagementPanel] Loading groups from database...");
        SwingWorker<List<ChatGroup>, Void> swingWorker = new SwingWorker<List<ChatGroup>, Void>(){

            @Override
            protected List<ChatGroup> doInBackground() {
                try {
                    System.out.println("\u23f3 [GroupManagementPanel] Calling groupDAO.getAllGroups()...");
                    List<ChatGroup> list = GroupManagementPanel.this.groupDAO.getAllGroups();
                    System.out.println("\u2705 [GroupManagementPanel] Loaded " + list.size() + " groups");
                    return list;
                }
                catch (SQLException sQLException) {
                    System.err.println("\u274c [GroupManagementPanel] Database error: " + sQLException.getMessage());
                    sQLException.printStackTrace();
                    throw new RuntimeException(sQLException);
                }
            }

            @Override
            protected void done() {
                try {
                    GroupManagementPanel.this.currentGroups = (List)this.get();
                    GroupManagementPanel.this.applySorting();
                    if (GroupManagementPanel.this.totalLabel != null) {
                        GroupManagementPanel.this.totalLabel.setText("\ud83d\udcca T\u1ed5ng s\u1ed1 nh\u00f3m: " + GroupManagementPanel.this.currentGroups.size());
                    }
                    System.out.println("\ud83d\udcca [GroupManagementPanel] Displaying " + GroupManagementPanel.this.currentGroups.size() + " groups");
                    GroupManagementPanel.this.displayGroups(GroupManagementPanel.this.currentGroups);
                }
                catch (Exception exception) {
                    GroupManagementPanel.this.tableModel.setRowCount(0);
                    String string = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
                    String string2 = "L\u1ed7i load d\u1eef li\u1ec7u nh\u00f3m chat: " + string;
                    if (string != null && (string.contains("connection") || string.contains("Connection"))) {
                        string2 = string2 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- File config.properties\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
                    }
                    System.err.println("\u274c [GroupManagementPanel] Error in done(): " + string);
                    GroupManagementPanel.this.showError(string2);
                    exception.printStackTrace();
                    GroupManagementPanel.this.tableModel.addRow(new Object[]{"\u274c", "L\u1ed7i t\u1ea3i d\u1eef li\u1ec7u", string, "", ""});
                }
            }
        };
        swingWorker.execute();
    }

    private void displayGroups(List<ChatGroup> list) {
        this.tableModel.setRowCount(0);
        for (ChatGroup chatGroup : list) {
            int n = chatGroup.getAdminCount();
            Object object = (chatGroup.getCreatorName() != null ? chatGroup.getCreatorName() : "N/A") + " (+" + (n - 1) + " admin kh\u00e1c)";
            if (n == 1) {
                object = chatGroup.getCreatorName() != null ? chatGroup.getCreatorName() : "N/A";
            }
            Object[] objectArray = new Object[]{chatGroup.getId(), chatGroup.getGroupName() != null ? chatGroup.getGroupName() : "", object, chatGroup.getMemberCount(), chatGroup.getCreatedAt() != null ? chatGroup.getCreatedAt().format(this.dateFormatter) : ""};
            this.tableModel.addRow(objectArray);
        }
    }

    private void setupLayout() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.setBackground(new Color(248, 249, 250));
        JPanel jPanel = this.createSearchPanel();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createTablePanel();
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.createButtonPanel();
        this.add((Component)jPanel3, "South");
    }

    private JPanel createSearchPanel() {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(15, 15, 15, 15)));
        ImageIcon imageIcon = this.loadIcon("search", 18, 18);
        if (imageIcon != null) {
            jLabel = new JLabel("T\u00ecm ki\u1ebfm & L\u1ecdc nh\u00f3m chat", imageIcon, 2);
            jLabel.setIconTextGap(6);
        } else {
            jLabel = new JLabel("T\u00ecm ki\u1ebfm & L\u1ecdc nh\u00f3m chat");
        }
        jLabel.setFont(new Font("Arial", 1, 14));
        jLabel.setForeground(ZALO_BLUE);
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel2.setOpaque(false);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Lo\u1ea1i t\u00ecm ki\u1ebfm:"));
        this.searchTypeCombo.setPreferredSize(new Dimension(150, 30));
        jPanel2.add(this.searchTypeCombo);
        jPanel2.add(new JLabel("T\u1eeb kh\u00f3a:"));
        this.searchField.setPreferredSize(new Dimension(250, 30));
        jPanel2.add(this.searchField);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 10, 5));
        jPanel3.setOpaque(false);
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(new JLabel("S\u1eafp x\u1ebfp:"));
        this.sortCombo.setPreferredSize(new Dimension(280, 30));
        jPanel3.add(this.sortCombo);
        ImageIcon imageIcon2 = this.loadIcon("search", 16, 16);
        JButton jButton = this.createStyledButtonWithIcon("T\u00ecm ki\u1ebfm + L\u1ecdc", ZALO_BLUE, imageIcon2);
        jButton.addActionListener(actionEvent -> this.handleSearchAndFilter());
        jPanel3.add(jButton);
        ImageIcon imageIcon3 = this.loadIcon("reset", 16, 16);
        JButton jButton2 = this.createStyledButtonWithIcon("\u0110\u1eb7t l\u1ea1i", ZALO_BLUE, imageIcon3);
        jButton2.addActionListener(actionEvent -> this.handleReset());
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel createTablePanel() {
        JLabel jLabel;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), new EmptyBorder(10, 10, 10, 10)));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("chat", 20, 20);
        if (imageIcon != null) {
            jLabel = new JLabel("Danh s\u00e1ch nh\u00f3m chat", imageIcon, 2);
            jLabel.setIconTextGap(8);
        } else {
            jLabel = new JLabel("Danh s\u00e1ch nh\u00f3m chat");
        }
        jLabel.setFont(new Font("Arial", 1, 16));
        jLabel.setForeground(ZALO_BLUE);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 15, 0));
        jPanel3.setOpaque(false);
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel("\ud83d\udcca T\u1ed5ng s\u1ed1 nh\u00f3m: 0");
        }
        this.totalLabel.setFont(new Font("Arial", 1, 12));
        jPanel3.add(this.totalLabel);
        jPanel2.add((Component)jLabel, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel2.setBorder(new EmptyBorder(0, 0, 10, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.groupTable), "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 15, 10));
        jPanel.setOpaque(false);
        ImageIcon imageIcon = this.loadIcon("user", 16, 16);
        JButton jButton = this.createStyledButtonWithIcon("Xem th\u00e0nh vi\u00ean", INFO_CYAN, imageIcon);
        ImageIcon imageIcon2 = this.loadIcon("admin", 16, 16);
        if (imageIcon2 == null) {
            imageIcon2 = this.loadIcon("crown", 16, 16);
        }
        JButton jButton2 = this.createStyledButtonWithIcon("Danh s\u00e1ch admin", INFO_CYAN, imageIcon2);
        ImageIcon imageIcon3 = this.loadIcon("export", 16, 16);
        if (imageIcon3 == null) {
            imageIcon3 = this.loadIcon("download", 16, 16);
        }
        JButton jButton3 = this.createStyledButtonWithIcon("Xu\u1ea5t CSV", INFO_CYAN, imageIcon3);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void setupEventHandlers() {
        this.addActionToButton("T\u00ecm ki\u1ebfm + L\u1ecdc", actionEvent -> this.handleSearchAndFilter());
        this.addActionToButton("\u0110\u1eb7t l\u1ea1i", actionEvent -> this.handleReset());
        this.addActionToButton("Xem th\u00e0nh vi\u00ean", actionEvent -> this.showMembersDialog());
        this.addActionToButton("Danh s\u00e1ch admin", actionEvent -> this.showAdminsDialog());
        this.addActionToButton("Xu\u1ea5t CSV", actionEvent -> this.handleExportCSV());
    }

    private void handleSearchAndFilter() {
        String string = this.searchField.getText().trim();
        String string2 = (String)this.searchTypeCombo.getSelectedItem();
        try {
            List<ChatGroup> list;
            if (!string.isEmpty()) {
                boolean bl = "T\u00ecm theo admin".equals(string2);
                list = this.groupDAO.searchGroups(string, bl);
            } else {
                list = this.groupDAO.getAllGroups();
            }
            this.currentGroups = list;
            this.applySorting();
            this.displayGroups(this.currentGroups);
            if (this.totalLabel != null) {
                this.totalLabel.setText("\ud83d\udcca T\u1ed5ng s\u1ed1 nh\u00f3m: " + this.currentGroups.size());
            }
            String string3 = !string.isEmpty() ? "T\u00ecm th\u1ea5y " + list.size() + " nh\u00f3m" : "\u0110\u00e3 l\u1ecdc " + list.size() + " nh\u00f3m";
            JOptionPane.showMessageDialog(this, string3, "K\u1ebft qu\u1ea3", 1);
        }
        catch (SQLException sQLException) {
            String string4 = sQLException.getMessage();
            String string5 = "L\u1ed7i t\u00ecm ki\u1ebfm/l\u1ecdc nh\u00f3m chat: " + string4;
            if (string4 != null && (string4.contains("connection") || string4.contains("Connection"))) {
                string5 = string5 + "\n\nVui l\u00f2ng ki\u1ec3m tra:\n- K\u1ebft n\u1ed1i database\n- Th\u00f4ng tin t\u00ecm ki\u1ebfm\nHo\u1eb7c li\u00ean h\u1ec7 admin \u0111\u1ec3 \u0111\u01b0\u1ee3c h\u1ed7 tr\u1ee3.";
            }
            this.showError(string5);
            sQLException.printStackTrace();
        }
    }

    private void applySorting() {
        String string = (String)this.sortCombo.getSelectedItem();
        if (string == null || this.currentGroups.isEmpty()) {
            return;
        }
        this.currentGroups.sort(switch (string) {
            case "S\u1eafp x\u1ebfp theo t\u00ean (A-Z)" -> Comparator.comparing(chatGroup -> chatGroup.getGroupName() != null ? chatGroup.getGroupName().toLowerCase() : "");
            case "S\u1eafp x\u1ebfp theo t\u00ean (Z-A)" -> Comparator.comparing(chatGroup -> chatGroup.getGroupName() != null ? chatGroup.getGroupName().toLowerCase() : "").reversed();
            case "S\u1eafp x\u1ebfp theo ng\u00e0y t\u1ea1o (C\u0169 nh\u1ea5t)" -> Comparator.comparing(ChatGroup::getCreatedAt, Comparator.nullsLast(LocalDateTime::compareTo));
            default -> Comparator.comparing(ChatGroup::getCreatedAt, Comparator.nullsLast(LocalDateTime::compareTo)).reversed();
        });
    }

    private void handleReset() {
        this.searchField.setText("");
        this.searchTypeCombo.setSelectedIndex(0);
        this.sortCombo.setSelectedIndex(0);
        this.loadGroupsFromDatabase();
        JOptionPane.showMessageDialog(this, "\u0110\u00e3 \u0111\u1eb7t l\u1ea1i b\u1ed9 l\u1ecdc!", "Th\u00f4ng b\u00e1o", 1);
    }

    private void showMembersDialog() {
        int n = this.groupTable.getSelectedRow();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn nh\u00f3m chat!", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        int n2 = (Integer)this.groupTable.getValueAt(n, 0);
        String string = this.groupTable.getValueAt(n, 1).toString();
        try {
            Object sQLException;
            List<User> list = this.groupDAO.getGroupMembers(n2);
            JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Danh s\u00e1ch th\u00e0nh vi\u00ean - " + string, true);
            jDialog.setLayout(new BorderLayout(10, 10));
            jDialog.setSize(700, 500);
            jDialog.setLocationRelativeTo(this);
            Object[] objectArray = new String[]{"STT", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "Ng\u00e0y sinh", "Gi\u1edbi t\u00ednh", "Email", "Tr\u1ea1ng th\u00e1i"};
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            int n3 = 1;
            for (User object22 : list) {
                try {
                    sQLException = this.userDAO.getUserById(object22.getId());
                    if (sQLException == null) continue;
                    defaultTableModel.addRow(new Object[]{n3++, ((User)sQLException).getUsername(), ((User)sQLException).getFullName() != null ? ((User)sQLException).getFullName() : "", ((User)sQLException).getBirthDate() != null ? ((User)sQLException).getBirthDate().format(dateTimeFormatter) : "", ((User)sQLException).getGender() != null ? ((User)sQLException).getGender() : "", ((User)sQLException).getEmail() != null ? ((User)sQLException).getEmail() : "", "active".equals(((User)sQLException).getStatus()) ? "Ho\u1ea1t \u0111\u1ed9ng" : "B\u1ecb kh\u00f3a"});
                }
                catch (SQLException sQLException2) {
                    System.err.println("L\u1ed7i l\u1ea5y th\u00f4ng tin user ID: " + object22.getId());
                }
            }
            JTable jTable = new JTable(defaultTableModel);
            jTable.setRowHeight(28);
            jTable.getTableHeader().setFont(new Font("Arial", 1, 12));
            jTable.getTableHeader().setBackground(ZALO_BLUE);
            jTable.getTableHeader().setForeground(Color.WHITE);
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            sQLException = new JLabel("\ud83d\udcca T\u1ed5ng s\u1ed1 th\u00e0nh vi\u00ean: " + list.size());
            ((JComponent)sQLException).setFont(new Font("Arial", 1, 13));
            ((JComponent)sQLException).setBorder(new EmptyBorder(0, 0, 10, 0));
            jPanel.add((Component)sQLException, "North");
            jPanel.add((Component)new JScrollPane(jTable), "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            JButton jButton = this.createStyledButton("\u0110\u00f3ng", DANGER_RED);
            jButton.addActionListener(actionEvent -> jDialog.dispose());
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "South");
            jDialog.add(jPanel);
            jDialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i l\u1ea5y danh s\u00e1ch th\u00e0nh vi\u00ean: " + sQLException.getMessage());
        }
    }

    private void showAdminsDialog() {
        int n = this.groupTable.getSelectedRow();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Vui l\u00f2ng ch\u1ecdn nh\u00f3m chat!", "C\u1ea3nh b\u00e1o", 2);
            return;
        }
        int n2 = (Integer)this.groupTable.getValueAt(n, 0);
        String string = this.groupTable.getValueAt(n, 1).toString();
        try {
            Object sQLException;
            List<User> list = this.groupDAO.getGroupAdmins(n2);
            JDialog jDialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(this), "Danh s\u00e1ch Admin - " + string, true);
            jDialog.setLayout(new BorderLayout(10, 10));
            jDialog.setSize(600, 400);
            jDialog.setLocationRelativeTo(this);
            Object[] objectArray = new String[]{"STT", "T\u00ean \u0111\u0103ng nh\u1eadp", "H\u1ecd t\u00ean", "Ng\u00e0y sinh", "Gi\u1edbi t\u00ednh", "Email", "Tr\u1ea1ng th\u00e1i"};
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            int n3 = 1;
            for (User object22 : list) {
                try {
                    sQLException = this.userDAO.getUserById(object22.getId());
                    if (sQLException == null) continue;
                    defaultTableModel.addRow(new Object[]{n3++, ((User)sQLException).getUsername(), ((User)sQLException).getFullName() != null ? ((User)sQLException).getFullName() : "", ((User)sQLException).getBirthDate() != null ? ((User)sQLException).getBirthDate().format(dateTimeFormatter) : "", ((User)sQLException).getGender() != null ? ((User)sQLException).getGender() : "", ((User)sQLException).getEmail() != null ? ((User)sQLException).getEmail() : "", "active".equals(((User)sQLException).getStatus()) ? "Ho\u1ea1t \u0111\u1ed9ng" : "B\u1ecb kh\u00f3a"});
                }
                catch (SQLException sQLException2) {
                    System.err.println("L\u1ed7i l\u1ea5y th\u00f4ng tin user ID: " + object22.getId());
                }
            }
            JTable jTable = new JTable(defaultTableModel);
            jTable.setRowHeight(28);
            jTable.getTableHeader().setFont(new Font("Arial", 1, 12));
            jTable.getTableHeader().setBackground(INFO_CYAN);
            jTable.getTableHeader().setForeground(Color.WHITE);
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            sQLException = new JLabel("\ud83d\udc51 T\u1ed5ng s\u1ed1 admin: " + list.size());
            ((JComponent)sQLException).setFont(new Font("Arial", 1, 13));
            ((JComponent)sQLException).setBorder(new EmptyBorder(0, 0, 10, 0));
            jPanel.add((Component)sQLException, "North");
            jPanel.add((Component)new JScrollPane(jTable), "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            JButton jButton = this.createStyledButton("\u0110\u00f3ng", DANGER_RED);
            jButton.addActionListener(actionEvent -> jDialog.dispose());
            jPanel2.add(jButton);
            jPanel.add((Component)jPanel2, "South");
            jDialog.add(jPanel);
            jDialog.setVisible(true);
        }
        catch (SQLException sQLException) {
            this.showError("L\u1ed7i l\u1ea5y danh s\u00e1ch admin: " + sQLException.getMessage());
        }
    }

    private JButton createStyledButton(String string, Color color) {
        JButton jButton = new JButton(string);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setMargin(new Insets(5, 12, 5, 12));
        jButton.setCursor(new Cursor(12));
        return jButton;
    }

    private JButton createStyledButtonWithIcon(String string, Color color, ImageIcon imageIcon) {
        JButton jButton;
        if (imageIcon != null) {
            jButton = new JButton(string, imageIcon);
            jButton.setIconTextGap(10);
        } else {
            jButton = new JButton(string);
        }
        jButton.setBackground(color);
        jButton.setForeground(Color.WHITE);
        jButton.setFont(new Font("Arial", 1, 12));
        jButton.setOpaque(true);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(new Cursor(12));
        jButton.setMargin(new Insets(8, 20, 8, 20));
        FontMetrics fontMetrics = jButton.getFontMetrics(jButton.getFont());
        int n = fontMetrics.stringWidth(string);
        int n2 = imageIcon != null ? imageIcon.getIconWidth() : 0;
        int n3 = imageIcon != null ? 10 : 0;
        int n4 = n + n2 + n3 + 120;
        int n5 = Math.max(n4, 160);
        Dimension dimension = new Dimension(n5, 38);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, 38));
        return jButton;
    }

    private ImageIcon loadIcon(String string, int n, int n2) {
        try {
            String string2 = "icons/" + string + ".png";
            ImageIcon imageIcon = new ImageIcon(string2);
            if (imageIcon.getImageLoadStatus() == 8) {
                Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
                return new ImageIcon(image);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "L\u1ed7i", 0);
    }

    private void addActionToButton(String string, ActionListener actionListener) {
        Component[] componentArray;
        for (Component component : componentArray = this.getAllComponents(this)) {
            JButton jButton;
            if (!(component instanceof JButton) || !(jButton = (JButton)component).getText().equals(string)) continue;
            jButton.addActionListener(actionListener);
            break;
        }
    }

    private Component[] getAllComponents(Container container) {
        Component[] componentArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : componentArray = container.getComponents()) {
            Component[] componentArray2;
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            for (Component component2 : componentArray2 = this.getAllComponents((Container)component)) {
                arrayList.add(component2);
            }
        }
        return arrayList.toArray(new Component[0]);
    }

    private void handleExportCSV() {
        try {
            if (this.currentGroups.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Kh\u00f4ng c\u00f3 d\u1eef li\u1ec7u \u0111\u1ec3 xu\u1ea5t!", "C\u1ea3nh b\u00e1o", 2);
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("L\u01b0u file CSV");
            jFileChooser.setSelectedFile(new File("DanhSachNhomChat.csv"));
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            Object object = file.getAbsolutePath();
            if (!((String)object).toLowerCase().endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)object), StandardCharsets.UTF_8));){
                printWriter.write(65279);
                printWriter.println("ID,T\u00ean nh\u00f3m,Admin ch\u00ednh,S\u1ed1 th\u00e0nh vi\u00ean,Ng\u00e0y t\u1ea1o");
                for (ChatGroup chatGroup : this.currentGroups) {
                    String string = String.format("%d,\"%s\",\"%s\",%d,\"%s\"", chatGroup.getId(), this.escapeCsv(chatGroup.getGroupName()), this.escapeCsv(chatGroup.getCreatorName()), chatGroup.getMemberCount(), chatGroup.getCreatedAt() != null ? chatGroup.getCreatedAt().format(this.dateFormatter) : "");
                    printWriter.println(string);
                }
            }
            JOptionPane.showMessageDialog(this, "\u0110\u00e3 xu\u1ea5t " + this.currentGroups.size() + " nh\u00f3m v\u00e0o file:\n" + (String)object, "Th\u00e0nh c\u00f4ng", 1);
        }
        catch (Exception exception) {
            this.showError("L\u1ed7i xu\u1ea5t file: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String escapeCsv(String string) {
        if (string == null) {
            return "";
        }
        return string.replace("\"", "\"\"");
    }
}

